/*
 * Decompiled with CFR 0.152.
 */
package gui.program.switchnode;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.resources.ViewImageResource;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.ValidationStrategy;
import gui.commandpanels.ControlProgramTreeStructure;
import gui.commandpanels.DefaultCommandPanel;
import gui.program.switchnode.CaseCard$ChangeCaseIDListener$AjcClosure1;
import gui.program.switchnode.CaseNode;
import gui.program.switchnode.SwitchNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class CaseCard
extends DefaultCommandPanel<CaseNode> {
    private final ControlProgramTreeStructure controlProgramTreeStructure;
    private NumberField caseNumber;
    private JLabel caseNumberLabel;

    @Inject
    protected CaseCard(ViewContext view, ControlProgramTreeStructure controlProgramTreeStructure) {
        super(CaseNode.class, view);
        this.controlProgramTreeStructure = controlProgramTreeStructure;
        view.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_switch_case");
    }

    @Override
    protected void updateCard() {
        this.setTitle(((CaseNode)this.getNode()).toString());
        boolean showCaseNumberInfo = !((CaseNode)this.getNode()).isDefaultNode();
        this.caseNumberLabel.setVisible(showCaseNumberInfo);
        this.caseNumber.setVisible(showCaseNumberInfo);
        this.caseNumber.setText(String.valueOf(((CaseNode)this.getNode()).getCaseValue()));
    }

    @Override
    protected void initPanel(JPanel container) {
        TextResource textResource = (TextResource)this.getViewContext().getTextResource(TextResource.class);
        this.setTitle(((CommandNamesResource)this.getViewContext().getTextResource(CommandNamesResource.class)).Case());
        container.setLayout(new BoxLayout(container, 3));
        JLabel explanation = new JLabel(textResource.commandSwitch());
        explanation.setAlignmentX(0.5f);
        explanation.setVerticalAlignment(1);
        container.add(explanation);
        Component verticalStrut = Box.createVerticalStrut(20);
        container.add(verticalStrut);
        JPanel panel1 = new JPanel();
        panel1.setAlignmentY(0.0f);
        container.add(panel1);
        panel1.setLayout(null);
        this.caseNumberLabel = new JLabel(textResource.caseNumber());
        this.caseNumberLabel.setBounds(0, 6, 170, 32);
        panel1.add(this.caseNumberLabel);
        WidgetFactory factory = this.getViewContext().createWidgetFactory();
        this.caseNumber = factory.createNumberField((ActionListener)new ChangeCaseIDListener(), ValueConverter.DUMMY_CONVERTER);
        this.caseNumber.setHorizontalAlignment(4);
        this.caseNumber.setText("1");
        this.caseNumber.setBounds(170, 7, 170, 31);
        this.caseNumber.setColumns(5);
        this.caseNumber.setMode(Mode.WholeNumbers);
        this.caseNumber.setErrorValidationStrategy(new ValidationStrategy[]{new ValidCaseNumberStrategy()});
        panel1.add((Component)this.caseNumber);
        container.add(Box.createVerticalStrut(220));
        JPanel panel = new JPanel();
        container.add(panel);
        JButton removeThisCase = new JButton(ViewImageResource.gtkRemove());
        removeThisCase.setBounds(5, 5, 50, 27);
        removeThisCase.addActionListener(new RemoveCaseFromSwitch());
        panel.setLayout(null);
        panel.add(removeThisCase);
        JLabel lblNewLabel = new JLabel(textResource.removeThisSwitchCase());
        lblNewLabel.setBounds(60, 10, 397, 15);
        panel.add(lblNewLabel);
    }

    private final class ChangeCaseIDListener
    implements ActionListener {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private ChangeCaseIDListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DisplayMessageFactory.hasError((Component)CaseCard.this.caseNumber)) {
                CaseCard.this.caseNumber.setText(String.valueOf(((CaseNode)CaseCard.this.getNode()).getCaseValue()));
            } else {
                this.requestApply();
            }
        }

        @CompoundProgramChange
        public void requestApply() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            Object[] objectArray = new Object[]{this, joinPoint};
            CaseCard$ChangeCaseIDListener$AjcClosure1 caseCard$ChangeCaseIDListener$AjcClosure1 = new CaseCard$ChangeCaseIDListener$AjcClosure1(objectArray);
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(caseCard$ChangeCaseIDListener$AjcClosure1.linkClosureAndJoinPoint(69648));
        }

        static {
            ChangeCaseIDListener.ajc$preClinit();
        }

        static final /* synthetic */ void requestApply_aroundBody0(ChangeCaseIDListener ajc$this, JoinPoint joinPoint) {
            int caseValue = PrimitiveUtils.parseInteger((String)ajc$this.CaseCard.this.caseNumber.getText(), (int)0);
            if (((CaseNode)ajc$this.CaseCard.this.getNode()).getCaseValue() != caseValue) {
                ((CaseNode)ajc$this.CaseCard.this.getNode()).setCaseValue(caseValue);
                SwitchNode switchNode = ((CaseNode)ajc$this.CaseCard.this.getNode()).getSwitchNode();
                switchNode.reorderCaseNodeInTree((CaseNode)ajc$this.CaseCard.this.getNode());
                ajc$this.CaseCard.this.controlProgramTreeStructure.makeChildrenVisible((TreeNode)ajc$this.CaseCard.this.getNode());
                ((CaseNode)ajc$this.CaseCard.this.getNode()).setSelected();
            }
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("CaseCard.java", ChangeCaseIDListener.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "requestApply", "gui.program.switchnode.CaseCard$ChangeCaseIDListener", "", "", "", "void"), 157);
        }
    }

    private final class RemoveCaseFromSwitch
    implements ActionListener {
        private RemoveCaseFromSwitch() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractProgramNode previousSibling = (AbstractProgramNode)((CaseNode)CaseCard.this.getNode()).getPreviousSibling();
            SwitchNode switchNode = ((CaseNode)CaseCard.this.getNode()).getSwitchNode();
            switchNode.removeCase((CaseNode)CaseCard.this.getNode());
            if (previousSibling == null) {
                previousSibling = switchNode;
            }
            previousSibling.setSelected();
        }
    }

    private final class ValidCaseNumberStrategy
    implements ValidationStrategy {
        private ValidCaseNumberStrategy() {
        }

        public boolean isValid(String uncheckedString) {
            if (PrimitiveUtils.isInteger((String)uncheckedString)) {
                int caseValue = PrimitiveUtils.parseInteger((String)uncheckedString, (int)0);
                if (((CaseNode)CaseCard.this.getNode()).getCaseValue() == caseValue) {
                    return true;
                }
                return ((CaseNode)CaseCard.this.getNode()).getSwitchNode().isValidCase(caseValue);
            }
            return false;
        }

        public String getErrorMessage(String uncheckedString) {
            TextResource textResource = (TextResource)CaseCard.this.getViewContext().getTextResource(TextResource.class);
            if (StringUtils.isNullOrOnlyWhitespace((String)uncheckedString)) {
                return "";
            }
            if (PrimitiveUtils.isInteger((String)uncheckedString)) {
                int value = PrimitiveUtils.parseInteger((String)uncheckedString, (int)0);
                return textResource.theCaseGivenHasAlreadyBeenDefined(value);
            }
            try {
                new BigInteger(uncheckedString);
                return textResource.wholeNumberOutOfRange(Integer.MIN_VALUE, "", Integer.MAX_VALUE);
            }
            catch (NumberFormatException numberFormatException) {
                return textResource.notANumber();
            }
        }
    }
}

