/*
 * Decompiled with CFR 0.152.
 */
package gui.program.switchnode;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import gui.program.EntityFactory;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import gui.program.switchnode.CaseNode;
import java.util.Collections;
import java.util.Map;

public class CaseNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<CaseNode> {
    private static final String CASE_VALUE = "caseValue";
    private final EntityFactory entityFactory;

    public CaseNodeConversionStrategy(EntityFactory entityFactory) {
        super(CaseNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToAttributes(CaseNode node, PersistWriter writer) {
        writer.addAttribute(CASE_VALUE, node.getCaseValue());
    }

    @Override
    protected CaseNode createNode(PersistReader reader) {
        CaseNode result = this.entityFactory.createCase(0);
        result.removeAllChildren();
        return result;
    }

    @Override
    public void readFromAttributes(CaseNode node, PersistReader reader) {
        node.setCaseValue(reader.getIntegerAttribute(CASE_VALUE));
    }

    @Override
    public Map<String, Class<? extends CaseNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Case", CaseNode.class);
    }
}

