/*
 * Decompiled with CFR 0.152.
 */
package gui.program.switchnode;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.rules.ProgramNodeInsertionRule;
import gui.program.SuppressedNode;
import gui.program.switchnode.CaseNode;
import gui.program.switchnode.SwitchNode;
import gui.tools.LanguagePack;

public class CasesCanOnlyBeAddedToSwitchRule
implements ProgramNodeInsertionRule {
    private static final int IS_CASE_AND_SWITCH_NODE = 3;
    private static final int SWITCH_NODE_ONLY = 2;
    private static final int CASE_NODE_ONLY = 1;
    private static final int IS_NEITHER = 0;

    public boolean canInsert(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        int state = this.getCaseAndSwitchNodeState(toInsert, parent);
        switch (state) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: {
                return false;
            }
            case 3: {
                CaseNode caseNode = this.getCase(toInsert);
                SwitchNode switchNode = (SwitchNode)parent;
                return switchNode.isValidCase(caseNode);
            }
        }
        return true;
    }

    public String getErrorMessage(AbstractProgramNode toInsert, AbstractProgramNode parent, int index) {
        int state = this.getCaseAndSwitchNodeState(toInsert, parent);
        switch (state) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: {
                return LanguagePack.getTextResource().canOnlyAddCasesToSwitchNode();
            }
            case 3: {
                CaseNode caseNode = this.getCase(toInsert);
                if (caseNode != null) {
                    return LanguagePack.getTextResource().caseIsAlreadyTaken(caseNode.getCaseValue());
                }
                return null;
            }
        }
        return null;
    }

    private int getCaseAndSwitchNodeState(AbstractProgramNode toInsert, AbstractProgramNode parent) {
        return (this.getCase(toInsert) != null ? 1 : 0) + (parent instanceof SwitchNode ? 2 : 0);
    }

    private CaseNode getCase(AbstractProgramNode toInsert) {
        if (toInsert instanceof SuppressedNode) {
            toInsert = ((SuppressedNode)toInsert).getSuppressedNode();
        }
        if (toInsert instanceof CaseNode) {
            return (CaseNode)toInsert;
        }
        return null;
    }
}

