/*
 * Decompiled with CFR 0.152.
 */
package gui.program.switchnode;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.expression.field.ExpressionField;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.program.CommandPanel;
import gui.commandpanels.ControlProgramTreeStructure;
import gui.program.EntityFactory;
import gui.program.switchnode.CaseNode;
import gui.program.switchnode.SwitchCard$AddCaseToSwitchListener$AjcClosure1;
import gui.program.switchnode.SwitchCard$AddRemoveDefaultCaseListener$AjcClosure1;
import gui.program.switchnode.SwitchNode;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class SwitchCard
extends CommandPanel<SwitchNode> {
    private final ControlProgramTreeStructure controlProgramTreeStructure;
    private final EntityFactory entityFactory;
    private ExpressionField expressionField;
    private NumberField addCaseValue;
    private JComboBox availableCases;
    private JCheckBox defaultCaseSelected;
    private TextResource textResource;

    @Inject
    private SwitchCard(ViewContext view, EntityFactory entityFactory, ControlProgramTreeStructure controlProgramTreeStructure, ExpressionField expressionField) {
        super(SwitchNode.class);
        this.entityFactory = entityFactory;
        this.controlProgramTreeStructure = controlProgramTreeStructure;
        this.expressionField = expressionField;
        this.textResource = (TextResource)view.getTextResource(TextResource.class);
        this.initComponents(view);
        view.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_switch_condition");
    }

    @Override
    protected void updateCard() {
        this.expressionField.setNodeWithExpression((ExpressionNodeProperty)this.getNode());
        this.initializeAvailableCases();
        this.addCaseValue.setText(this.getNextCaseValue(1));
        this.defaultCaseSelected.setSelected(((SwitchNode)this.getNode()).hasDefaultCase());
    }

    private String getNextCaseValue(int caseValue) {
        while (!((SwitchNode)this.getNode()).isValidCase(caseValue)) {
            ++caseValue;
        }
        return String.valueOf(caseValue);
    }

    private void initializeAvailableCases() {
        ArrayList<CaseNode> children = new ArrayList<CaseNode>(((SwitchNode)this.getNode()).getCases());
        if (children.isEmpty()) {
            children.add((CaseNode)((Object)this.textResource.noSelection()));
        }
        this.availableCases.setModel(new DefaultComboBoxModel<Object>(children.toArray()));
    }

    private void initComponents(ViewContext view) {
        WidgetFactory factory = view.createWidgetFactory();
        CommandNamesResource commandNamesResource = (CommandNamesResource)view.getTextResource(CommandNamesResource.class);
        String switchName = commandNamesResource.Switch();
        TextResource resource = (TextResource)view.getTextResource(TextResource.class);
        this.expressionField.setHorizontalAlignment(0);
        this.defaultCaseSelected = factory.createCheckBox(commandNamesResource.DefaultCase());
        this.defaultCaseSelected.addActionListener(new AddRemoveDefaultCaseListener());
        JButton addCaseWithValue = factory.createButton((Action)((Object)new AddCaseToSwitchListener()));
        this.addCaseValue = factory.createNumberField((ActionListener)new DummyActionListener(), ValueConverter.DUMMY_CONVERTER);
        JButton removeSelectedCase = factory.createButton((Action)((Object)new RemoveCaseFromListener()));
        this.availableCases = factory.createComboBox();
        this.availableCases.addItem(this.textResource.noSelection());
        view.createFormBuilder().headerLabel(switchName, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().spacer().end().description(resource.commandSwitch(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS, FormBuilder.PanelConstraints.SPAN_5_ROWS}).spacer().end(5).label(switchName, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().component((JComponent)this.expressionField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().spacer().end().component((JComponent)this.defaultCaseSelected, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().spacer().end().component((JComponent)this.createPanel(addCaseWithValue, commandNamesResource.Case()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS, FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.addCaseValue, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().spacer().end().component((JComponent)this.createPanel(removeSelectedCase, commandNamesResource.Case()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS, FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.availableCases, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().spacer().end().setOnPanel((JPanel)((Object)this));
        this.addCaseValue.setText("1");
        this.addCaseValue.setErrorValidationStrategy(new ValidationStrategy[]{new SwitchCaseValidator()});
        this.addCaseValue.setMode(Mode.WholeNumbers);
    }

    private JPanel createPanel(JButton addCaseWithValue, String aCase) {
        return new JPanel(new FlowLayout(0, 0, 0), addCaseWithValue, aCase){
            {
                this.setBorder(BorderFactory.createEmptyBorder());
                this.setOpaque(false);
                this.add(jButton);
                this.add(new JLabel("   "));
                this.add(new JLabel(string));
                this.add(new JLabel("   "));
            }
        };
    }

    private final class AddCaseToSwitchListener
    extends AbstractActionDefinition {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public AddCaseToSwitchListener() {
            this.putValue("SmallIcon", ViewImageResource.gtkAdd());
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
        }

        @CompoundProgramChange
        public void actionPerformed(ActionEvent e) {
            ActionEvent actionEvent = e;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)actionEvent);
            Object[] objectArray = new Object[]{this, actionEvent, joinPoint};
            SwitchCard$AddCaseToSwitchListener$AjcClosure1 switchCard$AddCaseToSwitchListener$AjcClosure1 = new SwitchCard$AddCaseToSwitchListener$AjcClosure1(objectArray);
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(switchCard$AddCaseToSwitchListener$AjcClosure1.linkClosureAndJoinPoint(69648));
        }

        static {
            AddCaseToSwitchListener.ajc$preClinit();
        }

        static final /* synthetic */ void actionPerformed_aroundBody0(AddCaseToSwitchListener ajc$this, ActionEvent e, JoinPoint joinPoint) {
            if (!PrimitiveUtils.isInteger((String)ajc$this.SwitchCard.this.addCaseValue.getText())) {
                return;
            }
            int caseValue = PrimitiveUtils.parseInteger((String)ajc$this.SwitchCard.this.addCaseValue.getText(), (int)-1);
            SwitchNode switchNode = (SwitchNode)ajc$this.SwitchCard.this.getNode();
            if (switchNode.isValidCase(caseValue)) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)ajc$this.SwitchCard.this.availableCases.getModel();
                CaseNode caseNodeToAdd = ajc$this.SwitchCard.this.entityFactory.createCase(caseValue);
                switchNode.addCase(caseNodeToAdd);
                ajc$this.SwitchCard.this.controlProgramTreeStructure.makeChildrenVisible((TreeNode)((Object)caseNodeToAdd));
                switchNode.setSelected();
                int indexAdded = switchNode.getIndex((TreeNode)((Object)caseNodeToAdd));
                if (indexAdded > ajc$this.SwitchCard.this.availableCases.getModel().getSize()) {
                    model.addElement(caseNodeToAdd);
                } else {
                    model.insertElementAt(caseNodeToAdd, indexAdded);
                }
                model.removeElement(ajc$this.SwitchCard.this.textResource.noSelection());
            }
            ajc$this.SwitchCard.this.addCaseValue.setText(ajc$this.SwitchCard.this.getNextCaseValue(caseValue));
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("SwitchCard.java", AddCaseToSwitchListener.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "actionPerformed", "gui.program.switchnode.SwitchCard$AddCaseToSwitchListener", "java.awt.event.ActionEvent", "e", "", "void"), 201);
        }
    }

    public class AddRemoveDefaultCaseListener
    implements ActionListener {
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        @Override
        @CompoundProgramChange
        public void actionPerformed(ActionEvent e) {
            ActionEvent actionEvent = e;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)actionEvent);
            Object[] objectArray = new Object[]{this, actionEvent, joinPoint};
            SwitchCard$AddRemoveDefaultCaseListener$AjcClosure1 switchCard$AddRemoveDefaultCaseListener$AjcClosure1 = new SwitchCard$AddRemoveDefaultCaseListener$AjcClosure1(objectArray);
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(switchCard$AddRemoveDefaultCaseListener$AjcClosure1.linkClosureAndJoinPoint(69648));
        }

        static {
            AddRemoveDefaultCaseListener.ajc$preClinit();
        }

        static final /* synthetic */ void actionPerformed_aroundBody0(AddRemoveDefaultCaseListener ajc$this, ActionEvent e, JoinPoint joinPoint) {
            SwitchNode switchNode = (SwitchNode)ajc$this.SwitchCard.this.getNode();
            if (switchNode.hasDefaultCase()) {
                switchNode.removeDefaultCase();
            } else {
                CaseNode caseNodeToAdd = ajc$this.SwitchCard.this.entityFactory.createDefaultCase();
                switchNode.addCase(caseNodeToAdd);
                ajc$this.SwitchCard.this.controlProgramTreeStructure.makeChildrenVisible((TreeNode)((Object)caseNodeToAdd));
                switchNode.setSelected();
            }
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("SwitchCard.java", AddRemoveDefaultCaseListener.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "actionPerformed", "gui.program.switchnode.SwitchCard$AddRemoveDefaultCaseListener", "java.awt.event.ActionEvent", "e", "", "void"), 230);
        }
    }

    private static class DummyActionListener
    implements ActionListener {
        private DummyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private final class RemoveCaseFromListener
    extends AbstractActionDefinition {
        public RemoveCaseFromListener() {
            this.putValue("SmallIcon", ViewImageResource.gtkRemove());
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.isCaseSelected(SwitchCard.this.availableCases)) {
                CaseNode selectedCase = (CaseNode)SwitchCard.this.availableCases.getSelectedItem();
                ((SwitchNode)SwitchCard.this.getNode()).removeCase(selectedCase);
                ((DefaultComboBoxModel)SwitchCard.this.availableCases.getModel()).removeElementAt(SwitchCard.this.availableCases.getSelectedIndex());
                if (SwitchCard.this.availableCases.getItemCount() == 0) {
                    ((DefaultComboBoxModel)SwitchCard.this.availableCases.getModel()).addElement(SwitchCard.this.textResource.noSelection());
                }
            }
        }

        private boolean isCaseSelected(JComboBox availableCases) {
            return availableCases.getSelectedItem() instanceof CaseNode;
        }
    }

    private final class SwitchCaseValidator
    implements ValidationStrategy {
        private SwitchCaseValidator() {
        }

        public boolean isValid(String uncheckedString) {
            if (PrimitiveUtils.isInteger((String)uncheckedString)) {
                return ((SwitchNode)SwitchCard.this.getNode()).isValidCase(PrimitiveUtils.parseInteger((String)uncheckedString, (int)0));
            }
            return false;
        }

        public String getErrorMessage(String uncheckedString) {
            if (StringUtils.isNullOrOnlyWhitespace((String)uncheckedString)) {
                return "";
            }
            if (PrimitiveUtils.isInteger((String)uncheckedString)) {
                int value = PrimitiveUtils.parseInteger((String)uncheckedString, (int)0);
                return SwitchCard.this.textResource.theCaseGivenHasAlreadyBeenDefined(value);
            }
            try {
                new BigInteger(uncheckedString);
                return SwitchCard.this.textResource.wholeNumberOutOfRange(Integer.MIN_VALUE, "", Integer.MAX_VALUE);
            }
            catch (NumberFormatException numberFormatException) {
                return SwitchCard.this.textResource.notANumber();
            }
        }
    }
}

