/*
 * Decompiled with CFR 0.152.
 */
package gui.program.switchnode;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.EditProgramService;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.program.nodes.ProgramNodeTypeImpl;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChangeAspect;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.swing.expression.Expression;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.util.CollectionUtils;
import com.ur.util.logging.Log;
import com.ur.view.program.CommandPanel;
import com.ur.view.program.CommandPanelProvider;
import com.ur.view.variables.core.ProgramVariable;
import gui.program.PlaceholderNode;
import gui.program.SuppressedNode;
import gui.program.switchnode.CaseNode;
import gui.program.switchnode.SwitchCard;
import gui.program.switchnode.SwitchNode$AjcClosure1;
import gui.program.switchnode.SwitchNode$AjcClosure3;
import gui.program.switchnode.SwitchVariableNameProvider;
import gui.tools.LanguagePack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class SwitchNode
extends AbstractProgramNode
implements Cloneable,
ExpressionNodeProperty,
CommandPanelProvider {
    private final EditProgramService editProgramService;
    private final SwitchVariableNameProvider switchVariableNameProvider;
    private Expression expression = new Expression();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    public SwitchNode(EditProgramService editProgramService, SwitchVariableNameProvider switchVariableNameProvider) {
        super((ProgramNodeType)new ProgramNodeTypeImpl(true, false));
        this.editProgramService = editProgramService;
        this.switchVariableNameProvider = switchVariableNameProvider;
        this.setNodeTypeName(LanguagePack.getCommandNamesResource().Switch());
    }

    @Override
    public Class<? extends CommandPanel<? extends AbstractProgramNode>> getCardClass() {
        return SwitchCard.class;
    }

    public boolean isUndefined() {
        HashSet<Integer> caseValues = new HashSet<Integer>();
        for (CaseNode each : this.getCases()) {
            if (caseValues.add(each.getCaseValue())) continue;
            return true;
        }
        if (this.getCases().isEmpty()) {
            return true;
        }
        return this.expression.isUndefined() || super.isUndefined();
    }

    public List<CaseNode> getCases() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return CollectionUtils.filter((Iterable)this.children, CaseNode.class);
    }

    private List<CaseNode> getAllCases() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        ArrayList<CaseNode> result = new ArrayList<CaseNode>();
        for (Object each : this.children) {
            if (each instanceof PlaceholderNode) continue;
            if (each instanceof SuppressedNode) {
                AbstractProgramNode suppressedNode = ((SuppressedNode)each).getSuppressedNode();
                result.add((CaseNode)suppressedNode);
                continue;
            }
            result.add((CaseNode)each);
        }
        return result;
    }

    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        if (this.isUndefined()) {
            Log.info((String)"Trying to generate code for undefined switch node");
        } else {
            ProgramVariable variable = this.switchVariableNameProvider.create();
            this.applyVariableToCases(variable);
            this.scriptBegin(writer);
            writer.writeProgramLabel((ControllerInterfaceProgramNode)this);
            writer.assign(variable.getName(), this.expression.getScriptCodeText());
            writer.writeChildren((Iterable)this.children);
            this.scriptEnd(writer);
            this.applyVariableToCases(ProgramVariable.NULL);
            this.switchVariableNameProvider.destroy(variable);
        }
        return writer;
    }

    private void applyVariableToCases(ProgramVariable variable) {
        for (CaseNode each : this.getAllCases()) {
            each.setVariable(variable);
        }
    }

    public ExpressionBranchNode getExpression() {
        return this.expression.getExpression();
    }

    @ProgramNodeChange
    @ProgramEntitiesChange
    public void setExpression(ExpressionBranchNode expressionTree) {
        ExpressionBranchNode expressionBranchNode = expressionTree;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)expressionBranchNode);
        Object[] objectArray = new Object[]{this, expressionBranchNode, joinPoint};
        SwitchNode$AjcClosure3 switchNode$AjcClosure3 = new SwitchNode$AjcClosure3(objectArray);
        try {
            ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(switchNode$AjcClosure3.linkStackClosureAndJoinPoint(69648));
            switchNode$AjcClosure3.unlink();
        }
        catch (Throwable throwable) {
            switchNode$AjcClosure3.unlink();
            throw throwable;
        }
    }

    public boolean isValidCase(int caseValue) {
        for (CaseNode each : this.getCases()) {
            if (each.getCaseValue() != caseValue) continue;
            return false;
        }
        return true;
    }

    public boolean isValidCase(CaseNode caseNode) {
        for (CaseNode each : this.getCases()) {
            if (each == caseNode || each.getCaseValue() != caseNode.getCaseValue()) continue;
            return false;
        }
        return true;
    }

    public void reorderCaseNodeInTree(CaseNode caseNodeToReinsert) {
        CaseNode caseNodeToReinsertClone = caseNodeToReinsert.clone();
        this.editProgramService.deleteNode((AbstractProgramNode)caseNodeToReinsert);
        this.addCase(caseNodeToReinsertClone);
    }

    public void addCase(CaseNode caseNodeToAdd) {
        if (this.children == null || this.children.isEmpty()) {
            this.editProgramService.addNode((AbstractProgramNode)caseNodeToAdd, (AbstractProgramNode)this);
            return;
        }
        AbstractProgramNode insertNode = this.getNodeToInsertNode(caseNodeToAdd);
        if (insertNode instanceof SwitchNode) {
            this.editProgramService.insertNodeBefore((AbstractProgramNode)caseNodeToAdd, (AbstractProgramNode)this.children.get(0));
            return;
        }
        this.editProgramService.insertNodeAfter((AbstractProgramNode)caseNodeToAdd, insertNode);
    }

    AbstractProgramNode getNodeToInsertNode(CaseNode caseNodeToAdd) {
        SuppressedNode node;
        if (this.children != null && this.children.size() == 1 && this.children.get(0) instanceof PlaceholderNode) {
            return (PlaceholderNode)this.children.get(0);
        }
        AbstractProgramNode nodeToInsertAfter = this;
        List<CaseNode> cases = this.getAllCases();
        for (CaseNode each : cases) {
            if (caseNodeToAdd.getCaseValue() < each.getCaseValue()) break;
            nodeToInsertAfter = each;
        }
        if (!this.getCases().contains(nodeToInsertAfter) && (node = this.getSuppressingWrapperNodeForCase(nodeToInsertAfter)) != null) {
            return node;
        }
        return nodeToInsertAfter;
    }

    SuppressedNode getSuppressingWrapperNodeForCase(AbstractProgramNode node) {
        List suppressedNodes = CollectionUtils.filter((Iterable)this.children, SuppressedNode.class);
        for (SuppressedNode supNode : suppressedNodes) {
            if (!supNode.getSuppressedNode().equals(node)) continue;
            return supNode;
        }
        return null;
    }

    int getIndexToInsertNode(CaseNode caseNodeToAdd) {
        List<CaseNode> cases = this.getAllCases();
        if (cases.isEmpty()) {
            return 0;
        }
        if (this.children != null && this.children.size() == 1 && this.children.get(0) instanceof PlaceholderNode) {
            return 0;
        }
        CaseNode lastNode = null;
        for (CaseNode each : cases) {
            if (caseNodeToAdd.shouldComeBefore(each)) {
                return cases.indexOf(each);
            }
            lastNode = each;
        }
        if (lastNode == null) {
            return this.getChildCount();
        }
        return cases.indexOf(lastNode) + 1;
    }

    public void removeCase(CaseNode selectedCase) {
        this.editProgramService.deleteNode((AbstractProgramNode)selectedCase);
        this.editProgramService.setSelected((AbstractProgramNode)this);
    }

    public void removeDefaultCase() {
        if (this.hasDefaultCase()) {
            this.removeCase((CaseNode)this.children.get(this.children.size() - 1));
        }
    }

    public boolean hasDefaultCase() {
        if (this.getChildCount() > 0) {
            Object child = this.children.get(this.children.size() - 1);
            return child instanceof CaseNode && ((CaseNode)child).isDefaultNode();
        }
        return false;
    }

    protected void getInternalProgramEntities(Collection<Object> collection) {
        this.expression.getExpression().getProgramEntities(collection);
        super.getInternalProgramEntities(collection);
    }

    protected boolean doSubstituteReference(Object original, Object substitute) {
        return this.expression.getExpression().substituteReference(original, substitute);
    }

    public SwitchNode clone() {
        SwitchNode clone = (SwitchNode)super.clone();
        clone.expression = this.expression.clone();
        return clone;
    }

    public String toString() {
        if (this.getExpression().isUndefined()) {
            return String.valueOf(LanguagePack.getCommandNamesResource().Switch()) + " ...";
        }
        return String.valueOf(LanguagePack.getCommandNamesResource().Switch()) + " " + this.expression.getText();
    }

    static {
        SwitchNode.ajc$preClinit();
    }

    static final /* synthetic */ void setExpression_aroundBody0(SwitchNode ajc$this, ExpressionBranchNode expressionTree, JoinPoint joinPoint) {
        ajc$this.expression.setExpression(expressionTree);
        ajc$this.textHasChanged();
    }

    static final /* synthetic */ void setExpression_aroundBody2(SwitchNode switchNode, ExpressionBranchNode expressionBranchNode, JoinPoint joinPoint) {
        Object[] objectArray = new Object[]{switchNode, expressionBranchNode, joinPoint};
        SwitchNode$AjcClosure1 switchNode$AjcClosure1 = new SwitchNode$AjcClosure1(objectArray);
        try {
            ProgramEntitiesChangeAspect.aspectOf().aroundAnnotatedMethod(switchNode$AjcClosure1.linkStackClosureAndJoinPoint(69648));
            switchNode$AjcClosure1.unlink();
        }
        catch (Throwable throwable) {
            switchNode$AjcClosure1.unlink();
            throw throwable;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SwitchNode.java", SwitchNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setExpression", "gui.program.switchnode.SwitchNode", "com.ur.swing.expression.ExpressionBranchNode", "expressionTree", "", "void"), 122);
    }
}

