/*
 * Decompiled with CFR 0.152.
 */
package gui.program.switchnode;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.swing.expression.ExpressionBranchNode;
import gui.program.EntityFactory;
import gui.program.persistence.ProgramNodeConversionStrategyBase;
import gui.program.switchnode.SwitchNode;
import java.util.Collections;
import java.util.Map;

public class SwitchNodeConversionStrategy
extends ProgramNodeConversionStrategyBase<SwitchNode> {
    private static final String EXPRESSION = "expression";
    private final EntityFactory entityFactory;

    public SwitchNodeConversionStrategy(EntityFactory entityFactory) {
        super(SwitchNode.class);
        this.entityFactory = entityFactory;
    }

    @Override
    public void writeToChildNodes(SwitchNode node, PersistWriter writer) {
        writer.writeNodeWithValue(EXPRESSION, (Object)node.getExpression());
    }

    @Override
    protected SwitchNode createNode(PersistReader reader) {
        SwitchNode result = this.entityFactory.createSwitch();
        result.removeAllChildren();
        return result;
    }

    @Override
    public boolean tryReadFromChildNode(SwitchNode node, PersistReader reader) {
        String nodeName = reader.getNodeName();
        if (EqualsUtil.equals((Object)EXPRESSION, (Object)nodeName)) {
            node.setExpression((ExpressionBranchNode)reader.convertContainedValue(ExpressionBranchNode.class));
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Class<? extends SwitchNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap("Switch", SwitchNode.class);
    }
}

