/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.program.nodes.ProgramNodeTypeImpl;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.reversible.Reversible;
import com.ur.view.domain.program.services.SilentEditProgramService;
import gui.program.EntityFactory;
import gui.program.PlaceholderNode;
import gui.program.ProgramUndoRedoService;
import gui.program.until.ToggleAllowChildrenService$AjcClosure1;
import gui.program.until.UntilNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ToggleAllowChildrenService {
    private final EntityFactory entityFactory;
    private final SilentEditProgramService editProgramService;
    private final ProgramUndoRedoService undoRedoService;
    private View view;
    private NodeProvider nodeProvider;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    public ToggleAllowChildrenService(EntityFactory entityFactory, SilentEditProgramService editProgramService, ProgramUndoRedoService undoRedoService) {
        this.entityFactory = entityFactory;
        this.editProgramService = editProgramService;
        this.undoRedoService = undoRedoService;
    }

    public void bind(View view, NodeProvider nodeProvider) {
        this.nodeProvider = nodeProvider;
        this.view = view;
    }

    public boolean setChildrenAllowed(boolean childrenAllowed) {
        UntilNode node = this.nodeProvider.getNode();
        if (childrenAllowed) {
            boolean added = this.addPlaceHolder(node);
            if (added) {
                this.undoRedoService.consume(new ReversibleAllowChildren(node));
            }
            return added;
        }
        RemovalResult removedChildren = this.removeChildren(node);
        if (removedChildren.success) {
            this.undoRedoService.consume(new ReversibleRemoveChildren(node, removedChildren.children));
        }
        return removedChildren.success;
    }

    public void update() {
        this.view.setToggled(this.nodeProvider.getNode().getNodeType().isChildrenAllowed());
    }

    private boolean addPlaceHolder(UntilNode node) {
        this.setProgramNodeType(node, (ProgramNodeType)new ProgramNodeTypeImpl(true, true));
        PlaceholderNode placeholderNode = this.entityFactory.createPlaceholderNode();
        if (!this.editProgramService.addNode(placeholderNode, node)) {
            this.setProgramNodeType(node, (ProgramNodeType)new ProgramNodeTypeImpl(false, false));
            return false;
        }
        return true;
    }

    private RemovalResult removeChildren(UntilNode parent) {
        this.setProgramNodeType(parent, (ProgramNodeType)new ProgramNodeTypeImpl(true, false));
        ArrayList<AbstractProgramNode> removedChildren = new ArrayList<AbstractProgramNode>();
        while (parent.children().hasMoreElements()) {
            AbstractProgramNode child = (AbstractProgramNode)parent.children().nextElement();
            Collection<AbstractProgramNode> removed = this.editProgramService.deleteNode(child);
            if (removed == null || !removed.contains(child)) {
                this.setProgramNodeType(parent, (ProgramNodeType)new ProgramNodeTypeImpl(true, true));
                return new RemovalResult(false, removedChildren);
            }
            removedChildren.addAll(removed);
        }
        this.setProgramNodeType(parent, (ProgramNodeType)new ProgramNodeTypeImpl(false, false));
        return new RemovalResult(true, removedChildren);
    }

    @IgnoreProgramChanges
    private void setProgramNodeType(UntilNode node, ProgramNodeType type) {
        UntilNode untilNode = node;
        ProgramNodeType programNodeType = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)untilNode, (Object)programNodeType);
        Object[] objectArray = new Object[]{this, untilNode, programNodeType, joinPoint};
        ToggleAllowChildrenService$AjcClosure1 toggleAllowChildrenService$AjcClosure1 = new ToggleAllowChildrenService$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(toggleAllowChildrenService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static {
        ToggleAllowChildrenService.ajc$preClinit();
    }

    static final /* synthetic */ void setProgramNodeType_aroundBody0(ToggleAllowChildrenService ajc$this, UntilNode node, ProgramNodeType type, JoinPoint joinPoint) {
        node.setProgramNodeType(type);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ToggleAllowChildrenService.java", ToggleAllowChildrenService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "setProgramNodeType", "gui.program.until.ToggleAllowChildrenService", "gui.program.until.UntilNode:com.ur.polyscope.program.nodes.ProgramNodeType", "node:type", "", "void"), 174);
    }

    public static interface NodeProvider {
        public UntilNode getNode();
    }

    private static class RemovalResult {
        public final boolean success;
        public final List<AbstractProgramNode> children;

        RemovalResult(boolean success, List<AbstractProgramNode> children) {
            this.success = success;
            this.children = children;
        }
    }

    private class ReversibleAllowChildren
    implements Reversible<AbstractProgramNode> {
        private final UntilNode node;
        private boolean isUndo;

        ReversibleAllowChildren(UntilNode node) {
            this(node, true);
        }

        ReversibleAllowChildren(UntilNode node, boolean isUndo) {
            this.node = node;
            this.isUndo = isUndo;
        }

        public AbstractProgramNode getTarget() {
            return this.node;
        }

        public void undo() {
            boolean success;
            boolean bl = success = this.isUndo ? ((ToggleAllowChildrenService)ToggleAllowChildrenService.this).removeChildren((UntilNode)this.node).success : ToggleAllowChildrenService.this.addPlaceHolder(this.node);
            if (success) {
                ToggleAllowChildrenService.this.undoRedoService.consume(new ReversibleAllowChildren(this.node, !this.isUndo));
            }
        }
    }

    private class ReversibleRemoveChildren
    implements Reversible<AbstractProgramNode> {
        private final UntilNode node;
        private final List<AbstractProgramNode> children;
        private final boolean isUndo;

        ReversibleRemoveChildren(UntilNode node, List<AbstractProgramNode> children) {
            this(node, children, true);
        }

        ReversibleRemoveChildren(UntilNode node, List<AbstractProgramNode> children, boolean isUndo) {
            this.node = node;
            this.children = children;
            this.isUndo = isUndo;
        }

        public AbstractProgramNode getTarget() {
            return this.node;
        }

        public void undo() {
            boolean success;
            boolean bl = success = this.isUndo ? this.addChildren() : ((ToggleAllowChildrenService)ToggleAllowChildrenService.this).removeChildren((UntilNode)this.node).success;
            if (success) {
                ToggleAllowChildrenService.this.undoRedoService.consume(new ReversibleRemoveChildren(this.node, this.children, !this.isUndo));
            }
        }

        private boolean addChildren() {
            ToggleAllowChildrenService.this.setProgramNodeType(this.node, (ProgramNodeType)new ProgramNodeTypeImpl(true, true));
            for (AbstractProgramNode child : this.children) {
                if (ToggleAllowChildrenService.this.editProgramService.addNode(child, this.node)) continue;
                ToggleAllowChildrenService.this.setProgramNodeType(this.node, (ProgramNodeType)new ProgramNodeTypeImpl(false, false));
                return false;
            }
            return true;
        }
    }

    public static interface View {
        public void setToggled(boolean var1);
    }
}

