/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until;

import com.ur.i18n.TextResource;
import com.ur.injection.Builder;
import com.ur.polyscope.program.nodes.ProgramNodeCardContribution;
import com.ur.polyscope.program.nodes.until.contribution.UntilNodeContribution;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.flippable.FlippablePanel;
import gui.program.until.ToggleAllowChildrenService;
import gui.program.until.UntilNode;
import gui.program.until.types.NullUntilTypeNode;
import gui.program.until.types.UntilTypeCard;
import gui.tools.LegacyURDialogCreator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.JPanel;

public abstract class UntilCard
extends UntilTypeCard {
    public static final String ADD_ACTIONS_SWITCH = "addActions." + UntilCard.class.getSimpleName();
    protected final Set<UntilNodeContribution> untilNodeContributions;
    protected final ViewContext viewContext;
    protected final Builder builder;
    protected final ToggleAllowChildrenService toggleAllowChildrenService;
    protected final FlippablePanel flippablePanel = new FlippablePanel();
    protected final Set<ProgramNodeCardContribution> programNodeCardContributions;
    protected final List<UntilNodeContribution> untilConditionOptions;
    private final Map<UntilTypeNode.Type, Class<? extends CardPanel>> cardMap = new HashMap<UntilTypeNode.Type, Class<? extends CardPanel>>();

    @Inject
    public UntilCard(Set<UntilNodeContribution> untilNodeContributions, ViewContext viewContext, Builder builder, ToggleAllowChildrenService toggleAllowChildrenService, Set<ProgramNodeCardContribution> programNodeCardContributions) {
        super(viewContext);
        this.untilNodeContributions = untilNodeContributions;
        this.viewContext = viewContext;
        this.builder = builder;
        this.toggleAllowChildrenService = toggleAllowChildrenService;
        this.programNodeCardContributions = programNodeCardContributions;
        for (UntilNodeContribution each : untilNodeContributions) {
            this.cardMap.put(each.getUntilTypeNode().getType(), each.getCardClass());
        }
        this.untilConditionOptions = this.getUntilConditionOptions(untilNodeContributions);
        this.initComponents();
    }

    @Override
    protected abstract void initComponents();

    @Override
    public void updateCard() {
        UntilNode node = (UntilNode)this.getNode();
        UntilTypeNode.Type type = node.getSelectedTypeNode().getType();
        Class cardPanelClass = node.getSelectedTypeNode() instanceof NullUntilTypeNode ? UntilCard.class : this.cardMap.get(type);
        this.flippablePanel.switchTo(cardPanelClass, (Object)node);
        this.flippablePanel.getCurrentCard().enter((Object)node);
        this.toggleAllowChildrenService.update();
    }

    public JPanel addContributions() {
        FormBuilder formBuilder = this.viewContext.createFormBuilder();
        ProgramNodeCardContribution[] contributions = this.programNodeCardContributions.toArray(new ProgramNodeCardContribution[this.programNodeCardContributions.size()]);
        Arrays.sort(contributions, new Comparator<ProgramNodeCardContribution>(){

            @Override
            public int compare(ProgramNodeCardContribution a, ProgramNodeCardContribution b) {
                return a.getPriority() < b.getPriority() ? 1 : 0;
            }
        });
        ProgramNodeCardContribution[] programNodeCardContributionArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            ProgramNodeCardContribution contribution = programNodeCardContributionArray[n2];
            formBuilder.component(contribution.getContribution(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end();
            ++n2;
        }
        return formBuilder.getPanel();
    }

    public Object exit() {
        this.flippablePanel.getCurrentCard().exit();
        return super.exit();
    }

    protected abstract JPanel createContributionPanel(UntilNodeContribution var1);

    protected abstract class NullUntilTypeCard
    extends UntilTypeCard {
        protected final Map<UntilNodeContribution, Component> viewPartsMap;

        public NullUntilTypeCard() {
            super(UntilCard.this.viewContext);
            this.viewPartsMap = new HashMap<UntilNodeContribution, Component>();
            this.initComponents();
        }

        @Override
        protected void updateCard() {
            HashSet<UntilNodeContribution> allowedContributions = new HashSet<UntilNodeContribution>(this.filterContributions(UntilCard.this.untilConditionOptions));
            for (UntilNodeContribution contribution : UntilCard.this.untilConditionOptions) {
                this.viewPartsMap.get(contribution).setVisible(allowedContributions.contains(contribution));
            }
        }
    }

    protected class UntilTypeSelectionListener
    implements ActionListener {
        private final UntilNodeContribution untilNodeContribution;

        public UntilTypeSelectionListener(UntilNodeContribution untilNodeContribution) {
            this.untilNodeContribution = untilNodeContribution;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            UntilNode node = (UntilNode)UntilCard.this.getNode();
            UntilTypeNode typeNode = this.untilNodeContribution.getUntilTypeNode();
            if (node.canBeOfType(this.untilNodeContribution)) {
                node.setSelectedTypeNode(typeNode);
            } else {
                LegacyURDialogCreator.showMessageDialog(((TextResource)UntilCard.this.viewContext.getTextResource(TextResource.class)).CannotAddUntilNode(this.untilNodeContribution.getTitle()));
            }
        }
    }
}

