/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.injection.Builder;
import com.ur.polyscope.program.nodes.ProgramNodeCardContribution;
import com.ur.polyscope.program.nodes.until.contribution.UntilNodeContribution;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.util.swing.HTML;
import gui.program.until.AllowChildrenToggle;
import gui.program.until.ToggleAllowChildrenService;
import gui.program.until.UntilCard;
import gui.program.until.UntilNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.VerticalLayout;

public class UntilCardImpl
extends UntilCard {
    @Inject
    public UntilCardImpl(Set<UntilNodeContribution> untilNodeContributions, ViewContext viewContext, Builder builder, ToggleAllowChildrenService toggleAllowChildrenService, Set<ProgramNodeCardContribution> programNodeCardContributions) {
        super(untilNodeContributions, viewContext, builder, toggleAllowChildrenService, programNodeCardContributions);
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
    }

    @Override
    protected void initComponents() {
        this.flippablePanel.addCardPanel(UntilCard.class, (CardPanel)new G5NullUntilTypeCard());
        for (UntilNodeContribution contribution : this.untilConditionOptions) {
            this.flippablePanel.addCardPanel(contribution.getCardClass(), (CardPanel)this.builder.get(contribution.getCardClass()));
        }
        AllowChildrenToggle allowChildrenToggle = new AllowChildrenToggle(this.toggleAllowChildrenService, this.viewContext);
        allowChildrenToggle.setName(UntilCard.ADD_ACTIONS_SWITCH);
        allowChildrenToggle.setHorizontalTextPosition(2);
        allowChildrenToggle.setHorizontalAlignment(4);
        allowChildrenToggle.setBorder(new EmptyBorder(new Insets(0, 0, 7, 15)));
        this.toggleAllowChildrenService.bind(allowChildrenToggle, new ToggleAllowChildrenService.NodeProvider(){

            @Override
            public UntilNode getNode() {
                return (UntilNode)UntilCardImpl.this.getNode();
            }
        });
        JPanel actionPanel = this.initActionPanel(allowChildrenToggle);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.flippablePanel, "Center");
        this.add(actionPanel, "South");
        this.helpIdAssigner.assignHelpId((JComponent)((Object)this), "gui:command_until");
    }

    private JPanel initActionPanel(AllowChildrenToggle allowChildrenToggle) {
        return this.viewContext.createFormBuilder().component((JComponent)this.addContributions(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).spacer().component((JComponent)((Object)allowChildrenToggle), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).getPanel();
    }

    @Override
    protected JPanel createContributionPanel(UntilNodeContribution contribution) {
        JButton button = new JButton();
        button.setText(contribution.getTitle());
        button.addActionListener(new UntilCard.UntilTypeSelectionListener(contribution));
        button.setName(String.valueOf(contribution.getClass().getSimpleName()) + "." + ((Object)((Object)this)).getClass().getSuperclass().getSimpleName());
        button.setMinimumSize(new Dimension(210, 70));
        button.setPreferredSize(new Dimension(210, 70));
        button.setMaximumSize(new Dimension(210, 70));
        JLabel iconLabel = new JLabel("", 0);
        iconLabel.setIcon(contribution.getIcon());
        iconLabel.setMinimumSize(new Dimension(205, 70));
        iconLabel.setPreferredSize(new Dimension(205, 70));
        iconLabel.setMaximumSize(new Dimension(205, 70));
        JPanel contributionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.5;
        c.gridy = 0;
        c.gridx = 0;
        contributionPanel.add((Component)button, c);
        c.gridy = 0;
        c.gridx = 1;
        contributionPanel.add((Component)iconLabel, c);
        if (contribution.hasInfo()) {
            JLabel infoLabel = new JLabel(HTML.html((String)contribution.getInfo()));
            infoLabel.setIcon(contribution.getInfoIcon());
            c.gridy = 1;
            c.gridx = 0;
            c.gridwidth = 2;
            contributionPanel.add((Component)infoLabel, c);
        }
        return contributionPanel;
    }

    private class G5NullUntilTypeCard
    extends UntilCard.NullUntilTypeCard {
        private G5NullUntilTypeCard() {
        }

        @Override
        protected void initComponents() {
            TextResource textResource = (TextResource)UntilCardImpl.this.viewContext.getTextResource(TextResource.class);
            JPanel headerPanel = this.initHeaderPanel(textResource);
            JPanel viewParts = this.initViewPartsPanel();
            this.setLayout(new BorderLayout());
            this.add(headerPanel, "North");
            this.add(viewParts, "Center");
        }

        private JPanel initViewPartsPanel() {
            JPanel viewParts = UntilCardImpl.this.viewContext.createWidgetFactory().verticalPanel(25);
            viewParts.setBorder(new EmptyBorder(0, 30, 0, 30));
            for (UntilNodeContribution contribution : UntilCardImpl.this.untilConditionOptions) {
                JPanel panel = UntilCardImpl.this.createContributionPanel(contribution);
                viewParts.add(panel);
                this.viewPartsMap.put(contribution, panel);
            }
            return viewParts;
        }

        private JPanel initHeaderPanel(TextResource textResource) {
            WidgetFactory widgetFactory = UntilCardImpl.this.viewContext.createWidgetFactory();
            JPanel headerPanel = new JPanel((LayoutManager)new VerticalLayout());
            headerPanel.add(widgetFactory.createPageTitle(((CommandNamesResource)UntilCardImpl.this.viewContext.getTextResource(CommandNamesResource.class)).Until()));
            headerPanel.add(widgetFactory.createLabel(textResource.UntilStopCondition()));
            headerPanel.add(widgetFactory.createLabel(textResource.UntilLongDescription()));
            headerPanel.setBorder(new EmptyBorder(0, 30, 10, 0));
            return headerPanel;
        }
    }
}

