/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.contribution;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.lang.StringUtils;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.program.commandview.ProgramTreeNodeRenderer;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.resources.ViewImageResource;
import com.ur.swing.units.ValueConverter;
import com.ur.util.Optional;
import com.ur.view.Settings;
import gui.program.until.UntilNode;
import gui.program.until.types.AnalogPinReference;
import gui.program.until.types.DigitalPinReference;
import gui.program.until.types.UntilContactDetection;
import gui.program.until.types.UntilDistanceNode;
import gui.program.until.types.UntilExpressionNode;
import gui.program.until.types.UntilIONode;
import gui.program.until.types.UntilReachedWaypointNode;
import gui.tools.LanguagePack;
import java.math.BigDecimal;
import javax.inject.Inject;
import javax.swing.Icon;

public class UntilNodeRenderer
implements ProgramTreeNodeRenderer {
    private final ValueConverter<String, Length> lengthConverter = UnitsValueConverterFactory.getLengthConverter();
    private TextResource text;
    private CommandNamesResource names;

    @Inject
    public UntilNodeRenderer(TextResource text, CommandNamesResource names) {
        this.text = text;
        this.names = names;
    }

    public boolean isSupported(AbstractProgramNode programNode) {
        return programNode instanceof UntilNode;
    }

    public Icon getIcon(AbstractProgramNode node, boolean isNodeDefined) {
        return isNodeDefined ? ViewImageResource.programUntil() : ViewImageResource.programUntilUndefined();
    }

    public String getText(AbstractProgramNode node, boolean isNodeDefined) {
        UntilNode untilNode = (UntilNode)node;
        UntilTypeNode selectedTypeNode = untilNode.getSelectedTypeNode();
        switch (selectedTypeNode.getType()) {
            case NONE: {
                return this.names.Until();
            }
            case EXPRESSION: {
                return this.getStringForUntilExpression((UntilExpressionNode)selectedTypeNode);
            }
            case DISTANCE: {
                return this.getStringForDistance((UntilDistanceNode)selectedTypeNode);
            }
            case TOOL_CONTACT_DETECTION: {
                return this.getStringForToolContact((UntilContactDetection)selectedTypeNode);
            }
            case REACHED_WAYPOINT: {
                return this.getStringForReachedWaypoint((UntilReachedWaypointNode)selectedTypeNode);
            }
            case IO: {
                return this.getStringForUntilIO((UntilIONode)selectedTypeNode);
            }
        }
        return "Unknown type:";
    }

    private String getStringForUntilExpression(UntilExpressionNode expressionNode) {
        StringBuffer buffer = new StringBuffer();
        expressionNode.getExpression().generateText(buffer);
        return String.valueOf(this.text.UntilExpression()) + " " + buffer.toString();
    }

    private String getStringForUntilIO(UntilIONode ioNode) {
        UntilIONode.IOType ioType = ioNode.getIOType();
        switch (ioType) {
            case DIGITAL_INPUT: {
                return this.getDigitalInputDisplayable(ioNode);
            }
            case ANALOG_INPUT: {
                return this.getAnalogInputDisplayable(ioNode);
            }
        }
        return this.text.Until();
    }

    private String getAnalogInputDisplayable(UntilIONode ioNode) {
        if (ioNode.getAnalogPinReference().isPresent()) {
            return this.generateDisplayable(((AnalogPinReference)ioNode.getAnalogPinReference().get()).getPinReference(), this.text.Until(), ((AnalogPinReference)ioNode.getAnalogPinReference().get()).getComparision() == AnalogPinReference.Comparision.GREATER_THAN ? ">" : "<", Double.toString(((AnalogPinReference)ioNode.getAnalogPinReference().get()).getValue()));
        }
        return this.text.Until();
    }

    private String getDigitalInputDisplayable(UntilIONode ioNode) {
        if (ioNode.getDigitalPinReference().isPresent()) {
            String hiOrLow = ((DigitalPinReference)ioNode.getDigitalPinReference().get()).getValue() ? LanguagePack.getCommandNamesResource().HI() : LanguagePack.getCommandNamesResource().LO();
            return this.generateDisplayable(((DigitalPinReference)ioNode.getDigitalPinReference().get()).getPinReference(), this.text.Until(), "=", hiOrLow);
        }
        return this.text.Until();
    }

    private String getStringForDistance(UntilDistanceNode distanceNode) {
        if (distanceNode.getDistance() == UntilDistanceNode.EMPTY_DISTANCE) {
            return this.text.UntilDistance();
        }
        Length distance = Length.from((double)distanceNode.getDistance().asDouble(), (Length.Unit)Length.Unit.M);
        String formattedValue = (String)this.lengthConverter.fromModel((Object)distance);
        formattedValue = Double.parseDouble(formattedValue) % 1.0 == 0.0 ? String.format("%.0f", Double.parseDouble(formattedValue)) : (Settings.getUnits().isUS() ? String.format("%.3f", Double.parseDouble(formattedValue)) : String.format("%.2f", Double.parseDouble(formattedValue)));
        formattedValue = formattedValue.contains(",") ? new BigDecimal(formattedValue.replace(',', '.')).stripTrailingZeros().toPlainString().replace('.', ',') : new BigDecimal(formattedValue).stripTrailingZeros().toPlainString();
        String unit = this.lengthConverter.getUnit();
        return String.valueOf(this.text.UntilDistance()) + ": " + formattedValue + " " + unit;
    }

    private String getStringForToolContact(UntilContactDetection contactDetection) {
        UntilContactDetection.RetractOnContact contact = contactDetection.retractOnContact();
        if (contact == UntilContactDetection.NO_RETRACTION) {
            return this.text.untilToolContact();
        }
        Length distance = contact.distance();
        String formattedValue = this.lengthConverter.getFormat().format(Double.parseDouble((String)this.lengthConverter.fromModel((Object)distance)));
        return String.valueOf(this.text.untilToolContact()) + ": " + this.text.retractOnContact(formattedValue, this.lengthConverter.getUnit());
    }

    private String getStringForReachedWaypoint(UntilReachedWaypointNode reachedWaypointNode) {
        if (reachedWaypointNode.hasWaypointParent()) {
            return String.valueOf(this.text.UntilReached()) + ": " + reachedWaypointNode.getWaypointName();
        }
        return this.text.UntilReachedWaypointSuppressed();
    }

    private String generateDisplayable(Optional<PinReference> pinReference, String commandName, String comparison, String rightHandSide) {
        if (pinReference.isPresent()) {
            Pin pin = ((PinReference)pinReference.get()).dereference();
            String pinName = pin == null ? ((PinReference)pinReference.get()).getKey() : (StringUtils.isNullOrOnlyWhitespace((String)pin.getDefinedName()) ? pin.getShortName() : pin.getDefinedName());
            return String.valueOf(commandName) + " " + pinName + comparison + rightHandSide;
        }
        return commandName;
    }
}

