/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.deceleration;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.AngularAcceleration;
import gui.program.until.UntilNode;
import gui.program.until.deceleration.UntilDeceleration;

public class UntilDecelerationCustom
implements UntilDeceleration {
    public final Acceleration cartesianDeceleration;
    public final AngularAcceleration angularDeceleration;

    public UntilDecelerationCustom(Acceleration cartesianDeceleration) {
        this.cartesianDeceleration = cartesianDeceleration;
        this.angularDeceleration = UntilDeceleration.DEFAULT_ANGLE_DECELERATION;
    }

    public UntilDecelerationCustom(AngularAcceleration angularDeceleration) {
        this.angularDeceleration = angularDeceleration;
        this.cartesianDeceleration = UntilDeceleration.DEFAULT_SPEED_DECELERATION;
    }

    public UntilDecelerationCustom(Acceleration cartesianDeceleration, AngularAcceleration angularDeceleration) {
        this.cartesianDeceleration = cartesianDeceleration;
        this.angularDeceleration = angularDeceleration;
    }

    @Override
    public UntilDeceleration.Type getType() {
        return UntilDeceleration.Type.CUSTOM;
    }

    @Override
    public Acceleration getCartesianDeceleration() {
        return this.cartesianDeceleration;
    }

    @Override
    public AngularAcceleration getAngularDeceleration() {
        return this.angularDeceleration;
    }

    @Override
    public ScriptWriter generateStopScript(ScriptWriter writer, UntilNode parent) {
        if (parent.isCartesianMovement()) {
            writer.stopl(this.cartesianDeceleration.getIn(Acceleration.Unit.SI));
        } else {
            writer.stopj(this.angularDeceleration.getIn(AngularAcceleration.Unit.SI));
        }
        return writer;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UntilDeceleration) {
            return EqualsUtil.equals((Object)((UntilDeceleration)obj).getCartesianDeceleration(), (Object)this.getCartesianDeceleration()) && EqualsUtil.equals((Object)((UntilDeceleration)obj).getAngularDeceleration(), (Object)this.getAngularDeceleration());
        }
        return false;
    }

    public String toString() {
        return "{UntilDeceleration: {type: CUSTOM, cartesianDeceleration: " + this.cartesianDeceleration + ", angularDeceleration: " + this.angularDeceleration + "}}";
    }
}

