/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.polyscope.pin.AnalogIOPin;
import com.ur.polyscope.pin.GeneralPurposeFloatRegister;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.util.Optional;

public class AnalogPinReference {
    public static final int _4_TO_20mA = 0;
    private static final Comparision DEFAULT_ANALOG_COMPARISON = Comparision.GREATER_THAN;
    private static final double DEFAULT_ANALOG_VALUE = 0.0;
    private static final int MAX_VOLTAGE = 10;
    private static final int MIN_VOLTAGE = 0;
    private static final int MAX_MILLIAMPS = 20;
    private static final int MIN_MILLIAMPS = 4;
    private Optional<PinReference> pinReference;
    private final Comparision comparision;
    private final double value;

    public AnalogPinReference() {
        this((Optional<PinReference>)Optional.empty(), DEFAULT_ANALOG_COMPARISON, 0.0);
    }

    public AnalogPinReference(Comparision comparision, double value) {
        this((Optional<PinReference>)Optional.empty(), comparision, value);
    }

    public AnalogPinReference(Optional<PinReference> pinReference, Comparision comparision, double value) {
        this.pinReference = pinReference;
        this.comparision = comparision;
        this.value = value;
    }

    public String getScript() {
        return String.valueOf(((PinReference)this.pinReference.get()).dereference().generateGetterScriptCode()) + (this.comparision == Comparision.GREATER_THAN ? " > " : " < ") + this.getAnalogValueForScript(((PinReference)this.pinReference.get()).dereference(), this.getValue());
    }

    public static int getAnalogInputRange(Pin<?> pin) {
        if (pin == null) {
            return 0;
        }
        if (pin instanceof AnalogIOPin) {
            int analogInputRange = ((AnalogIOPin)pin).getAnalogInputRange();
            if (analogInputRange < 0) {
                analogInputRange = 0;
            }
            return analogInputRange;
        }
        return 0;
    }

    private double getAnalogValue(double value) {
        double returnValue = value;
        Pin analogInput = null;
        if (this.pinReference.isPresent()) {
            analogInput = ((PinReference)this.pinReference.get()).dereference();
        }
        if (!(analogInput instanceof GeneralPurposeFloatRegister)) {
            if (AnalogPinReference.getAnalogInputRange(analogInput) == 0) {
                if (value > 20.0) {
                    returnValue = 20.0;
                } else if (value < 4.0) {
                    returnValue = 4.0;
                }
            } else if (value > 10.0) {
                returnValue = 10.0;
            } else if (value < 0.0) {
                returnValue = 0.0;
            }
        }
        return returnValue;
    }

    public boolean getIsCurrent() {
        Pin analogInput = null;
        if (this.pinReference.isPresent()) {
            analogInput = ((PinReference)this.pinReference.get()).dereference();
        }
        return AnalogPinReference.getAnalogInputRange(analogInput) == 0;
    }

    public double getValue() {
        return this.getAnalogValue(this.value);
    }

    private double getAnalogValueForScript(Pin<?> pin, double analogValue) {
        double value = analogValue;
        if (!(pin instanceof GeneralPurposeFloatRegister) && AnalogPinReference.getAnalogInputRange(pin) == 0) {
            value /= 1000.0;
        }
        return value;
    }

    public Optional<PinReference> getPinReference() {
        return this.pinReference;
    }

    public Comparision getComparision() {
        return this.comparision;
    }

    public static enum Comparision {
        GREATER_THAN,
        LESS_THAN;

    }
}

