/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.program.nodes.until.MoveThreadScriptParams;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.AngularAcceleration;
import com.ur.polyscope.valueobjects.Force;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.util.Optional;
import gui.program.MotionDefiningNode;
import gui.program.until.UntilNode;
import gui.program.until.deceleration.UntilDeceleration;
import gui.program.until.deceleration.UntilDecelerationCustom;
import gui.program.until.deceleration.UntilDecelerationShared;
import java.util.Locale;
import org.apache.commons.lang3.ObjectUtils;

public class UntilContactDetection
implements UntilTypeNode {
    public static final RetractOnContact NO_RETRACTION = new RetractOnContact(Length.INFINITE);
    public static final RetractOnContact DEFAULT_RETRACTION = new RetractOnContact(Length.ZERO);
    public static final String RECOMMENDED_MAX_SPEED_UNIT = UnitsValueConverterFactory.getSpeedConverter().getUnit();
    protected static final double MAX_SPEED = 0.1;
    public static final double RECOMMENDED_MAX_SPEED = UntilContactDetection.getSpeedValueForDisplay(0.1);
    private final RetractOnContact retractToAvoidClamping;
    private final ForceThreshold forceThreshold;
    private UntilNode untilNode;
    private UntilDeceleration deceleration;

    public UntilContactDetection(RetractOnContact retractToAvoidClamping, Acceleration decelerationAcceleration) {
        this(retractToAvoidClamping, new UntilDecelerationCustom((Acceleration)ObjectUtils.defaultIfNull((Object)decelerationAcceleration, (Object)UntilDeceleration.DEFAULT_SPEED_DECELERATION)), null);
    }

    public UntilContactDetection(RetractOnContact retractToAvoidClamping, AngularAcceleration decelerationAngularAcceleration) {
        this(retractToAvoidClamping, new UntilDecelerationCustom((AngularAcceleration)ObjectUtils.defaultIfNull((Object)decelerationAngularAcceleration, (Object)UntilDeceleration.DEFAULT_ANGLE_DECELERATION)), null);
    }

    public UntilContactDetection(RetractOnContact retractOnContact, UntilDeceleration deceleration) {
        this(retractOnContact, deceleration, null);
    }

    public UntilContactDetection(RetractOnContact retractOnContact, UntilDeceleration deceleration, ForceThreshold forceThreshold) {
        this.retractToAvoidClamping = (RetractOnContact)ObjectUtils.defaultIfNull((Object)retractOnContact, (Object)DEFAULT_RETRACTION);
        this.deceleration = (UntilDeceleration)ObjectUtils.defaultIfNull((Object)deceleration, (Object)new UntilDecelerationShared(this.untilNode));
        this.forceThreshold = forceThreshold;
    }

    public RetractOnContact retractOnContact() {
        return this.retractToAvoidClamping;
    }

    public UntilDeceleration getUntilDeceleration() {
        return this.deceleration;
    }

    public ForceThreshold getForceThreshold() {
        return this.forceThreshold;
    }

    private static double getSpeedValueForDisplay(double value) {
        return Double.parseDouble((String)UnitsValueConverterFactory.getSpeedConverter().fromModel((Object)Speed.from((double)value, (Speed.Unit)Speed.Unit.SI)));
    }

    public String generateScriptCode(Optional<MoveThreadScriptParams> optional) {
        ScriptWriter writer = new ScriptWriter();
        writer.localVariable("targetTcpDirection", "get_target_tcp_speed()");
        writer.localVariable("stepsToRetract", this.getToolContactFunction());
        writer.ifCondition("stepsToRetract > 0");
        if (optional.isPresent()) {
            writer.killThread(((MoveThreadScriptParams)optional.get()).threadHandle);
        }
        if (this.untilNode.isCartesianMovement()) {
            this.deceleration.generateStopScript(writer, this.untilNode);
            this.retractOnContact().generateScriptWithMoveL(this.deceleration.getCartesianDeceleration(), writer);
        } else {
            this.deceleration.generateStopScript(writer, this.untilNode);
            this.retractOnContact().generateScriptWithMoveJ(this.deceleration.getAngularDeceleration(), writer);
        }
        this.untilNode.generateUntilActionsScript(writer);
        writer.end();
        return writer.generateScript();
    }

    private String getToolContactFunction() {
        if (this.forceThreshold != null) {
            return this.forceThreshold.getToolContactFunction();
        }
        return "tool_contact(direction=targetTcpDirection)";
    }

    public UntilTypeNode clone() {
        return new UntilContactDetection(this.retractToAvoidClamping, this.deceleration, this.forceThreshold);
    }

    public boolean isUndefined() {
        if (this.deceleration.getType() == UntilDeceleration.Type.SHARED) {
            return this.isUsingOptiMove();
        }
        return false;
    }

    private boolean isUsingOptiMove() {
        MotionDefiningNode motionNode = (MotionDefiningNode)this.getParent().getNodeOfType(MotionDefiningNode.class);
        if (motionNode == null) {
            return false;
        }
        return motionNode.isUsingOptiMove();
    }

    public UntilNode getParent() {
        return this.untilNode;
    }

    public void setParent(com.ur.polyscope.program.nodes.until.UntilNode untilNode) {
        this.untilNode = (UntilNode)untilNode;
        if (this.deceleration instanceof UntilDecelerationShared) {
            this.deceleration = new UntilDecelerationShared((UntilNode)untilNode);
        }
    }

    public UntilTypeNode.Type getType() {
        return UntilTypeNode.Type.TOOL_CONTACT_DETECTION;
    }

    public String toString() {
        return "{UntilNode: {type: \"ToolContactDetectin\", deceleration: " + this.deceleration.toString() + ", " + this.retractOnContact() + ", " + this.getForceThreshold() + "}}";
    }

    public boolean equals(Object obj) {
        if (obj instanceof UntilContactDetection) {
            UntilContactDetection other = (UntilContactDetection)obj;
            return EqualsUtil.equals((Object)this.retractToAvoidClamping, (Object)other.retractToAvoidClamping) && EqualsUtil.equals((Object)this.deceleration, (Object)other.deceleration) && EqualsUtil.equals((Object)this.forceThreshold, (Object)other.forceThreshold);
        }
        return false;
    }

    public double getDeceleration() {
        throw new RuntimeException("We shouldn't use this method");
    }

    public void setDeceleration(double v) {
    }

    public static class ForceThreshold {
        private final Force force;

        public ForceThreshold(Force force) {
            this.force = force;
        }

        public Force getForce() {
            return this.force;
        }

        public String getToolContactFunction() {
            return String.format(Locale.US, "tool_contact(direction=%s, force_threshold=%f)", "targetTcpDirection", this.force.getIn(Force.Unit.SI));
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            ForceThreshold other = (ForceThreshold)obj;
            return EqualsUtil.equals((Object)this.force, (Object)other.force);
        }

        public String toString() {
            return "force threshold: " + this.force;
        }
    }

    public static class RetractOnContact {
        private final Length distanceInLength;

        public RetractOnContact(Length distanceInLength) {
            this.distanceInLength = distanceInLength;
        }

        public Length distance() {
            return this.distanceInLength;
        }

        public void generateScriptWithMoveJ(AngularAcceleration angle, ScriptWriter writer) {
            if (this == NO_RETRACTION) {
                return;
            }
            this.writeBodyOfScript(writer);
            writer.appendLine("movej(retractTo, a=" + angle.getIn(AngularAcceleration.Unit.SI) + ", v=0.1)");
        }

        public void generateScriptWithMoveL(Acceleration decelerationAcceleration, ScriptWriter writer) {
            if (this == NO_RETRACTION) {
                return;
            }
            this.writeBodyOfScript(writer);
            writer.movel("retractTo", "" + decelerationAcceleration.getIn(Acceleration.Unit.SI), "0.1");
        }

        private void writeBodyOfScript(ScriptWriter writer) {
            writer.localVariable("backTrackMovement", "get_actual_joint_positions_history(stepsToRetract)");
            writer.localVariable("contactPose", "get_forward_kin(backTrackMovement)");
            writer.localVariable("posDir", "[targetTcpDirection[0],targetTcpDirection[1],targetTcpDirection[2]]");
            writer.localVariable("retractTo", "contactPose");
            writer.ifCondition("norm(posDir) > 1e-6");
            writer.localVariable("normalizedPosDir", "normalize(posDir)");
            writer.localVariable("additionalRetraction", "p[normalizedPosDir[0] * " + this.distanceInLength.getIn(Length.Unit.SI) + ", " + "normalizedPosDir[1] * " + this.distanceInLength.getIn(Length.Unit.SI) + ", " + "normalizedPosDir[2] * " + this.distanceInLength.getIn(Length.Unit.SI) + ", " + "0, 0, 0]");
            writer.assign("retractTo", "pose_sub(contactPose, additionalRetraction)");
            writer.end();
        }

        public boolean equals(Object obj) {
            RetractOnContact other = (RetractOnContact)obj;
            return EqualsUtil.equals((Object)this.distanceInLength, (Object)other.distanceInLength);
        }

        public String toString() {
            return "retraction: " + (NO_RETRACTION == this ? "\"no retraction\"" : this.distanceInLength);
        }
    }
}

