/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.until.contribution.UntilNodeContribution;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.AngularAcceleration;
import com.ur.polyscope.valueobjects.Force;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.resources.IllustrationImageResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.AutoCorrectionRangeDecorator;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.Settings;
import gui.program.until.UntilNode;
import gui.program.until.deceleration.UntilDeceleration;
import gui.program.until.deceleration.UntilDecelerationCustom;
import gui.program.until.deceleration.UntilDecelerationShared;
import gui.program.until.types.OptiMoveWithSharedDeceleration;
import gui.program.until.types.UntilContactDetection;
import gui.program.until.types.UntilContactDetectionPresenter;
import gui.program.until.types.UntilContactDetectionView;
import gui.program.until.types.UntilTypeCard;
import gui.program.validation.MoveNodeValidationStrategyProvider;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.VerticalLayout;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class UntilContactDetectionCard
extends UntilTypeCard
implements UntilContactDetectionView {
    private final UntilContactDetectionPresenter presenter;
    private final ViewContext viewContext;
    private final MoveNodeValidationStrategyProvider validationStrategyProvider;
    private final List<UntilNodeContribution> untilNodeContributions;
    private final JComboBox untilNodesComboBox;
    private final ButtonGroup decelerationButtonGroup = new ButtonGroup();
    private final OptiMoveWithSharedDeceleration optiMoveSupport;
    private JCheckBox useRetractionCheckBox;
    private NumberField reverseMovementNumberField;
    private NumberField decelerationNumberField;
    private NumberField forceThresholdNumberField;
    private JCheckBox forceThresholdCheckBox;
    private boolean updating;
    private JRadioButton useSharedDecelerationRadioButton;
    private JRadioButton useCustomDecelerationRadioButton;

    @Inject
    public UntilContactDetectionCard(UntilContactDetectionPresenter presenter, ViewContext viewContext, MoveNodeValidationStrategyProvider validationStrategyProvider, Set<UntilNodeContribution> untilNodeContributions) {
        super(viewContext);
        this.presenter = presenter;
        this.viewContext = viewContext;
        this.validationStrategyProvider = validationStrategyProvider;
        this.untilNodeContributions = this.getUntilConditionOptions(untilNodeContributions);
        this.untilNodesComboBox = this.createUntilTypeComboBox();
        this.optiMoveSupport = new OptiMoveWithSharedDeceleration((TextResource)viewContext.getTextResource(TextResource.class));
        this.initComponents();
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_until_contact");
        presenter.setView(this);
    }

    @Override
    public void updateView(boolean useRetraction, Length distance, UntilDeceleration untilDeceleration, UntilContactDetection.ForceThreshold forceThreshold) {
        this.updating = true;
        this.useRetractionCheckBox.setSelected(useRetraction);
        this.reverseMovementNumberField.setEnabled(useRetraction);
        this.reverseMovementNumberField.setValue((Object)distance);
        this.updateDecelerationField(untilDeceleration);
        this.updateForceThreshold(forceThreshold);
        this.updating = false;
    }

    private AutoCorrectionValidator getForceValidator(TextResource textResource) {
        Force.Unit unit = Settings.getUnits().isUS() ? Force.Unit.LB : Force.Unit.N;
        Force minForce = Force.from((double)1.0E-7, (Force.Unit)Force.Unit.N);
        Force maxForce = Force.from((double)150.0, (Force.Unit)Force.Unit.N);
        String errorMessage = UntilContactDetectionCard.getErrorMessage(textResource, minForce, maxForce, unit);
        return new AutoCorrectionRangeDecorator(ValidationFactory.getRangeValidator((double)minForce.getIn(unit), (double)maxForce.getIn(unit), (String)errorMessage), minForce.getIn(unit), maxForce.getIn(unit));
    }

    private static String getErrorMessage(TextResource textResource, Force minForce, Force maxForce, Force.Unit unit) {
        double minForceText = minForce.getIn(unit);
        minForceText = (double)Math.round(minForceText * 1000.0) / 1000.0;
        double maxForceText = maxForce.getIn(unit);
        maxForceText = (double)Math.round(maxForceText * 1000.0) / 1000.0;
        return textResource.valueOutOfRangeExclusive(minForceText, unit.name(), maxForceText);
    }

    private void updateForceThreshold(UntilContactDetection.ForceThreshold forceThreshold) {
        this.forceThresholdNumberField.setValueConverter(UnitsValueConverterFactory.getForceConverter());
        this.forceThresholdNumberField.setErrorValidationStrategy(new ValidationStrategy[]{this.getForceValidator((TextResource)this.viewContext.getTextResource(TextResource.class))});
        this.forceThresholdCheckBox.setSelected(forceThreshold != null);
        this.forceThresholdNumberField.setEnabled(forceThreshold != null);
        if (forceThreshold != null) {
            this.forceThresholdNumberField.setValue((Object)forceThreshold.getForce());
        }
    }

    @Override
    public void enter(Object o) {
        this.presenter.setModel((UntilNode)o);
        super.enter(o);
    }

    @Override
    protected void updateCard() {
        this.presenter.updateView();
        this.setUntilNodeComboBoxModel(this.untilNodesComboBox, UntilTypeNode.Type.TOOL_CONTACT_DETECTION, this.untilNodeContributions);
    }

    @Override
    protected void initComponents() {
        WidgetFactory factory = this.viewContext.createWidgetFactory();
        TextResource text = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.initContactPointComponents(text, factory);
        this.initForceThresholdComponents(text, factory);
        JPanel untilPanel = this.initUntilPanel(this.untilNodesComboBox);
        JPanel explanationPanel = this.initTextPanel(text);
        JPanel settingsPanel = this.initSettingsPanel(text, factory);
        this.setLayout((LayoutManager)new VerticalLayout());
        this.add(untilPanel);
        this.add(explanationPanel);
        this.add(settingsPanel);
    }

    private JPanel initSettingsPanel(TextResource text, WidgetFactory factory) {
        Box decelerationBox = this.initDecelerationsComponents(factory);
        ExplanationDiagram explanation = new ExplanationDiagram(text);
        JPanel settingsPanel = this.viewContext.createFormBuilder().component((JComponent)this.useRetractionCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)explanation, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_5_ROWS}).end().label(text.reverseMovement(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.reverseMovementNumberField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().end().end().end().component((JComponent)this.useSharedDecelerationRadioButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.forceThresholdCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.useCustomDecelerationRadioButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.forceThresholdNumberField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)decelerationBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).getPanel();
        settingsPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        return settingsPanel;
    }

    private JPanel initTextPanel(TextResource text) {
        JPanel textPanel = this.viewContext.createFormBuilder().description(text.untilToolContactDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).description(text.untilToolContactInfo(UntilContactDetection.RECOMMENDED_MAX_SPEED, UntilContactDetection.RECOMMENDED_MAX_SPEED_UNIT), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end().description(text.UntilActionDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).getPanel();
        textPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        return textPanel;
    }

    private void initContactPointComponents(TextResource text, WidgetFactory factory) {
        this.reverseMovementNumberField = factory.createNumberField((ActionListener)new UpdateModel(), UnitsValueConverterFactory.getLengthConverter());
        this.reverseMovementNumberField.setUnitWidth(85);
        this.reverseMovementNumberField.setName("reverseMovement.UntilContactDetectionView");
        this.useRetractionCheckBox = factory.createCheckBox(text.retractToContact());
        this.useRetractionCheckBox.addChangeListener(new UpdateModel());
        this.useRetractionCheckBox.setName("retraction.UntilContactDetectionView");
    }

    private void initForceThresholdComponents(TextResource text, WidgetFactory factory) {
        this.forceThresholdNumberField = factory.createNumberField((ActionListener)new UpdateModel(), UnitsValueConverterFactory.getForceConverter());
        this.forceThresholdNumberField.setUnitWidth(85);
        this.forceThresholdNumberField.setName("forceThreshold.UntilContactDetectionView");
        this.forceThresholdNumberField.setValue((Object)Force.from((double)5.0, (Force.Unit)Force.Unit.N));
        this.forceThresholdNumberField.setEnabled(false);
        this.forceThresholdCheckBox = factory.createCheckBox(text.untilToolForceThreshold());
        this.forceThresholdCheckBox.addChangeListener(new UpdateModel());
        this.forceThresholdCheckBox.setName("useForceThreshold.UntilContactDetectionView");
    }

    private Box initDecelerationsComponents(WidgetFactory factory) {
        this.useSharedDecelerationRadioButton = new JRadioButton(((TextResource)this.viewContext.getTextResource(TextResource.class)).UseSharedDeceleration());
        this.useSharedDecelerationRadioButton.addActionListener(new UpdateModel());
        this.useSharedDecelerationRadioButton.setName("useDefaultDecelerationButton.UntilContactDetectionView");
        this.useCustomDecelerationRadioButton = new JRadioButton(((TextResource)this.viewContext.getTextResource(TextResource.class)).UseCustomDeceleration());
        this.useCustomDecelerationRadioButton.addActionListener(new UpdateModel());
        this.useCustomDecelerationRadioButton.setName("useCustomDecelerationButton.UntilContactDetectionView");
        this.decelerationButtonGroup.add(this.useSharedDecelerationRadioButton);
        this.decelerationButtonGroup.add(this.useCustomDecelerationRadioButton);
        this.decelerationNumberField = factory.createNumberField((ActionListener)new UpdateModel(), UnitsValueConverterFactory.getAccelerationConverter());
        this.decelerationNumberField.setUnitWidth(85);
        this.decelerationNumberField.setMode(Mode.PositiveNumbers);
        this.decelerationNumberField.setName("deceleration.UntilContactDetectionView");
        Box decelerationBox = Box.createHorizontalBox();
        decelerationBox.add(Box.createHorizontalStrut(36));
        decelerationBox.add((Component)this.decelerationNumberField);
        return decelerationBox;
    }

    private void updateDecelerationField(UntilDeceleration untilDeceleration) {
        if (((UntilNode)this.getNode()).isCartesianMovement()) {
            this.decelerationNumberField.setValueConverter(UnitsValueConverterFactory.getAccelerationConverter());
            this.decelerationNumberField.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getCartesianJointAccelerationLimitValidator()});
            this.decelerationNumberField.setValue((Object)untilDeceleration.getCartesianDeceleration());
        } else {
            this.decelerationNumberField.setValueConverter(UnitsValueConverterFactory.getAngularAccelerationConverter());
            this.decelerationNumberField.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getJointAccelerationLimitValidator()});
            this.decelerationNumberField.setValue((Object)untilDeceleration.getAngularDeceleration());
        }
        this.optiMoveSupport.updateSharedDeceleration(this.useSharedDecelerationRadioButton, (UntilNode)this.getNode());
        this.updateRadioButtons(untilDeceleration.getType() == UntilDeceleration.Type.SHARED);
    }

    private void updateRadioButtons(boolean isUseSharedDeceleration) {
        this.useSharedDecelerationRadioButton.setSelected(isUseSharedDeceleration);
        this.useCustomDecelerationRadioButton.setSelected(!isUseSharedDeceleration);
        this.decelerationNumberField.setEnabled(!isUseSharedDeceleration);
    }

    private static class ExplanationDiagram
    extends JPanel {
        ExplanationDiagram(TextResource text) {
            this.setLayout((LayoutManager)new AbsoluteLayout());
            this.add((Component)new JLabel(IllustrationImageResource.moveToolContactDescription()), new AbsoluteConstraints(8, 0));
            this.add((Component)new JLabel(text.Distance()), new AbsoluteConstraints(190, 15));
            this.add((Component)new JLabel(text.contact()), new AbsoluteConstraints(190, 60));
            this.add((Component)new JLabel(text.robotStop()), new AbsoluteConstraints(190, 105));
        }
    }

    private class UpdateModel
    implements ActionListener,
    ChangeListener {
        private UpdateModel() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateModel();
            ((UntilNode)UntilContactDetectionCard.this.getNode()).textHasChanged();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateModel();
        }

        private void updateModel() {
            if (UntilContactDetectionCard.this.updating) {
                return;
            }
            UntilDeceleration untilDeceleration = UntilContactDetectionCard.this.useSharedDecelerationRadioButton.isSelected() ? new UntilDecelerationShared((UntilNode)UntilContactDetectionCard.this.getNode()) : (((UntilNode)UntilContactDetectionCard.this.getNode()).isCartesianMovement() ? new UntilDecelerationCustom((Acceleration)UntilContactDetectionCard.this.decelerationNumberField.getValue()) : new UntilDecelerationCustom((AngularAcceleration)UntilContactDetectionCard.this.decelerationNumberField.getValue()));
            UntilContactDetection.RetractOnContact retraction = UntilContactDetectionCard.this.useRetractionCheckBox.isSelected() ? new UntilContactDetection.RetractOnContact((Length)UntilContactDetectionCard.this.reverseMovementNumberField.getValue()) : UntilContactDetection.NO_RETRACTION;
            UntilContactDetection.ForceThreshold forceThreshold = UntilContactDetectionCard.this.forceThresholdCheckBox.isSelected() ? new UntilContactDetection.ForceThreshold((Force)UntilContactDetectionCard.this.forceThresholdNumberField.getValue()) : null;
            UntilContactDetectionCard.this.presenter.updateModel(retraction, untilDeceleration, forceThreshold);
        }
    }
}

