/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.until.persistence.UntilTypeConversionStrategy;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.AngularAcceleration;
import com.ur.polyscope.valueobjects.Force;
import com.ur.polyscope.valueobjects.Length;
import gui.program.until.UntilNode;
import gui.program.until.deceleration.UntilDeceleration;
import gui.program.until.deceleration.UntilDecelerationCustom;
import gui.program.until.deceleration.UntilDecelerationShared;
import gui.program.until.types.UntilContactDetection;

public class UntilContactDetectionConversionStrategy
implements UntilTypeConversionStrategy {
    public static final String NONE = "NONE";
    public static final String RETRACTION = "retraction";
    public static final String DECELERATION_SPEED = "decelerationAcceleration";
    public static final String DECELERATION_ANGLE = "decelerationAngularAcceleration";

    public void marshal(UntilTypeNode untilTypeNode, PersistWriter persistWriter) {
        UntilContactDetection node = (UntilContactDetection)untilTypeNode;
        persistWriter.addAttribute(RETRACTION, node.retractOnContact() == UntilContactDetection.NO_RETRACTION ? NONE : "" + node.retractOnContact().distance().asDouble());
        UntilDeceleration deceleration = node.getUntilDeceleration();
        if (deceleration.getType() == UntilDeceleration.Type.CUSTOM) {
            persistWriter.addAttribute(DECELERATION_SPEED, node.getUntilDeceleration().getCartesianDeceleration().asDouble());
            persistWriter.addAttribute(DECELERATION_ANGLE, node.getUntilDeceleration().getAngularDeceleration().asDouble());
        }
        if (node.getForceThreshold() != null) {
            persistWriter.addAttribute("forceThreshold", node.getForceThreshold().getForce().asDouble());
        }
    }

    public UntilTypeNode unmarshal(PersistReader persistReader, com.ur.polyscope.program.nodes.until.UntilNode untilNode) {
        UntilContactDetection result;
        String retractValue = persistReader.getStringAttribute(RETRACTION);
        UntilContactDetection.RetractOnContact retractOnContact = retractValue.equals(NONE) ? UntilContactDetection.NO_RETRACTION : new UntilContactDetection.RetractOnContact(Length.from((double)Double.parseDouble(retractValue), (Length.Unit)Length.Unit.SI));
        UntilContactDetection.ForceThreshold forceThreshold = null;
        if (persistReader.hasOneOfAttributes(new String[]{"forceThreshold"})) {
            Force force = Force.from((double)persistReader.getDoubleAttribute("forceThreshold"), (Force.Unit)Force.Unit.SI);
            forceThreshold = new UntilContactDetection.ForceThreshold(force);
        }
        if (persistReader.hasOneOfAttributes(new String[]{DECELERATION_SPEED})) {
            Acceleration decelerationAcceleration = Acceleration.from((double)persistReader.getDoubleAttribute(DECELERATION_SPEED), (Acceleration.Unit)Acceleration.Unit.SI);
            AngularAcceleration decelerationAngularAcceleration = AngularAcceleration.from((double)persistReader.getDoubleAttribute(DECELERATION_ANGLE), (AngularAcceleration.Unit)AngularAcceleration.Unit.SI);
            result = new UntilContactDetection(retractOnContact, new UntilDecelerationCustom(decelerationAcceleration, decelerationAngularAcceleration), forceThreshold);
        } else {
            result = new UntilContactDetection(retractOnContact, new UntilDecelerationShared((UntilNode)untilNode), forceThreshold);
        }
        ((UntilNode)untilNode).setSelectedTypeNode(result);
        return result;
    }

    public UntilTypeNode.Type getType() {
        return UntilTypeNode.Type.TOOL_CONTACT_DETECTION;
    }
}

