/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.until.contribution.UntilNodeContribution;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.swing.ViewContext;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.Settings;
import gui.program.until.UntilNode;
import gui.program.until.types.UntilDistanceNode;
import gui.program.until.types.UntilDistancePresenter;
import gui.program.until.types.UntilDistanceView;
import gui.program.until.types.UntilTypeCard;
import gui.program.validation.WaypointNodeValidationStrategyProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public abstract class UntilDistanceCard
extends UntilTypeCard
implements UntilDistanceView {
    public static final String DISTANCE_VALUE = "distanceValue." + UntilDistanceCard.class.getSimpleName();
    public static final String BLEND_RADIUS = "blendRadius." + UntilDistanceCard.class.getSimpleName();
    public static final String STOP_BUTTON = "stopButton." + UntilDistanceCard.class.getSimpleName();
    public static final String BLEND_BUTTON = "blendRadiusButton." + UntilDistanceCard.class.getSimpleName();
    public static final int RADIO_BUTTON_ICON_WIDTH = 36;
    protected WaypointNodeValidationStrategyProvider nodeValidationStrategyProvider;
    protected final ViewContext viewContext;
    protected final List<UntilNodeContribution> untilNodeContributions;
    protected final UntilDistancePresenter presenter;
    protected final JComboBox untilNodesComboBox;
    protected NumberField distanceNumberField;
    protected JLabel distanceLabel;
    protected NumberField blendRadiusField;
    protected JRadioButton stopRadioButton;
    protected JRadioButton blendRadioButton;
    protected final ValueConverter<String, Length> lengthConverter = UnitsValueConverterFactory.getLengthConverter();
    private boolean updating = false;

    @Inject
    UntilDistanceCard(UntilDistancePresenter presenter, WaypointNodeValidationStrategyProvider nodeValidationStrategyProvider, ViewContext viewContext, Set<UntilNodeContribution> untilNodeContributions) {
        super(viewContext);
        this.nodeValidationStrategyProvider = nodeValidationStrategyProvider;
        this.viewContext = viewContext;
        this.untilNodeContributions = this.getUntilConditionOptions(untilNodeContributions);
        this.untilNodesComboBox = this.createUntilTypeComboBox();
        this.presenter = presenter;
        this.initComponents();
        this.assignHelpIds();
        presenter.setView(this);
    }

    @Override
    public void updateView(Acceleration decelerationAcceleration, Length distance, Length blendRadius, UntilDistanceNode.DistanceNodeType nodeType) {
        this.updating = true;
        if (distance == UntilDistanceNode.EMPTY_DISTANCE) {
            this.distanceNumberField.setMode(Mode.IP_ADDRESS);
            this.distanceNumberField.setText("");
            this.distanceNumberField.setMode(Mode.Standard);
        } else {
            this.distanceNumberField.setValue((Object)distance);
        }
        this.distanceNumberField.forceValidation();
        this.updateRadioButtons(nodeType == UntilDistanceNode.DistanceNodeType.BLEND);
        this.blendRadiusField.setValue((Object)blendRadius);
        this.updating = false;
    }

    @Override
    public void enter(Object o) {
        this.presenter.setModel((UntilNode)o);
        super.enter(o);
    }

    public void textHasChanged() {
        ((UntilNode)this.getNode()).textHasChanged();
    }

    @Override
    protected void updateCard() {
        this.presenter.updateView();
        this.parseBlendValue();
        this.setUntilNodeComboBoxModel(this.untilNodesComboBox, UntilTypeNode.Type.DISTANCE, this.untilNodeContributions);
    }

    private void updateRadioButtons(boolean useBlendRadius) {
        this.stopRadioButton.setSelected(!useBlendRadius);
        this.blendRadioButton.setSelected(useBlendRadius);
        this.blendRadiusField.setEnabled(useBlendRadius);
    }

    private void assignHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)((Object)this), "gui:command_script");
    }

    private ValidationStrategy createBlendRadiusValidationStrategy(double maxBlendRadius) {
        return this.nodeValidationStrategyProvider.getBlendRadiusValidator(maxBlendRadius);
    }

    protected void parseBlendValue() {
        if (!this.blendRadiusField.isEnabled()) {
            return;
        }
        double maxBlendRadius = this.getValidMaxBlendRadius((Length)this.lengthConverter.fromGui((Object)this.distanceNumberField.getText()));
        this.blendRadiusField.setErrorValidationStrategy(new ValidationStrategy[]{this.createBlendRadiusValidationStrategy(maxBlendRadius)});
        this.updateModel();
    }

    private double getValidMaxBlendRadius(Length maxBlendRadius) {
        if (maxBlendRadius.isZero()) {
            return 0.0;
        }
        if (Settings.getUnits().isUS()) {
            double maxBlendRadiusIn = URMath.roundUpDouble((double)maxBlendRadius.getIn(Length.Unit.INCH), (int)3);
            return URMath.roundUpDouble((double)(maxBlendRadiusIn -= 0.001), (int)3);
        }
        double maxBlendRadiusMM = URMath.roundUpDouble((double)maxBlendRadius.getIn(Length.Unit.MM), (int)2);
        return URMath.roundUpDouble((double)(maxBlendRadiusMM -= 0.01), (int)2);
    }

    protected ValidationStrategy createDistanceValidationStrategy() {
        return new ValidationStrategy.Composite(new ValidationStrategy[]{ValidationFactory.getPositiveNumberValidator(), new ValidationStrategy(){

            public boolean isValid(String s) {
                Length distance = (Length)UntilDistanceCard.this.lengthConverter.fromGui((Object)s);
                return s.length() == 0 || distance.isGreaterThanOrEqualTo(Length.ZERO);
            }

            public String getErrorMessage(String s) {
                return ((TextResource)UntilDistanceCard.this.viewContext.getTextResource(TextResource.class)).UntilDistanceWarning();
            }
        }});
    }

    private void updateModel() {
        if (this.updating) {
            return;
        }
        UntilDistanceNode.DistanceNodeType nodeType = UntilDistanceNode.DistanceNodeType.STOP;
        if (this.blendRadioButton.isSelected()) {
            nodeType = UntilDistanceNode.DistanceNodeType.BLEND;
        }
        this.presenter.updateModel(UntilDistanceNode.DEFAULT_DECELERATION, (Length)this.lengthConverter.fromGui((Object)this.distanceNumberField.getText()), (Length)this.lengthConverter.fromGui((Object)this.blendRadiusField.getText()), nodeType);
    }

    protected class BlendRadiusUpdate
    implements ActionListener {
        protected BlendRadiusUpdate() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UntilDistanceCard.this.updating) {
                return;
            }
            UntilDistanceCard.this.parseBlendValue();
        }
    }

    protected class UpdateModel
    implements ActionListener {
        protected UpdateModel() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UntilDistanceCard.this.updateModel();
        }
    }
}

