/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.i18n.TextResource;
import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.program.nodes.until.contribution.UntilNodeContribution;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.number.Mode;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.Settings;
import gui.program.until.types.UntilDistanceCard;
import gui.program.until.types.UntilDistancePresenter;
import gui.program.validation.WaypointNodeValidationStrategyProvider;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.swingx.VerticalLayout;

public class UntilDistanceCardImpl
extends UntilDistanceCard {
    @Inject
    public UntilDistanceCardImpl(UntilDistancePresenter presenter, WaypointNodeValidationStrategyProvider nodeValidationStrategyProvider, ViewContext viewContext, Set<UntilNodeContribution> untilNodeContributions) {
        super(presenter, nodeValidationStrategyProvider, viewContext, untilNodeContributions);
    }

    @Override
    public void initComponents() {
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        this.distanceLabel = new JLabel(resource.Distance());
        this.distanceNumberField = widgetFactory.createNumberField((ActionListener)new UntilDistanceCard.UpdateModel());
        this.distanceNumberField.setName(UntilDistanceCard.DISTANCE_VALUE);
        this.distanceNumberField.setUnitWidth(55);
        this.distanceNumberField.setMode(Mode.PositiveNumbers);
        this.distanceNumberField.setWarningValidationStrategy(new ValidationStrategy[]{ValidationFactory.getCannotBeEmptyValidatorNoErrorMessage()});
        this.distanceNumberField.setErrorValidationStrategy(new ValidationStrategy[]{this.createDistanceValidationStrategy()});
        this.distanceNumberField.setValueConverter(UnitsValueConverterFactory.getLengthConverter());
        this.distanceNumberField.addActionListener((ActionListener)new UntilDistanceCard.BlendRadiusUpdate());
        this.blendRadiusField = widgetFactory.createNumberField((ActionListener)new UntilDistanceCard.UpdateModel());
        this.blendRadiusField.setUnit(Units.getText().unitMm());
        this.blendRadiusField.setName(UntilDistanceCard.BLEND_RADIUS);
        this.blendRadiusField.setEnabled(false);
        this.blendRadiusField.setValue((Object)0.0);
        this.blendRadiusField.setValueConverter(UnitsValueConverterFactory.getLengthConverter());
        DecimalFormat usForamt = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#.###");
        DecimalFormat metricFormat = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#.##");
        if (Settings.getUnits().isUS()) {
            this.distanceNumberField.setFormat((Format)usForamt);
            this.blendRadiusField.setFormat((Format)usForamt);
        } else {
            this.distanceNumberField.setFormat((Format)metricFormat);
            this.blendRadiusField.setFormat((Format)metricFormat);
        }
        this.stopRadioButton = new JRadioButton(resource.stopAtThisPoint());
        this.stopRadioButton.setSelected(true);
        this.stopRadioButton.setName(UntilDistanceCard.STOP_BUTTON);
        this.blendRadioButton = new JRadioButton(resource.blendWithRadius());
        this.blendRadioButton.setName(UntilDistanceCard.BLEND_BUTTON);
        Box blendBox = Box.createHorizontalBox();
        blendBox.add(Box.createHorizontalStrut(36));
        blendBox.add((Component)this.blendRadiusField);
        JPanel untilPanel = this.initUntilPanel(this.untilNodesComboBox);
        JPanel contentPanel = this.viewContext.createFormBuilder().description(resource.UntilDistanceDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).end().description(resource.UntilActionDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(3).label(this.distanceLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)this.distanceNumberField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end(6).component(widgetFactory.createSeparator(G5LookAndFeel.BETWEEN_CARD_COLOR), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().component((JComponent)this.stopRadioButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)this.blendRadioButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)blendBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().getPanel();
        this.setLayout((LayoutManager)new VerticalLayout());
        this.add(untilPanel);
        this.add(contentPanel);
        ButtonGroup stopOrBlendButtonGroup = new ButtonGroup();
        stopOrBlendButtonGroup.add(this.stopRadioButton);
        this.stopRadioButton.addActionListener(evt -> this.blendRadiusField.setEnabled(false));
        this.stopRadioButton.addActionListener(new UntilDistanceCard.UpdateModel());
        stopOrBlendButtonGroup.add(this.blendRadioButton);
        this.blendRadioButton.addActionListener(evt -> this.blendRadiusField.setEnabled(true));
        this.blendRadioButton.addActionListener(new UntilDistanceCard.UpdateModel());
    }
}

