/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.until.persistence.UntilTypeConversionStrategy;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Length;
import gui.program.until.UntilNode;
import gui.program.until.types.UntilDistanceNode;

public class UntilDistanceConversionStrategy
implements UntilTypeConversionStrategy {
    public static final String DISTANCE_VALUE = "Distance";
    public static final String DECELERATION = "deceleration";
    public static final String MOTION_PARAMETERS_NODE = "motionParameters";
    public static final String BLEND_RADIUS_ATTRIBUTE = "blendRadius";
    public static final String DISTANCE_NODE_TYPE_ATTRIBUTE = "distanceNodeType";

    public void marshal(UntilTypeNode toMarshal, PersistWriter writer) {
        UntilDistanceNode node = (UntilDistanceNode)toMarshal;
        writer.addAttribute(DECELERATION, ((UntilDistanceNode)toMarshal).getDecelerationAcceleration().asDouble());
        writer.addAttribute(DISTANCE_NODE_TYPE_ATTRIBUTE, (Enum)node.getNodeType());
        if (node.getDistance() == UntilDistanceNode.EMPTY_DISTANCE) {
            writer.writeNodeWithValue(DISTANCE_VALUE, (Object)-1.0);
        } else {
            writer.writeNodeWithValue(DISTANCE_VALUE, (Object)node.getDistance().asDouble());
        }
        writer.startNode(MOTION_PARAMETERS_NODE);
        writer.addAttribute(BLEND_RADIUS_ATTRIBUTE, node.getBlendRadius().asDouble());
        writer.endNode();
    }

    public UntilTypeNode unmarshal(PersistReader reader, com.ur.polyscope.program.nodes.until.UntilNode parent) {
        Double deceleration = reader.getDoubleAttribute(DECELERATION);
        UntilDistanceNode.DistanceNodeType nodeType = (UntilDistanceNode.DistanceNodeType)reader.getEnumAttribute(DISTANCE_NODE_TYPE_ATTRIBUTE, UntilDistanceNode.DistanceNodeType.class, (Enum)UntilDistanceNode.DistanceNodeType.STOP);
        Length blendRadius = UntilDistanceNode.DEFAULT_BLEND_RADIUS;
        Length distance = Length.from((double)((Double)reader.readValueFromChildNode((Object)DISTANCE_VALUE, Double.class)), (Length.Unit)Length.Unit.SI);
        if (distance.asDouble() < 0.0) {
            distance = UntilDistanceNode.EMPTY_DISTANCE;
        }
        reader.moveToChildNode();
        if (reader.hasOneOfAttributes(new String[]{BLEND_RADIUS_ATTRIBUTE})) {
            blendRadius = Length.from((double)reader.getDoubleAttribute(BLEND_RADIUS_ATTRIBUTE), (Length.Unit)Length.Unit.SI);
        }
        reader.moveToParentNode();
        UntilDistanceNode node = new UntilDistanceNode(Acceleration.from((double)deceleration, (Acceleration.Unit)Acceleration.Unit.SI), distance, blendRadius, nodeType);
        node.setParent(parent);
        ((UntilNode)parent).setSelectedTypeNode(node);
        return node;
    }

    public UntilTypeNode.Type getType() {
        return UntilTypeNode.Type.DISTANCE;
    }
}

