/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.polyscope.program.nodes.until.MoveThreadScriptParams;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.util.Optional;
import com.ur.view.Settings;
import gui.program.until.UntilNode;

public class UntilDistanceNode
implements UntilTypeNode {
    public static final double EPSILON_US_UNIT = 0.001;
    public static final double EPSILON_METRIC_UNIT = 0.01;
    public static final Acceleration DEFAULT_DECELERATION = Acceleration.from((double)3.0, (Acceleration.Unit)Acceleration.Unit.SI);
    public static final Length DEFAULT_DISTANCE = Length.from((double)0.0, (Length.Unit)Length.Unit.SI);
    public static final Length EMPTY_DISTANCE = Length.INFINITE;
    public static final Length DEFAULT_BLEND_RADIUS = Length.from((double)0.0, (Length.Unit)Length.Unit.SI);
    private final Acceleration deceleration;
    private final Length distance;
    private final Length blendRadius;
    private final DistanceNodeType nodeType;
    private UntilNode parent = null;

    public UntilDistanceNode() {
        this(DEFAULT_DECELERATION, EMPTY_DISTANCE, DEFAULT_BLEND_RADIUS, DistanceNodeType.STOP);
    }

    public UntilDistanceNode(Length distance) {
        this(DEFAULT_DECELERATION, distance, DEFAULT_BLEND_RADIUS, DistanceNodeType.STOP);
    }

    public UntilDistanceNode(Length distance, Length blendRadius, DistanceNodeType nodeType) {
        this(DEFAULT_DECELERATION, distance, blendRadius, nodeType);
    }

    public UntilDistanceNode(Acceleration decelerationAcceleration, Length distance, Length blendRadius, DistanceNodeType nodeType) {
        this.deceleration = decelerationAcceleration;
        this.distance = distance;
        this.blendRadius = distance.equals((Object)Length.ZERO) && blendRadius.isGreaterThan(Length.ZERO) ? Length.ZERO : blendRadius;
        this.nodeType = nodeType;
    }

    public static Length getValidBlendRadius(Length blendRadius, Length maxBlendRadius) {
        if (blendRadius.isGreaterThan(Length.ZERO)) {
            double maxBlendRadiusMM;
            if (Settings.getUnits().isUS()) {
                double maxBlendRadiusIn;
                double blendRadiusIn = URMath.roundUpDouble((double)blendRadius.getIn(Length.Unit.INCH), (int)3);
                if (blendRadiusIn >= (maxBlendRadiusIn = URMath.roundUpDouble((double)maxBlendRadius.getIn(Length.Unit.INCH), (int)3))) {
                    blendRadiusIn = maxBlendRadiusIn - 0.001;
                }
                return Length.from((double)blendRadiusIn, (Length.Unit)Length.Unit.INCH);
            }
            double blendRadiusMM = URMath.roundUpDouble((double)blendRadius.getIn(Length.Unit.MM), (int)2);
            if (blendRadiusMM >= (maxBlendRadiusMM = URMath.roundUpDouble((double)maxBlendRadius.getIn(Length.Unit.MM), (int)2))) {
                blendRadiusMM = maxBlendRadiusMM - 0.01;
            }
            return Length.from((double)blendRadiusMM, (Length.Unit)Length.Unit.MM);
        }
        return DEFAULT_BLEND_RADIUS;
    }

    public String generateScriptCode(Optional<MoveThreadScriptParams> moveThreadScriptParams) {
        ScriptWriter writer = new ScriptWriter();
        writer.sleep(1.0E-10);
        if (moveThreadScriptParams.isPresent()) {
            writer.ifCondition(((MoveThreadScriptParams)moveThreadScriptParams.get()).moveThreadCondition);
            writer.writeScript("join " + ((MoveThreadScriptParams)moveThreadScriptParams.get()).threadHandle);
            this.parent.generateUntilActionsScript(writer);
            writer.end();
        } else {
            writer.ifCondition("True");
            this.parent.generateUntilActionsScript(writer);
            writer.end();
        }
        return writer.generateScript();
    }

    public boolean isUndefined() {
        boolean isValidBlendRadius;
        boolean bl = isValidBlendRadius = this.nodeType == DistanceNodeType.STOP || this.getDistance().isGreaterThan(this.getBlendRadius()) || this.distance.asDouble() == 0.0 && this.blendRadius.asDouble() == 0.0;
        return this.distance == EMPTY_DISTANCE || this.distance.asDouble() < 0.0 || !isValidBlendRadius;
    }

    public UntilNode getParent() {
        return this.parent;
    }

    public void setParent(com.ur.polyscope.program.nodes.until.UntilNode parent) {
        this.parent = (UntilNode)parent;
    }

    public UntilDistanceNode clone() {
        return new UntilDistanceNode(this.deceleration, this.distance, this.blendRadius, this.nodeType);
    }

    public UntilTypeNode.Type getType() {
        return UntilTypeNode.Type.DISTANCE;
    }

    public Acceleration getDecelerationAcceleration() {
        return this.deceleration;
    }

    public Length getDistance() {
        return this.distance;
    }

    public Length getBlendRadius() {
        return this.blendRadius;
    }

    public DistanceNodeType getNodeType() {
        return this.nodeType;
    }

    public Length getBlendRadiusValue() {
        if (this.nodeType == DistanceNodeType.BLEND) {
            return this.blendRadius;
        }
        return Length.from((double)0.0, (Length.Unit)Length.Unit.SI);
    }

    public Length getMaxBlendRadius() {
        return this.getDistance();
    }

    public boolean isUseSharedBlendParameter() {
        return this.nodeType == DistanceNodeType.STOP;
    }

    public boolean isValidForMoveThread() {
        return this.distance.isGreaterThan(this.blendRadius) && this.distance.isGreaterThan(Length.ZERO);
    }

    public String toString() {
        return "{UntilNode: {type: \"Distance\", deceleration: " + this.deceleration + ", distanceValue: " + this.distance + "m, blend: " + this.blendRadius + ", directionNodeType: " + (Object)((Object)this.nodeType) + "}}";
    }

    @Deprecated
    public double getDeceleration() {
        throw new RuntimeException("We shouldn't use this method");
    }

    @Deprecated
    public void setDeceleration(double v) {
    }

    public static enum DistanceNodeType {
        STOP,
        BLEND;

    }
}

