/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.until.contribution.UntilNodeContribution;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.AngularAcceleration;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.swing.expression.field.ExpressionField;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.ValidationStrategy;
import gui.program.ProgramRootNode;
import gui.program.until.UntilNode;
import gui.program.until.deceleration.UntilDeceleration;
import gui.program.until.deceleration.UntilDecelerationCustom;
import gui.program.until.deceleration.UntilDecelerationShared;
import gui.program.until.types.OptiMoveWithSharedDeceleration;
import gui.program.until.types.UntilExpressionPresenter;
import gui.program.until.types.UntilExpressionView;
import gui.program.until.types.UntilTypeCard;
import gui.program.validation.MoveNodeValidationStrategyProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.VerticalLayout;

public class UntilExpressionCard
extends UntilTypeCard
implements UntilExpressionView {
    private static final String EXPRESSION_EDITOR = "expressionEditorButton." + UntilExpressionCard.class.getSimpleName();
    private static final String DECELERATION_VALUE = "decelerationValue." + UntilExpressionCard.class.getSimpleName();
    private static final String USE_DEFAULT_DECELERATION = "useDefaultDecelerationButton." + UntilExpressionCard.class.getSimpleName();
    private static final String USE_CUSTOM_DECELERATION = "useCustomDecelerationButton." + UntilExpressionCard.class.getSimpleName();
    protected final ViewContext viewContext;
    protected final UntilExpressionPresenter presenter;
    private final JComboBox untilNodesComboBox;
    private final ExpressionField expEditTextField;
    private final MoveNodeValidationStrategyProvider validationStrategyProvider;
    private final List<UntilNodeContribution> untilNodeContributions;
    private final OptiMoveWithSharedDeceleration optiMoveSupport;
    private NumberField decelerationNumberField;
    private JRadioButton useSharedDeceleration;
    private JRadioButton useCustomDeceleration;
    private final ButtonGroup decelerationButtonGroup = new ButtonGroup();
    private boolean updating;

    @Inject
    UntilExpressionCard(UntilExpressionPresenter presenter, ExpressionField expEditTextField, ViewContext viewContext, MoveNodeValidationStrategyProvider validationStrategyProvider, Set<UntilNodeContribution> untilNodeContributions) {
        super(viewContext);
        this.presenter = presenter;
        this.expEditTextField = expEditTextField;
        this.viewContext = viewContext;
        this.validationStrategyProvider = validationStrategyProvider;
        this.untilNodeContributions = this.getUntilConditionOptions(untilNodeContributions);
        this.untilNodesComboBox = this.createUntilTypeComboBox();
        this.optiMoveSupport = new OptiMoveWithSharedDeceleration((TextResource)viewContext.getTextResource(TextResource.class));
        this.initComponents();
        this.assignHelpIds();
        presenter.setView(this);
    }

    @Override
    public void initComponents() {
        JPanel untilPanel = this.initUntilPanel(this.untilNodesComboBox);
        JPanel explanationPanel = this.initExplanationPanel();
        JPanel settingsPanel = this.initSettingsPanel();
        this.setLayout((LayoutManager)new VerticalLayout());
        this.add(untilPanel);
        this.add(explanationPanel);
        this.add(settingsPanel);
    }

    private JPanel initSettingsPanel() {
        this.expEditTextField.addActionListener((ActionListener)new UpdateModel());
        this.expEditTextField.setHorizontalAlignment(0);
        this.expEditTextField.setPreferredSize(new Dimension(300, 28));
        this.expEditTextField.setName(EXPRESSION_EDITOR);
        this.useSharedDeceleration = new JRadioButton(((TextResource)this.viewContext.getTextResource(TextResource.class)).UseSharedDeceleration());
        this.useSharedDeceleration.addActionListener(new UpdateModel());
        this.useSharedDeceleration.setName(USE_DEFAULT_DECELERATION);
        this.useCustomDeceleration = new JRadioButton(((TextResource)this.viewContext.getTextResource(TextResource.class)).UseCustomDeceleration());
        this.useCustomDeceleration.addActionListener(new UpdateModel());
        this.useCustomDeceleration.setName(USE_CUSTOM_DECELERATION);
        this.decelerationButtonGroup.add(this.useSharedDeceleration);
        this.decelerationButtonGroup.add(this.useCustomDeceleration);
        this.decelerationNumberField = this.viewContext.createWidgetFactory().createNumberField((ActionListener)new UpdateModel());
        this.decelerationNumberField.setName(DECELERATION_VALUE);
        this.decelerationNumberField.setUnitWidth(55);
        this.decelerationNumberField.setMode(Mode.PositiveNumbers);
        Box decelerationBox = Box.createHorizontalBox();
        decelerationBox.add(Box.createHorizontalStrut(36));
        decelerationBox.add((Component)this.decelerationNumberField);
        JPanel settingsPanel = this.viewContext.createFormBuilder().component((JComponent)this.expEditTextField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end(2).component((JComponent)this.useSharedDeceleration, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().component((JComponent)this.useCustomDeceleration, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).end().component((JComponent)decelerationBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().getPanel();
        settingsPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        return settingsPanel;
    }

    private JPanel initExplanationPanel() {
        JPanel explanationPanel = this.viewContext.createFormBuilder().description(((TextResource)this.viewContext.getTextResource(TextResource.class)).UntilExpressionDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).description(((TextResource)this.viewContext.getTextResource(TextResource.class)).UntilActionDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).getPanel();
        explanationPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        return explanationPanel;
    }

    @Override
    public void enter(Object o) {
        this.presenter.setModel((UntilNode)o);
        super.enter(o);
    }

    public void textHasChanged() {
        ((UntilNode)this.getNode()).textHasChanged();
        ProgramRootNode.get((AbstractProgramNode)this.getNode()).textHasChanged();
    }

    @Override
    public void updateView(ExpressionBranchNode expressionBranchNode, UntilDeceleration deceleration) {
        this.updating = true;
        this.expEditTextField.setExpression(expressionBranchNode);
        this.updateDecelerationField(deceleration);
        this.updating = false;
    }

    @Override
    protected void updateCard() {
        this.presenter.updateView();
        this.setUntilNodeComboBoxModel(this.untilNodesComboBox, UntilTypeNode.Type.EXPRESSION, this.untilNodeContributions);
    }

    private void assignHelpIds() {
        this.helpIdAssigner.assignHelpId((JComponent)((Object)this), "gui:command_script");
    }

    private void updateDecelerationField(UntilDeceleration deceleration) {
        if (((UntilNode)this.getNode()).isCartesianMovement()) {
            this.decelerationNumberField.setValueConverter(UnitsValueConverterFactory.getAccelerationConverter());
            this.decelerationNumberField.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getCartesianJointAccelerationLimitValidator()});
            this.decelerationNumberField.setValue((Object)deceleration.getCartesianDeceleration());
        } else {
            this.decelerationNumberField.setValueConverter(UnitsValueConverterFactory.getAngularAccelerationConverter());
            this.decelerationNumberField.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getJointAccelerationLimitValidator()});
            this.decelerationNumberField.setValue((Object)deceleration.getAngularDeceleration());
        }
        this.updateRadioButtons(false);
        this.updateRadioButtons(deceleration.getType() == UntilDeceleration.Type.SHARED);
        this.optiMoveSupport.updateSharedDeceleration(this.useSharedDeceleration, (UntilNode)this.getNode());
    }

    private void updateRadioButtons(boolean isUseSharedDeceleration) {
        this.useSharedDeceleration.setSelected(isUseSharedDeceleration);
        this.useCustomDeceleration.setSelected(!isUseSharedDeceleration);
        this.decelerationNumberField.setEnabled(!isUseSharedDeceleration);
    }

    protected class UpdateModel
    implements ActionListener {
        protected UpdateModel() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateModel();
            ((UntilNode)UntilExpressionCard.this.getNode()).textHasChanged();
        }

        private void updateModel() {
            if (UntilExpressionCard.this.updating) {
                return;
            }
            UntilDeceleration deceleration = UntilExpressionCard.this.useSharedDeceleration.isSelected() ? new UntilDecelerationShared((UntilNode)UntilExpressionCard.this.getNode()) : (((UntilNode)UntilExpressionCard.this.getNode()).isCartesianMovement() ? new UntilDecelerationCustom((Acceleration)UntilExpressionCard.this.decelerationNumberField.getValue()) : new UntilDecelerationCustom((AngularAcceleration)UntilExpressionCard.this.decelerationNumberField.getValue()));
            UntilExpressionCard.this.presenter.updateModel(UntilExpressionCard.this.expEditTextField.getExpression(), deceleration);
        }
    }
}

