/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.nodes.until.persistence.UntilTypeConversionStrategy;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.AngularAcceleration;
import com.ur.swing.expression.ExpressionBranchNode;
import gui.program.until.UntilNode;
import gui.program.until.deceleration.UntilDeceleration;
import gui.program.until.deceleration.UntilDecelerationCustom;
import gui.program.until.deceleration.UntilDecelerationShared;
import gui.program.until.types.UntilExpressionNode;

public class UntilExpressionConversionStrategy
implements UntilTypeConversionStrategy {
    public static final String DECELERATION = "deceleration";

    public void marshal(UntilTypeNode toMarshal, PersistWriter writer) {
        UntilExpressionNode node = (UntilExpressionNode)toMarshal;
        UntilDeceleration deceleration = node.getUntilDeceleration();
        if (deceleration.getType() == UntilDeceleration.Type.CUSTOM) {
            if (node.getParent().isCartesianMovement()) {
                writer.addAttribute(DECELERATION, ((UntilDecelerationCustom)deceleration).cartesianDeceleration.getIn(Acceleration.Unit.SI));
            } else {
                writer.addAttribute(DECELERATION, ((UntilDecelerationCustom)deceleration).angularDeceleration.getIn(AngularAcceleration.Unit.SI));
            }
        }
        writer.writeNodeWithValue((Object)node.getExpression());
    }

    public UntilTypeNode unmarshal(PersistReader reader, com.ur.polyscope.program.nodes.until.UntilNode parent) {
        ExpressionBranchNode expressionBranchNode;
        double deceleration = -1.0;
        if (reader.hasOneOfAttributes(new String[]{DECELERATION})) {
            deceleration = reader.getDoubleAttribute(DECELERATION);
        }
        if ((expressionBranchNode = (ExpressionBranchNode)reader.readValueFromChildNode(ExpressionBranchNode.class)).isUndefined()) {
            expressionBranchNode = new ExpressionBranchNode();
        }
        UntilExpressionNode node = deceleration >= 0.0 ? (((UntilNode)parent).isCartesianMovement() ? new UntilExpressionNode(expressionBranchNode, new UntilDecelerationCustom(Acceleration.from((double)deceleration, (Acceleration.Unit)Acceleration.Unit.SI))) : new UntilExpressionNode(expressionBranchNode, new UntilDecelerationCustom(AngularAcceleration.from((double)deceleration, (AngularAcceleration.Unit)AngularAcceleration.Unit.SI)))) : new UntilExpressionNode(expressionBranchNode, new UntilDecelerationShared((UntilNode)parent));
        ((UntilNode)parent).setSelectedTypeNode(node);
        return node;
    }

    public UntilTypeNode.Type getType() {
        return UntilTypeNode.Type.EXPRESSION;
    }
}

