/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.polyscope.program.nodes.until.MoveThreadScriptParams;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.util.Optional;
import gui.program.MotionDefiningNode;
import gui.program.until.UntilNode;
import gui.program.until.deceleration.UntilDeceleration;
import gui.program.until.deceleration.UntilDecelerationShared;

public class UntilExpressionNode
implements UntilTypeNode {
    private final ExpressionBranchNode expressionBranchNode;
    private UntilNode parent = null;
    private UntilDeceleration deceleration;

    public UntilExpressionNode() {
        this(new ExpressionBranchNode(), new UntilDecelerationShared(null));
    }

    public UntilExpressionNode(ExpressionBranchNode expressionBranchNode, UntilDeceleration deceleration) {
        this.expressionBranchNode = expressionBranchNode;
        this.deceleration = deceleration;
    }

    public String generateScriptCode(Optional<MoveThreadScriptParams> moveThreadScriptParams) {
        ScriptWriter writer = new ScriptWriter();
        writer.ifCondition(this.expressionBranchNode.generateScriptCode());
        if (moveThreadScriptParams.isPresent()) {
            writer.killThread(((MoveThreadScriptParams)moveThreadScriptParams.get()).threadHandle);
        }
        this.deceleration.generateStopScript(writer, this.parent);
        this.parent.generateUntilActionsScript(writer);
        writer.end();
        return writer.generateScript();
    }

    public UntilDeceleration getUntilDeceleration() {
        return this.deceleration;
    }

    public ExpressionBranchNode getExpression() {
        return this.expressionBranchNode;
    }

    public boolean isUndefined() {
        if (this.deceleration.getType() == UntilDeceleration.Type.SHARED) {
            return this.isUsingOptiMove();
        }
        return this.expressionBranchNode.isUndefined();
    }

    private boolean isUsingOptiMove() {
        MotionDefiningNode motionNode = (MotionDefiningNode)this.getParent().getNodeOfType(MotionDefiningNode.class);
        if (motionNode == null) {
            return false;
        }
        return motionNode.isUsingOptiMove();
    }

    public UntilNode getParent() {
        return this.parent;
    }

    public void setParent(com.ur.polyscope.program.nodes.until.UntilNode parent) {
        this.parent = (UntilNode)parent;
        if (this.deceleration instanceof UntilDecelerationShared) {
            this.deceleration = new UntilDecelerationShared(this.parent);
        }
    }

    public UntilExpressionNode clone() {
        return new UntilExpressionNode(this.expressionBranchNode.clone(), this.deceleration);
    }

    public UntilTypeNode.Type getType() {
        return UntilTypeNode.Type.EXPRESSION;
    }

    public String toString() {
        return "{UntilNode: {type: \"Expression\", expression: " + this.expressionBranchNode.toString() + ", deceleration: " + this.deceleration.toString() + "}}";
    }

    public double getDeceleration() {
        throw new RuntimeException("We shouldn't use this method");
    }

    public void setDeceleration(double v) {
    }
}

