/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.until.contribution.UntilNodeContribution;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import gui.program.until.UntilNode;
import gui.program.until.types.UntilIONode;
import gui.program.until.types.UntilTypeCard;
import gui.program.until.types.infrastructure.UntilIONodeViewPart;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.VerticalLayout;

public class UntilIOCard
extends UntilTypeCard {
    public static final String UNTIL_DIGITAL_INPUT = "untilDigitalInput.UntilIOCard";
    public static final String DIGITAL_INPUT = "digitalInput.UntilIOCard";
    public static final String DIGITAL_VALUE = "digitalValue.UntilIOCard";
    public static final String UNTIL_ANALOG_INPUT = "untilAnalogInput.UntilIOCard";
    public static final String ANALOG_INPUT = "analogInput.UntilIOCard";
    public static final String ANALOG_COMPARISION = "analogComparision.UntilIOCard";
    public static final String ANALOG_VALUE = "analogValue.UntilIOCard";
    private final Map<UntilIONode.IOType, UntilIONodeViewPart> untilConditions;
    private final ViewContext viewContext;
    protected final List<UntilNodeContribution> untilNodeContributions;
    private EnumButtonGroup<UntilIONode.IOType> buttonGroup;
    private final JComboBox untilNodesComboBox;

    @Inject
    public UntilIOCard(ViewContext viewContext, Map<UntilIONode.IOType, UntilIONodeViewPart> untilConditions, Set<UntilNodeContribution> untilNodeContributions) {
        super(viewContext);
        this.untilConditions = untilConditions;
        this.viewContext = viewContext;
        this.untilNodeContributions = this.getUntilConditionOptions(untilNodeContributions);
        this.untilNodesComboBox = this.createUntilTypeComboBox();
        this.initComponents();
    }

    public Object exit() {
        for (UntilIONode.IOType each : this.untilConditions.keySet()) {
            this.untilConditions.get((Object)each).exit();
        }
        return super.exit();
    }

    @Override
    protected void updateCard() {
        for (UntilIONode.IOType each : this.untilConditions.keySet()) {
            this.untilConditions.get((Object)each).enter((UntilNode)this.getNode());
        }
        this.buttonGroup.select((Enum)((UntilIONode)((UntilNode)this.getNode()).getSelectedTypeNode()).getIOType());
        this.setUntilNodeComboBoxModel(this.untilNodesComboBox, UntilTypeNode.Type.IO, this.untilNodeContributions);
    }

    @Override
    protected void initComponents() {
        JPanel explanationPanel = this.initExplanationPanel();
        JPanel settingsPanel = this.initSettingsPanel();
        JPanel untilPanel = this.initUntilPanel(this.untilNodesComboBox);
        this.setLayout((LayoutManager)new VerticalLayout());
        this.add(untilPanel);
        this.add(explanationPanel);
        this.add(settingsPanel);
    }

    private JPanel initSettingsPanel() {
        JRadioButton noneSelectedInvisibleRadioButton = new JRadioButton();
        noneSelectedInvisibleRadioButton.setText("iAmInvisible");
        this.buttonGroup = new EnumButtonGroup(UntilIONode.IOType.class);
        this.buttonGroup.add((Enum)UntilIONode.IOType.NONE, (AbstractButton)noneSelectedInvisibleRadioButton);
        JPanel viewParts = this.viewContext.createWidgetFactory().verticalPanel(5);
        UntilIONode.IOType[] iOTypeArray = UntilIONode.IOType.values();
        int n = iOTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            UntilIONode.IOType each = iOTypeArray[n2];
            if (this.untilConditions.containsKey((Object)each)) {
                UntilIONodeViewPart selection = this.untilConditions.get((Object)each);
                selection.setButtonGroup(this.buttonGroup);
                viewParts.add(selection.getPanel());
            }
            ++n2;
        }
        JPanel settingsPanel = this.viewContext.createFormBuilder().component((JComponent)viewParts, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_10_ROWS, FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).end(11).getPanel();
        settingsPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        return settingsPanel;
    }

    private JPanel initExplanationPanel() {
        JPanel explanationPanel = this.viewContext.createFormBuilder().description(((TextResource)this.viewContext.getTextResource(TextResource.class)).untilIODescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).end().description(((TextResource)this.viewContext.getTextResource(TextResource.class)).UntilActionDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).getPanel();
        explanationPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        return explanationPanel;
    }
}

