/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.program.nodes.until.persistence.UntilTypeConversionStrategy;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.util.Optional;
import gui.program.until.UntilNode;
import gui.program.until.types.AnalogPinReference;
import gui.program.until.types.DigitalPinReference;
import gui.program.until.types.UntilIONode;

public class UntilIOConversionStrategy
implements UntilTypeConversionStrategy {
    private static final String TYPE = "ioType";
    private static final String PIN_NODE = "pin";
    private static final String ANALOG_VALUE = "analogValue";
    private static final String ANALOG_COMPARISON = "analogComparison";
    private static final String DIGITAL_VALUE = "digitalValue";

    public void marshal(UntilTypeNode toMarshal, PersistWriter writer) {
        UntilIONode node = (UntilIONode)toMarshal;
        UntilIONode.IOType type = node.getIOType();
        writer.addAttribute(TYPE, (Enum)type);
        switch (type) {
            case DIGITAL_INPUT: {
                this.writeDigitalValue(node, writer);
                this.writeDigitalPinReference(node, writer);
                break;
            }
            case ANALOG_INPUT: {
                this.writeAnalogComparison(node, writer);
                this.writeAnalogValue(node, writer);
                this.writeAnalogPinReference(node, writer);
                break;
            }
        }
    }

    public UntilTypeNode unmarshal(PersistReader reader, com.ur.polyscope.program.nodes.until.UntilNode parent) {
        UntilIONode node;
        UntilIONode.IOType type = (UntilIONode.IOType)reader.getEnumAttribute(TYPE, UntilIONode.IOType.class);
        switch (type) {
            case DIGITAL_INPUT: {
                node = this.getDigitalUntilIO(reader);
                break;
            }
            case ANALOG_INPUT: {
                node = this.getAnalogUntilIO(reader);
                break;
            }
            default: {
                node = new UntilIONode();
            }
        }
        ((UntilNode)parent).setSelectedTypeNode(node);
        return node;
    }

    private UntilIONode getDigitalUntilIO(PersistReader reader) {
        DigitalPinReference digitalPinReference = new DigitalPinReference(reader.getBooleanAttribute(DIGITAL_VALUE));
        if (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            String nodeName = reader.getNodeName();
            if (PIN_NODE.equals(nodeName)) {
                digitalPinReference = new DigitalPinReference((Optional<PinReference>)Optional.of((Object)this.readPinReference(reader)), digitalPinReference.getValue());
            }
            reader.moveToParentNode();
        }
        return new UntilIONode(digitalPinReference);
    }

    private UntilIONode getAnalogUntilIO(PersistReader reader) {
        AnalogPinReference analogPinReference = new AnalogPinReference((AnalogPinReference.Comparision)reader.getEnumAttribute(ANALOG_COMPARISON, AnalogPinReference.Comparision.class), reader.getDoubleAttribute(ANALOG_VALUE));
        if (reader.hasMoreNodes()) {
            reader.moveToChildNode();
            String nodeName = reader.getNodeName();
            if (PIN_NODE.equals(nodeName)) {
                analogPinReference = new AnalogPinReference((Optional<PinReference>)Optional.of((Object)this.readPinReference(reader)), analogPinReference.getComparision(), analogPinReference.getValue());
            }
            reader.moveToParentNode();
        }
        return new UntilIONode(analogPinReference);
    }

    public UntilTypeNode.Type getType() {
        return UntilTypeNode.Type.IO;
    }

    private void writeAnalogPinReference(UntilIONode node, PersistWriter writer) {
        Optional<PinReference> pinReference = ((AnalogPinReference)node.getAnalogPinReference().get()).getPinReference();
        if (pinReference.isPresent()) {
            this.writePinReference((PinReference)pinReference.get(), writer);
        }
    }

    private void writeDigitalPinReference(UntilIONode node, PersistWriter writer) {
        Optional<PinReference> pinReference = ((DigitalPinReference)node.getDigitalPinReference().get()).getPinReference();
        if (pinReference.isPresent()) {
            this.writePinReference((PinReference)pinReference.get(), writer);
        }
    }

    private void writePinReference(PinReference reference, PersistWriter writer) {
        writer.writeNodeWithValue(PIN_NODE, (Object)reference);
    }

    private PinReference readPinReference(PersistReader reader) {
        return (PinReference)reader.convertContainedValue(PinReference.class);
    }

    private void writeAnalogValue(UntilIONode node, PersistWriter writer) {
        writer.addAttribute(ANALOG_VALUE, ((AnalogPinReference)node.getAnalogPinReference().get()).getValue());
    }

    private void writeAnalogComparison(UntilIONode node, PersistWriter writer) {
        writer.addAttribute(ANALOG_COMPARISON, (Enum)((AnalogPinReference)node.getAnalogPinReference().get()).getComparision());
    }

    private void writeDigitalValue(UntilIONode node, PersistWriter writer) {
        writer.addAttribute(DIGITAL_VALUE, ((DigitalPinReference)node.getDigitalPinReference().get()).getValue());
    }
}

