/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.math.Acceleration;
import com.ur.math.AngularAcceleration;
import com.ur.polyscope.pin.AnalogIOPin;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.program.nodes.until.MoveThreadScriptParams;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.util.Optional;
import gui.program.until.UntilNode;
import gui.program.until.types.AnalogPinReference;
import gui.program.until.types.DigitalPinReference;
import java.util.Collection;

public class UntilIONode
implements UntilTypeNode {
    private static final Acceleration DEFAULT_SPEED_DECELERATION = Acceleration.from((double)3.0, (Acceleration.Unit)Acceleration.Unit.SI);
    private static final AngularAcceleration DEFAULT_ANGLE_DECELERATION = AngularAcceleration.from((double)180.0, (AngularAcceleration.Unit)AngularAcceleration.Unit.DEGREES);
    private UntilNode parent;
    private final IOType ioType;
    private Optional<DigitalPinReference> digitalPinReference;
    private Optional<AnalogPinReference> analogPinReference;

    public UntilIONode() {
        this.ioType = IOType.NONE;
        this.digitalPinReference = Optional.empty();
        this.analogPinReference = Optional.empty();
    }

    public UntilIONode(DigitalPinReference pinReference) {
        this.ioType = IOType.DIGITAL_INPUT;
        this.digitalPinReference = Optional.of((Object)pinReference);
        this.analogPinReference = Optional.empty();
    }

    public UntilIONode(AnalogPinReference pinReference) {
        this.ioType = IOType.ANALOG_INPUT;
        this.digitalPinReference = Optional.empty();
        this.analogPinReference = Optional.of((Object)pinReference);
    }

    public IOType getIOType() {
        return this.ioType;
    }

    public String generateScriptCode(Optional<MoveThreadScriptParams> moveThreadScriptParams) {
        ScriptWriter writer = new ScriptWriter();
        writer.ifCondition(this.getIfCondition());
        if (moveThreadScriptParams.isPresent()) {
            writer.killThread(((MoveThreadScriptParams)moveThreadScriptParams.get()).threadHandle);
        }
        if (this.parent.isCartesianMovement()) {
            writer.stopl(DEFAULT_SPEED_DECELERATION.asDouble());
        } else {
            writer.stopj(DEFAULT_ANGLE_DECELERATION.asDouble());
        }
        this.parent.generateUntilActionsScript(writer);
        writer.end();
        return writer.generateScript();
    }

    private String getIfCondition() {
        String condition;
        switch (this.ioType) {
            case DIGITAL_INPUT: {
                condition = ((DigitalPinReference)this.digitalPinReference.get()).getScript();
                break;
            }
            case ANALOG_INPUT: {
                condition = ((AnalogPinReference)this.analogPinReference.get()).getScript();
                break;
            }
            default: {
                condition = "False";
            }
        }
        return condition;
    }

    public boolean isUndefined() {
        boolean undefined;
        switch (this.ioType) {
            case DIGITAL_INPUT: {
                undefined = !((DigitalPinReference)this.digitalPinReference.get()).getPinReference().isPresent() || ((PinReference)((DigitalPinReference)this.digitalPinReference.get()).getPinReference().get()).isUndefined() || !((PinReference)((DigitalPinReference)this.digitalPinReference.get()).getPinReference().get()).dereference().isInput();
                break;
            }
            case ANALOG_INPUT: {
                Optional<PinReference> pinReference = ((AnalogPinReference)this.analogPinReference.get()).getPinReference();
                undefined = !pinReference.isPresent() || ((PinReference)pinReference.get()).isUndefined() || !((PinReference)pinReference.get()).dereference().isInput() || ((PinReference)pinReference.get()).dereference() instanceof AnalogIOPin && ((AnalogIOPin)((PinReference)pinReference.get()).dereference()).isAssignedForToolComm();
                break;
            }
            default: {
                undefined = true;
            }
        }
        return undefined;
    }

    public void setParent(com.ur.polyscope.program.nodes.until.UntilNode parent) {
        this.parent = (UntilNode)parent;
    }

    public UntilNode getParent() {
        return this.parent;
    }

    public UntilTypeNode clone() {
        UntilIONode clone;
        switch (this.ioType) {
            case DIGITAL_INPUT: {
                clone = new UntilIONode((DigitalPinReference)this.digitalPinReference.get());
                break;
            }
            case ANALOG_INPUT: {
                clone = new UntilIONode((AnalogPinReference)this.analogPinReference.get());
                break;
            }
            default: {
                clone = new UntilIONode();
            }
        }
        return clone;
    }

    public UntilTypeNode.Type getType() {
        return UntilTypeNode.Type.IO;
    }

    public Optional<DigitalPinReference> getDigitalPinReference() {
        return this.digitalPinReference;
    }

    public Optional<AnalogPinReference> getAnalogPinReference() {
        return this.analogPinReference;
    }

    public String toString() {
        return "{UntilNode: {type: \"IO\", ioType: \"" + this.ioType.toString() + "\"}}";
    }

    public double getDeceleration() {
        throw new RuntimeException("We shouldn't use this method");
    }

    public void setDeceleration(double v) {
    }

    public void getInternalProgramEntities(Collection<Object> collection) {
        if (this.getDigitalPinReference().isPresent() && ((DigitalPinReference)this.getDigitalPinReference().get()).getPinReference().isPresent()) {
            collection.add(((DigitalPinReference)this.getDigitalPinReference().get()).getPinReference().get());
        }
        if (this.getAnalogPinReference().isPresent() && ((AnalogPinReference)this.getAnalogPinReference().get()).getPinReference().isPresent()) {
            collection.add(((AnalogPinReference)this.getAnalogPinReference().get()).getPinReference().get());
        }
    }

    public boolean doSubstituteReference(Object original, Object substitute) {
        if (!(original instanceof PinReference)) {
            return false;
        }
        if (this.getDigitalPinReference().isPresent() && ((DigitalPinReference)this.getDigitalPinReference().get()).getPinReference().isPresent() && original == ((DigitalPinReference)this.getDigitalPinReference().get()).getPinReference().get()) {
            this.digitalPinReference = Optional.of((Object)new DigitalPinReference((Optional<PinReference>)Optional.of((Object)((PinReference)substitute)), ((DigitalPinReference)this.digitalPinReference.get()).getValue()));
            return true;
        }
        if (this.getAnalogPinReference().isPresent() && ((AnalogPinReference)this.getAnalogPinReference().get()).getPinReference().isPresent() && original == ((AnalogPinReference)this.getAnalogPinReference().get()).getPinReference().get()) {
            this.analogPinReference = Optional.of((Object)new AnalogPinReference((Optional<PinReference>)Optional.of((Object)((PinReference)substitute)), ((AnalogPinReference)this.getAnalogPinReference().get()).getComparision(), ((AnalogPinReference)this.getAnalogPinReference().get()).getValue()));
            return true;
        }
        return false;
    }

    public static enum IOType {
        NONE,
        DIGITAL_INPUT,
        ANALOG_INPUT;

    }
}

