/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types;

import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.until.contribution.UntilNodeContribution;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.DefaultComboBoxRenderer;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.util.swing.HTML;
import com.ur.view.program.CommandPanel;
import gui.program.direction.MoveDirectionNode;
import gui.program.position.WaypointNode;
import gui.program.until.UntilNode;
import gui.program.until.contribution.UntilDistanceNodeContribution;
import gui.program.until.contribution.UntilReachedWaypointNodeContribution;
import gui.tools.LegacyURDialogCreator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class UntilTypeCard
extends CommandPanel<UntilNode> {
    protected static final int INSERT_LEFT = 10;
    protected static final int INSERT_BOTTOM = 0;
    protected static final int INSERT_RIGHT = 10;
    private final ViewContext viewContext;
    protected HelpIdAssigner helpIdAssigner;
    private boolean entering;

    @Inject
    protected UntilTypeCard(ViewContext viewContext) {
        super(UntilNode.class);
        this.viewContext = viewContext;
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
    }

    @Override
    public void enter(Object o) {
        this.entering = true;
        super.enter(o);
        this.entering = false;
    }

    protected abstract void initComponents();

    protected List<UntilNodeContribution> getUntilConditionOptions(Set<UntilNodeContribution> untilNodeContributions) {
        ArrayList<UntilNodeContribution> untilConditionOptions = new ArrayList<UntilNodeContribution>();
        for (UntilNodeContribution unc : untilNodeContributions) {
            untilConditionOptions.add(unc);
        }
        Collections.sort(untilConditionOptions, new Comparator<UntilNodeContribution>(){

            @Override
            public int compare(UntilNodeContribution a, UntilNodeContribution b) {
                return a.getUntilTypeNode().getType().ordinal() - b.getUntilTypeNode().getType().ordinal();
            }
        });
        return untilConditionOptions;
    }

    protected List<UntilNodeContribution> filterContributions(List<UntilNodeContribution> untilConditionOptions) {
        ArrayList<UntilNodeContribution> filteredContributions = new ArrayList<UntilNodeContribution>();
        UntilNode node = (UntilNode)this.getNode();
        if (node != null) {
            for (UntilNodeContribution contribution : untilConditionOptions) {
                if ((!(node.getParent() instanceof WaypointNode) || contribution instanceof UntilDistanceNodeContribution) && (!(node.getParent() instanceof MoveDirectionNode) || contribution instanceof UntilReachedWaypointNodeContribution)) continue;
                filteredContributions.add(contribution);
            }
        }
        return filteredContributions;
    }

    protected void setUntilNodeComboBoxModel(JComboBox untilNodeComboBox, UntilTypeNode.Type type, List<UntilNodeContribution> untilNodeContributions) {
        boolean differentUntilType;
        boolean isWaypoint = ((UntilNode)this.getNode()).getParent() instanceof WaypointNode;
        boolean parentSwitch = false;
        int i = 0;
        while (i < untilNodeComboBox.getItemCount()) {
            UntilNodeContribution itemInComboBox = (UntilNodeContribution)untilNodeComboBox.getItemAt(i);
            if (itemInComboBox.getUntilTypeNode().getType() == UntilTypeNode.Type.DISTANCE && isWaypoint || itemInComboBox.getUntilTypeNode().getType() == UntilTypeNode.Type.REACHED_WAYPOINT && !isWaypoint) {
                parentSwitch = true;
                break;
            }
            ++i;
        }
        Object item = untilNodeComboBox.getSelectedItem();
        boolean bl = differentUntilType = item != null && ((UntilNodeContribution)item).getUntilTypeNode().getType() != type;
        if (differentUntilType || parentSwitch) {
            untilNodeComboBox.removeAllItems();
        }
        if (untilNodeComboBox.getItemCount() == 0) {
            for (UntilNodeContribution each : this.filterContributions(untilNodeContributions)) {
                untilNodeComboBox.addItem(each);
                if (each.getUntilTypeNode().getType() != type || parentSwitch && !differentUntilType) continue;
                untilNodeComboBox.setSelectedItem(each);
            }
        }
    }

    protected JLabel createUntilLabel(ViewContext viewContext) {
        return this.makeHeader(new JLabel(String.valueOf(((TextResource)viewContext.getTextResource(TextResource.class)).Until()) + " - "));
    }

    protected JComboBox createUntilTypeComboBox() {
        final JComboBox comboBox = new JComboBox();
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UntilNode node = (UntilNode)UntilTypeCard.this.getNode();
                UntilNodeContribution untilNodeContribution = (UntilNodeContribution)comboBox.getSelectedItem();
                if (node != null && comboBox.getSelectedItem() instanceof UntilNodeContribution && !UntilTypeCard.this.entering && node.getSelectedTypeNode().getType() != untilNodeContribution.getUntilTypeNode().getType()) {
                    if (node.canBeOfType(untilNodeContribution)) {
                        node.setSelectedTypeNode(untilNodeContribution.getUntilTypeNode());
                    } else {
                        LegacyURDialogCreator.showMessageDialog(((TextResource)UntilTypeCard.this.viewContext.getTextResource(TextResource.class)).CannotAddUntilNode(untilNodeContribution.getTitle()));
                        comboBox.setSelectedItem(UntilTypeCard.this.getCurrentlySelectedItem(comboBox, node.getSelectedTypeNode().getType()));
                    }
                }
            }
        });
        comboBox.setRenderer(new DefaultComboBoxRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof UntilNodeContribution) {
                    this.setText(((UntilNodeContribution)value).getTitle());
                }
                return UntilTypeCard.this.makeHeader((JLabel)((Object)this));
            }
        });
        return comboBox;
    }

    protected JPanel initUntilPanel(JComboBox untilNodesComboBox) {
        JPanel untilPanel = this.viewContext.createFormBuilder().label(this.createUntilLabel(this.viewContext), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)untilNodesComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().getPanel();
        untilPanel.setBorder(new EmptyBorder(15, 10, 0, 10));
        return untilPanel;
    }

    private UntilNodeContribution getCurrentlySelectedItem(JComboBox comboBox, UntilTypeNode.Type type) {
        int i = 0;
        while (i < comboBox.getItemCount()) {
            if (((UntilNodeContribution)comboBox.getItemAt(i)).getUntilTypeNode().getType() == type) {
                return (UntilNodeContribution)comboBox.getItemAt(i);
            }
            ++i;
        }
        return (UntilNodeContribution)comboBox.getItemAt(0);
    }

    private JLabel makeHeader(JLabel label) {
        label.setText(HTML.html((String)HTML.h1((String)label.getText())));
        label.setFont(label.getFont().deriveFont(1, 18.0f));
        return label;
    }
}

