/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types.infrastructure;

import com.ur.i18n.TextResource;
import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Masterboard;
import com.ur.polyscope.io.tool.ToolCommInfo;
import com.ur.polyscope.pin.AnalogIOPin;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.Register;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.program.nodes.until.types.UntilTypeNode;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.CollectionUtils;
import com.ur.util.Optional;
import com.ur.util.Predicate;
import gui.program.services.ProgramReferenceService;
import gui.program.until.UntilNode;
import gui.program.until.types.AnalogPinReference;
import gui.program.until.types.UntilIONode;
import gui.program.until.types.infrastructure.UntilIONodeViewPart;
import gui.program.validation.UntilIONodeValidationStrategyProvider;
import gui.swing.renderers.PinComboBoxModel;
import gui.swing.renderers.PinRenderingStrategy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.text.Format;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AnalogInputPanel
extends JPanel
implements UntilIONodeViewPart {
    public static final int _4_TO_20mA = 0;
    private final IOService ioService;
    private final ViewContext viewContext;
    private final UntilIONodeValidationStrategyProvider validationProvider;
    private final ProgramReferenceService programReferenceService;
    private EnumButtonGroup<UntilIONode.IOType> buttonGroup;
    private UntilNode node;
    private JRadioButton selection;
    private JComboBox analogComparisonComboBox;
    private JComboBox analogSensorSelection;
    private NumberField analogValue;
    private byte[] analogRange = new byte[4];
    private boolean toolCommEnabled = false;
    private boolean updating;
    private AnalogPinReference DEFAULT_ANALOG_PIN_REFERENCE = new AnalogPinReference();

    @Inject
    public AnalogInputPanel(IOService ioService, ViewContext viewContext, UntilIONodeValidationStrategyProvider validationProvider, @Source(value=ToolCommInfo.class) Recipe<ToolCommInfo> toolCommInfoRecipe, @Source(value=Masterboard.class) Recipe<Masterboard> armRecipe, ProgramReferenceService programReferenceService) {
        this.ioService = ioService;
        this.viewContext = viewContext;
        this.validationProvider = validationProvider;
        this.programReferenceService = programReferenceService;
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        this.setLayout(new FlowLayout(0, 5, 0));
        this.selection = widgetFactory.createRadioButton((Action)((Object)new SelectionActionDefinition(viewContext)));
        this.analogSensorSelection = widgetFactory.createComboBox();
        this.analogSensorSelection.setPreferredSize(new Dimension(200, 28));
        this.analogSensorSelection.setName("analogInput.UntilIOCard");
        this.analogSensorSelection.addActionListener(evt -> {
            if (!this.updating) {
                this.analogSensorSelectionActionPerformed();
            }
        });
        ComboBoxRenderer.bindRenderer((JComboBox)this.analogSensorSelection, (RenderingStrategy)new PinRenderingStrategy());
        this.analogComparisonComboBox = widgetFactory.createComboBox();
        this.analogComparisonComboBox.setFont(viewContext.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD));
        this.analogComparisonComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{">", "<"}));
        this.analogComparisonComboBox.setPreferredSize(new Dimension(70, 28));
        this.analogComparisonComboBox.setName("analogComparision.UntilIOCard");
        this.analogComparisonComboBox.addActionListener(evt -> {
            if (!this.updating) {
                this.analogComparisonComboBoxActionPerformed();
            }
        });
        this.analogValue = viewContext.createWidgetFactory().createNumberField(e -> {
            UntilIONode untilIONode = (UntilIONode)this.node.getSelectedTypeNode();
            Optional<AnalogPinReference> analogPinReference = untilIONode.getAnalogPinReference();
            if (analogPinReference.isPresent()) {
                this.node.setSelectedTypeNode(new UntilIONode(new AnalogPinReference(((AnalogPinReference)analogPinReference.get()).getPinReference(), ((AnalogPinReference)analogPinReference.get()).getComparision(), (Double)this.analogValue.getValue())));
            }
        });
        this.analogValue.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.0##"));
        this.analogValue.setHorizontalAlignment(11);
        this.analogValue.setValue((Object)0.0);
        this.analogValue.setPreferredSize(new Dimension(120, 28));
        this.analogValue.setName("analogValue.UntilIOCard");
        toolCommInfoRecipe.distinctUntilChanged().executeOnUIThread().subscribe(toolCommInfo -> {
            this.toolCommEnabled = toolCommInfo.isEnabled();
            if (this.node != null && this.isVisible()) {
                this.enter(this.node);
            }
        });
        armRecipe.map(Masterboard::getAnalogInputRange).distinctUntilChanged().executeOnUIThread().subscribe(thisAnalogRange -> {
            this.analogRange = thisAnalogRange;
            if (this.node == null) {
                return;
            }
            UntilTypeNode type = this.node.getSelectedTypeNode();
            if (!(type instanceof UntilIONode)) {
                return;
            }
            UntilIONode untilIONode = (UntilIONode)this.node.getSelectedTypeNode();
            Optional<AnalogPinReference> analogPinReference = untilIONode.getAnalogPinReference();
            if (analogPinReference.isPresent()) {
                this.analogValue.setUnit(this.getUnitLabel());
                this.analogValue.setErrorValidationStrategy(new ValidationStrategy[]{this.getValueValidationStrategy(analogPinReference.isPresent() && ((AnalogPinReference)analogPinReference.get()).getPinReference().isPresent() ? ((PinReference)((AnalogPinReference)analogPinReference.get()).getPinReference().get()).dereference() : null)});
            }
        });
        this.add(this.selection);
        this.add(this.analogSensorSelection);
        this.add(this.analogComparisonComboBox);
        this.add((Component)this.analogValue);
    }

    private static void initPinReferenceSelection(Optional<PinReference> pinReference, PinComboBoxModel comboBoxModel) {
        if (pinReference.isPresent()) {
            comboBoxModel.selectPinReference((PinReference)pinReference.get());
        } else {
            comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(0));
        }
    }

    @Override
    public void enter(UntilNode node) {
        this.updating = true;
        this.node = node;
        PinComboBoxModel analogInputModel = new PinComboBoxModel();
        analogInputModel.addElement(((TextResource)this.viewContext.getTextResource(TextResource.class)).tokenAnalogInputAbbrev());
        analogInputModel.addAllElements(CollectionUtils.filter((Object[])this.ioService.getAllAnalogInputPins(), (Predicate)this.ioService.getToolCommEnabledPredicate(this.toolCommEnabled)));
        analogInputModel.addAllElements(this.ioService.getCustomAnalogInputPins());
        analogInputModel.addAllElements(CollectionUtils.filter((Object[])this.ioService.getGeneralPurposeFloatInputRegisters(), (Predicate)new IOService.WithUserDefinedName()));
        this.analogSensorSelection.setModel(analogInputModel);
        AnalogPinReference analogPinReference = this.getAnalogPinReference();
        AnalogInputPanel.initPinReferenceSelection(analogPinReference.getPinReference(), analogInputModel);
        this.analogComparisonComboBox.setSelectedIndex(analogPinReference.getComparision() == AnalogPinReference.Comparision.GREATER_THAN ? 0 : 1);
        this.analogComparisonComboBox.setEnabled(analogPinReference.getPinReference().isPresent());
        Object pin = this.analogSensorSelection.getSelectedItem();
        this.analogValue.setErrorValidationStrategy(new ValidationStrategy[]{this.getValueValidationStrategy(pin)});
        this.analogValue.setMode(pin instanceof Register ? Mode.Standard : Mode.PositiveNumbers);
        this.analogValue.setValue((Object)analogPinReference.getValue());
        this.analogValue.setEnabled(analogPinReference.getPinReference().isPresent());
        this.analogValue.setUnit(this.getUnitLabel());
        this.updating = false;
    }

    private AnalogPinReference getAnalogPinReference() {
        UntilIONode untilIONode = (UntilIONode)this.node.getSelectedTypeNode();
        Optional<AnalogPinReference> analogPinReference = untilIONode.getAnalogPinReference();
        AnalogPinReference reference = analogPinReference.isPresent() ? (AnalogPinReference)analogPinReference.get() : this.DEFAULT_ANALOG_PIN_REFERENCE;
        return reference;
    }

    @Override
    public void exit() {
        this.node = null;
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void setButtonGroup(EnumButtonGroup<UntilIONode.IOType> buttonGroup) {
        this.buttonGroup = buttonGroup;
        this.buttonGroup.add((Enum)UntilIONode.IOType.ANALOG_INPUT, (AbstractButton)this.selection);
    }

    private String getUnitLabel() {
        UntilIONode untilIONode = (UntilIONode)this.node.getSelectedTypeNode();
        Optional<AnalogPinReference> analogPinReference = untilIONode.getAnalogPinReference();
        if (analogPinReference.isPresent() && ((AnalogPinReference)analogPinReference.get()).getPinReference().isPresent()) {
            if (((PinReference)((AnalogPinReference)analogPinReference.get()).getPinReference().get()).dereference() instanceof Register) {
                return "";
            }
            if (((PinReference)((AnalogPinReference)analogPinReference.get()).getPinReference().get()).dereference() instanceof AnalogIOPin) {
                AnalogIOPin analogIOPin = (AnalogIOPin)((PinReference)((AnalogPinReference)analogPinReference.get()).getPinReference().get()).dereference();
                if (this.analogRange[analogIOPin.getPin()] == 0) {
                    return Units.getText().unitMa();
                }
                return Units.getText().unitVolts();
            }
        }
        return Units.getText().unitMa();
    }

    private void analogComparisonComboBoxActionPerformed() {
        int analogComparison = this.analogComparisonComboBox.getSelectedIndex();
        AnalogPinReference.Comparision comparision = analogComparison == 0 ? AnalogPinReference.Comparision.GREATER_THAN : AnalogPinReference.Comparision.LESS_THAN;
        UntilIONode untilIONode = (UntilIONode)this.node.getSelectedTypeNode();
        Optional<AnalogPinReference> analogPinReference = untilIONode.getAnalogPinReference();
        if (analogPinReference.isPresent() && ((AnalogPinReference)analogPinReference.get()).getPinReference().isPresent() && comparision != ((AnalogPinReference)analogPinReference.get()).getComparision()) {
            this.node.setSelectedTypeNode(new UntilIONode(new AnalogPinReference(((AnalogPinReference)analogPinReference.get()).getPinReference(), comparision, ((AnalogPinReference)analogPinReference.get()).getValue())));
        }
    }

    private void analogSensorSelectionActionPerformed() {
        Object selectedAnalogSensor = this.analogSensorSelection.getSelectedItem();
        AnalogPinReference analogPinReference = this.getAnalogPinReference();
        if (selectedAnalogSensor instanceof Pin) {
            PinReference reference = this.programReferenceService.getPinReference((Pin)selectedAnalogSensor);
            if (!analogPinReference.getPinReference().isPresent() || !((PinReference)analogPinReference.getPinReference().get()).equals((Object)reference)) {
                this.node.setSelectedTypeNode(new UntilIONode(new AnalogPinReference((Optional<PinReference>)Optional.of((Object)reference), analogPinReference.getComparision(), analogPinReference.getValue())));
                this.buttonGroup.select((Enum)UntilIONode.IOType.ANALOG_INPUT);
            }
        } else if (analogPinReference.getPinReference().isPresent()) {
            this.node.setSelectedTypeNode(new UntilIONode(new AnalogPinReference((Optional<PinReference>)Optional.empty(), analogPinReference.getComparision(), analogPinReference.getValue())));
        }
    }

    private ValidationStrategy getValueValidationStrategy(Object selectedAnalogSensor) {
        if (selectedAnalogSensor instanceof AnalogIOPin) {
            return AnalogPinReference.getAnalogInputRange((AnalogIOPin)selectedAnalogSensor) == 0 ? this.validationProvider.getElectricalCurrentValidator() : this.validationProvider.getElectricalPotentialValidator();
        }
        return this.validationProvider.getNumberValidator();
    }

    private class SelectionActionDefinition
    extends AbstractActionDefinition {
        public SelectionActionDefinition(ViewContext viewContext) {
            this.putValue("Name", ((TextResource)viewContext.getTextResource(TextResource.class)).untilIOAnalogInput());
            this.putValue("InternalName", "untilAnalogInput.UntilIOCard");
        }

        public void actionPerformed(ActionEvent evt) {
            UntilIONode untilIONode = (UntilIONode)AnalogInputPanel.this.node.getSelectedTypeNode();
            Optional<AnalogPinReference> analogPinReference = untilIONode.getAnalogPinReference();
            if (!AnalogInputPanel.this.updating && AnalogInputPanel.this.selection.isSelected() && !analogPinReference.isPresent()) {
                AnalogInputPanel.this.node.setSelectedTypeNode(new UntilIONode(AnalogInputPanel.this.DEFAULT_ANALOG_PIN_REFERENCE));
            }
        }
    }
}

