/*
 * Decompiled with CFR 0.152.
 */
package gui.program.until.types.infrastructure;

import com.ur.i18n.TextResource;
import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.Register;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.IOServiceType;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.swing.ComboBox;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.util.CollectionUtils;
import com.ur.util.Conjunction;
import com.ur.util.Disjunction;
import com.ur.util.Optional;
import com.ur.util.Predicate;
import gui.program.services.ProgramReferenceService;
import gui.program.until.UntilNode;
import gui.program.until.types.DigitalPinReference;
import gui.program.until.types.UntilIONode;
import gui.program.until.types.infrastructure.UntilIONodeViewPart;
import gui.swing.renderers.PinComboBoxModel;
import gui.swing.renderers.PinRenderingStrategy;
import gui.tools.BoundsPopupMenuListener;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DigitalInputPanel
extends JPanel
implements UntilIONodeViewPart {
    private static final int MAXIMUM_ROW_COUNT = 9;
    private final IOService ioService;
    private final ViewContext viewContext;
    private final InstallationComponentLookup robotInstallationLookupService;
    private final ProgramReferenceService programReferenceService;
    private TextResource textResource;
    private JRadioButton selection;
    private JComboBox digitalSensors;
    private JComboBox valueOfSensor;
    private UntilNode node;
    private EnumButtonGroup<UntilIONode.IOType> buttonGroup;
    private PinComboBoxModel digitalInputModel;
    private boolean updating;
    private final DigitalPinReference DEFAULT_DIGITAL_PIN_REFERENCE = new DigitalPinReference();

    @Inject
    public DigitalInputPanel(IOService ioService, ViewContext viewContext, InstallationComponentLookup robotInstallationLookupService, ProgramReferenceService programReferenceService) {
        this.ioService = ioService;
        this.viewContext = viewContext;
        this.robotInstallationLookupService = robotInstallationLookupService;
        this.programReferenceService = programReferenceService;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.setLayout(new FlowLayout(0, 5, 0));
        this.selection = new JRadioButton();
        this.selection.setName("untilDigitalInput.UntilIOCard");
        this.selection.setText(((TextResource)viewContext.getTextResource(TextResource.class)).untilIODigitalInput());
        this.selection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (!DigitalInputPanel.this.updating) {
                    UntilIONode untilIONode = (UntilIONode)DigitalInputPanel.this.node.getSelectedTypeNode();
                    if (evt.getStateChange() == 1 && !untilIONode.getDigitalPinReference().isPresent()) {
                        DigitalInputPanel.this.node.setSelectedTypeNode(new UntilIONode(DigitalInputPanel.this.DEFAULT_DIGITAL_PIN_REFERENCE));
                    }
                }
            }
        });
        this.digitalSensors = new ComboBox();
        this.digitalSensors.setName("digitalInput.UntilIOCard");
        this.digitalSensors.setPreferredSize(new Dimension(200, 28));
        this.digitalSensors.setPrototypeDisplayValue("XXXXXXXXX");
        this.digitalSensors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!DigitalInputPanel.this.updating) {
                    DigitalInputPanel.this.digitalSensorSelectionActionPerformed();
                }
            }
        });
        PinRenderingStrategy pinRenderingStrategy = new PinRenderingStrategy();
        ComboBoxRenderer.bindRenderer((JComboBox)this.digitalSensors, (RenderingStrategy)pinRenderingStrategy);
        this.valueOfSensor = new JComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(this.textResource.tokenDigitalLo());
        model.addElement(this.textResource.tokenDigitalHi());
        this.valueOfSensor.setModel(model);
        this.valueOfSensor.setName("digitalValue.UntilIOCard");
        this.valueOfSensor.setPreferredSize(new Dimension(100, 28));
        this.valueOfSensor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!DigitalInputPanel.this.updating) {
                    DigitalInputPanel.this.digitalValueComboBoxActionPerformed();
                }
            }
        });
        this.add(this.selection);
        this.add(this.digitalSensors);
        this.add(this.valueOfSensor);
    }

    @Override
    public void enter(UntilNode node) {
        this.updating = true;
        this.node = node;
        this.digitalInputModel = new PinComboBoxModel();
        this.digitalInputModel.addElement(((TextResource)this.viewContext.getTextResource(TextResource.class)).tokenDigitalInputAbbrev());
        Disjunction disjunction = new Disjunction();
        disjunction.addFilter((Predicate)new IOService.UnassignedOfType(IOServiceType.DIGITAL));
        disjunction.addFilter((Predicate)new Conjunction(new Predicate[]{new IOService.UnassignedOfType(IOServiceType.BOOLEAN), new Predicate.ByType(Register.class), new IOService.WithUserDefinedName()}));
        this.digitalInputModel.addAllElements(CollectionUtils.filter((Iterable)this.ioService.getAllInputs(), (Predicate)disjunction));
        this.digitalSensors.setModel(this.digitalInputModel);
        UntilIONode untilIONode = (UntilIONode)node.getSelectedTypeNode();
        this.init(untilIONode.getDigitalPinReference().isPresent() ? (DigitalPinReference)untilIONode.getDigitalPinReference().get() : this.DEFAULT_DIGITAL_PIN_REFERENCE);
        boolean immiEnabled = ((Immi)this.robotInstallationLookupService.getComponent(Immi.class)).isEnabled();
        BoundsPopupMenuListener.enableOnComboBox(this.digitalSensors, immiEnabled);
        if (immiEnabled) {
            this.digitalSensors.setMaximumRowCount(9);
        }
        this.updating = false;
    }

    public void init(DigitalPinReference digitalPinReference) {
        DigitalInputPanel.initPinReferenceSelection(digitalPinReference.getPinReference(), this.digitalInputModel);
        this.valueOfSensor.setSelectedIndex(digitalPinReference.getValue() ? 1 : 0);
        this.valueOfSensor.setEnabled(digitalPinReference.getPinReference().isPresent());
    }

    @Override
    public void exit() {
        this.node = null;
    }

    @Override
    public void setButtonGroup(EnumButtonGroup<UntilIONode.IOType> buttonGroup) {
        this.buttonGroup = buttonGroup;
        buttonGroup.add((Enum)UntilIONode.IOType.DIGITAL_INPUT, (AbstractButton)this.selection);
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    private static void initPinReferenceSelection(Optional<PinReference> pinReference, PinComboBoxModel comboBoxModel) {
        if (pinReference.isPresent()) {
            comboBoxModel.selectPinReference((PinReference)pinReference.get());
        } else {
            comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(0));
        }
    }

    private void digitalValueComboBoxActionPerformed() {
        boolean digitalValue = this.valueOfSensor.getSelectedIndex() != 0;
        UntilIONode untilIONode = (UntilIONode)this.node.getSelectedTypeNode();
        if (untilIONode.getDigitalPinReference().isPresent() && digitalValue != ((DigitalPinReference)untilIONode.getDigitalPinReference().get()).getValue()) {
            this.node.setSelectedTypeNode(new UntilIONode(new DigitalPinReference(((DigitalPinReference)untilIONode.getDigitalPinReference().get()).getPinReference(), digitalValue)));
        }
    }

    private void digitalSensorSelectionActionPerformed() {
        Object selectedDigitalSensor = this.digitalSensors.getSelectedItem();
        UntilIONode untilIONode = (UntilIONode)this.node.getSelectedTypeNode();
        if (selectedDigitalSensor instanceof Pin) {
            PinReference reference = this.programReferenceService.getPinReference((Pin)selectedDigitalSensor);
            if (!(untilIONode.getDigitalPinReference().isPresent() && ((DigitalPinReference)untilIONode.getDigitalPinReference().get()).getPinReference().isPresent() && ((PinReference)((DigitalPinReference)untilIONode.getDigitalPinReference().get()).getPinReference().get()).equals((Object)reference))) {
                this.node.setSelectedTypeNode(untilIONode.getDigitalPinReference().isPresent() ? new UntilIONode(new DigitalPinReference((Optional<PinReference>)Optional.of((Object)reference), ((DigitalPinReference)untilIONode.getDigitalPinReference().get()).getValue())) : new UntilIONode(new DigitalPinReference((Optional<PinReference>)Optional.of((Object)reference))));
                this.buttonGroup.select((Enum)UntilIONode.IOType.DIGITAL_INPUT);
            }
        } else if (untilIONode.getDigitalPinReference().isPresent() && ((DigitalPinReference)untilIONode.getDigitalPinReference().get()).getPinReference().isPresent()) {
            this.node.setSelectedTypeNode(new UntilIONode(new DigitalPinReference((Optional<PinReference>)Optional.empty(), ((DigitalPinReference)untilIONode.getDigitalPinReference().get()).getValue())));
        }
    }
}

