/*
 * Decompiled with CFR 0.152.
 */
package gui.program.validation.impl;

import com.ur.i18n.TextResource;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Angle;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.swing.validation.AutoCorrectionRangeDecorator;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationFactory;
import gui.program.validation.AccelerationValidationStrategyProvider;
import gui.program.validation.ErrorMessageBuilder;
import javax.inject.Inject;

public class AccelerationValidationStrategyProviderImpl
implements AccelerationValidationStrategyProvider {
    private static final double TOOL_MAX_ACCEL = 150.0;
    private final JointConfigurationSettings configurationSettings;
    private final TextResource textResource;

    @Inject
    public AccelerationValidationStrategyProviderImpl(TextResource textResource, JointConfigurationSettings configurationSettings) {
        this.textResource = textResource;
        this.configurationSettings = configurationSettings;
    }

    @Override
    public AutoCorrectionValidator getJointAccelerationLimitValidator() {
        double jointAccelerationLimit = this.getJointAccelerationLimit();
        String angularAccelerationUnit = UnitsValueConverterFactory.getAngularAccelerationConverter().getUnit();
        String accelerationErrorMessage = this.textResource.valueOutOfRange(0.0, angularAccelerationUnit, jointAccelerationLimit);
        return this.getAutoCorrectionRangeValidator(0.0, jointAccelerationLimit, accelerationErrorMessage);
    }

    @Override
    public AutoCorrectionValidator getJointAccelerationLimitValidatorEnglishInDegS2() {
        double jointAccelerationLimit = this.getJointAccelerationLimit();
        String name = "Joint acceleration";
        String accelerationErrorMessage = new ErrorMessageBuilder().setName(name).setLowerLimit("0.0").setUpperLimit(Double.toString(jointAccelerationLimit)).setUnit("\u00b0/s\u00b2").build();
        String notANumberMessage = new ErrorMessageBuilder().setName(name).build();
        return this.getAutoCorrectionRangeValidatorEnglish(0.0, jointAccelerationLimit, accelerationErrorMessage, notANumberMessage);
    }

    private double getJointAccelerationLimit() {
        Angle valueInAngle = Angle.from((double)URMath.getMaxValue((double[])this.configurationSettings.getJointMaxAcceleration()), (Angle.Unit)Angle.Unit.RADIANS);
        double valueInDeg = Double.parseDouble((String)UnitsValueConverterFactory.getAngleConverter().fromModel((Object)valueInAngle));
        return URMath.roundUpDouble((double)valueInDeg, (int)0);
    }

    @Override
    public AutoCorrectionValidator getCartesianJointAccelerationLimitValidator() {
        double accelerationLimit = Math.ceil(this.getToolAccelerationLimit());
        String speedErrorMessage = this.textResource.valueOutOfRange(0.0, UnitsValueConverterFactory.getAccelerationConverter().getUnit(), accelerationLimit);
        return this.getAutoCorrectionRangeValidator(0.0, accelerationLimit, speedErrorMessage);
    }

    @Override
    public AutoCorrectionValidator getCartesianJointAccelerationLimitValidatorEnglishInMeterS2() {
        double accelerationMin = 0.0;
        double accelerationMax = Math.ceil(150.0);
        String name = "Joint acceleration";
        String speedErrorMessage = new ErrorMessageBuilder().setName(name).setLowerLimit("0.0").setUpperLimit(Double.toString(accelerationMax)).setUnit("m/s\u00b2").build();
        String notANumberMessage = new ErrorMessageBuilder().setName(name).build();
        return this.getAutoCorrectionRangeValidatorEnglish(accelerationMin, accelerationMax, speedErrorMessage, notANumberMessage);
    }

    private AutoCorrectionValidator getAutoCorrectionRangeValidator(double min, double max, String errorMessage) {
        return new AutoCorrectionRangeDecorator(ValidationFactory.getRangeValidator((double)min, (double)max, (String)errorMessage), min, max);
    }

    private AutoCorrectionValidator getAutoCorrectionRangeValidatorEnglish(double min, double max, String errorMessage, String notANumberMessage) {
        return new AutoCorrectionRangeDecorator(ValidationFactory.getRangeValidator((double)min, (double)max, (boolean)false, (String)errorMessage, (String)notANumberMessage), min, max);
    }

    private double getToolAccelerationLimit() {
        Acceleration accelerationValue = Acceleration.from((double)150.0, (Acceleration.Unit)Acceleration.Unit.SI);
        return Double.parseDouble((String)UnitsValueConverterFactory.getAccelerationConverter().fromModel((Object)accelerationValue));
    }
}

