/*
 * Decompiled with CFR 0.152.
 */
package gui.program.validation.impl;

import com.ur.i18n.TextResource;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotTool;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.polyscope.viewfacade.safety.SafetyLimitsProvider;
import com.ur.swing.units.Units;
import com.ur.swing.validation.AutoCorrectionRangeDecorator;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationFactory;
import gui.program.validation.ErrorMessageBuilder;
import gui.program.validation.ForceNodeValidationStrategyProvider;
import javax.inject.Inject;

public class ForceNodeValidationStrategyProviderImpl
implements ForceNodeValidationStrategyProvider {
    private final SafetyLimitsProvider maxForceProvider;
    private final RobotTool robotTool;
    private final TextResource textResource;

    @Inject
    public ForceNodeValidationStrategyProviderImpl(TextResource textResource, SafetyLimitsProvider maxForceProvider, RobotConfigurationProvider robot) {
        this.textResource = textResource;
        this.maxForceProvider = maxForceProvider;
        this.robotTool = robot.getRobotTool();
    }

    @Override
    public AutoCorrectionValidator getForceValidator() {
        double maxForce = this.maxForceProvider.getMaxToolForce();
        double maxAllowed = Units.getNewtonsConverter().convertFrom(maxForce);
        double minAllowed = Units.getNewtonsConverter().convertFrom(-maxForce);
        String errorMessage = this.textResource.valueOutOfRange(minAllowed, Units.getText().unitN(), maxAllowed);
        return this.getAutoCorrectionRangeValidator(minAllowed, maxAllowed, errorMessage);
    }

    @Override
    public AutoCorrectionValidator getTorqueValidator() {
        double minAllowed = Units.getTorqueConverter().convertFrom(-50.0);
        double maxAllowed = Units.getTorqueConverter().convertFrom(50.0);
        String errorMessage = this.textResource.valueOutOfRange(minAllowed, Units.getText().unitNm(), maxAllowed);
        return this.getAutoCorrectionRangeValidator(minAllowed, maxAllowed, errorMessage);
    }

    @Override
    public AutoCorrectionValidator getLimitValidator() {
        double minAllowedConverted = URMath.roundDouble((double)Units.getMmConverter().convertFrom(0.0), (int)2);
        double maxAllowedConverted = URMath.roundDouble((double)Units.getMmConverter().convertFrom(500.0), (int)2);
        String errorMessage = this.textResource.valueOutOfRange(minAllowedConverted, Units.getText().unitMm(), maxAllowedConverted);
        return this.getAutoCorrectionRangeValidator(minAllowedConverted, maxAllowedConverted, errorMessage);
    }

    @Override
    public AutoCorrectionValidator getLimitSpeedValidator() {
        double minAllowedConverted = URMath.roundDouble((double)Units.getMmSConverter().convertFrom(0.0), (int)2);
        double maxAllowedConverted = URMath.roundDouble((double)Units.getMmSConverter().convertFrom(500.0), (int)2);
        String errorMessage = this.textResource.valueOutOfRange(minAllowedConverted, Units.getText().unitMmS(), maxAllowedConverted);
        return this.getAutoCorrectionRangeValidator(minAllowedConverted, maxAllowedConverted, errorMessage);
    }

    @Override
    public AutoCorrectionValidator getForceValidatorEnglishInN() {
        double maxForce;
        double maxAllowed = maxForce = this.maxForceProvider.getMaxToolForce();
        double minAllowed = -maxForce;
        String name = "Force";
        String errorMessage = new ErrorMessageBuilder().setName(name).setLowerLimit(Double.toString(minAllowed)).setUpperLimit(Double.toString(maxAllowed)).setUnit("N").build();
        String notANumberMessage = new ErrorMessageBuilder().setName(name).build();
        return this.getAutoCorrectionRangeValidatorEnglish(minAllowed, maxAllowed, errorMessage, notANumberMessage);
    }

    @Override
    public AutoCorrectionValidator getTorqueValidatorEnglishInNm() {
        double minAllowed = -50.0;
        double maxAllowed = 50.0;
        String name = "Torque";
        String errorMessage = new ErrorMessageBuilder().setName(name).setLowerLimit(Double.toString(minAllowed)).setUpperLimit(Double.toString(maxAllowed)).setUnit("Nm").build();
        String notANumberMessage = new ErrorMessageBuilder().setName(name).build();
        return this.getAutoCorrectionRangeValidatorEnglish(minAllowed, maxAllowed, errorMessage, notANumberMessage);
    }

    @Override
    public AutoCorrectionValidator getLimitValidatorEnglishInMm() {
        double minAllowed = 0.0;
        double maxAllowed = 500.0;
        String name = "Limit";
        String errorMessage = new ErrorMessageBuilder().setName(name).setLowerLimit(Double.toString(minAllowed)).setUpperLimit(Double.toString(maxAllowed)).setUnit("mm").build();
        String notANumberMessage = new ErrorMessageBuilder().setName(name).build();
        return this.getAutoCorrectionRangeValidatorEnglish(minAllowed, maxAllowed, errorMessage, notANumberMessage);
    }

    @Override
    public AutoCorrectionValidator getLimitSpeedValidatorEnglishInMmS() {
        double minAllowed = 0.0;
        double maxAllowed = 500.0;
        String name = "SpeedLimit";
        String errorMessage = new ErrorMessageBuilder().setName(name).setLowerLimit(Double.toString(minAllowed)).setUpperLimit(Double.toString(maxAllowed)).setUnit("mm/s").build();
        String notANumberMessage = new ErrorMessageBuilder().setName(name).build();
        return this.getAutoCorrectionRangeValidatorEnglish(minAllowed, maxAllowed, errorMessage, notANumberMessage);
    }

    @Override
    public AutoCorrectionValidator getRotationValidator() {
        double minAllowed = 0.0;
        double maxAllowed = this.getMaxAngle();
        String errorMessage = this.textResource.valueOutOfRange(minAllowed, Units.getText().unitDegrees(), maxAllowed);
        return this.getAutoCorrectionRangeValidator(minAllowed, maxAllowed, errorMessage);
    }

    @Override
    public AutoCorrectionValidator getRotationSpeedValidator() {
        double minAllowed = 0.0;
        double maxAllowed = this.getMaxAngle();
        String errorMessage = this.textResource.valueOutOfRange(minAllowed, Units.getText().unitDegS(), maxAllowed);
        return this.getAutoCorrectionRangeValidator(minAllowed, maxAllowed, errorMessage);
    }

    @Override
    public AutoCorrectionValidator getRotationValidatorEnglishInDeg() {
        String name = "Rotation";
        double minAllowed = 0.0;
        double maxAllowed = this.getMaxAngle();
        String errorMessage = new ErrorMessageBuilder().setName(name).setLowerLimit(Double.toString(minAllowed)).setUpperLimit(Double.toString(maxAllowed)).setUnit("\u00b0").build();
        String notANumberMessage = new ErrorMessageBuilder().setName(name).build();
        return this.getAutoCorrectionRangeValidatorEnglish(minAllowed, maxAllowed, errorMessage, notANumberMessage);
    }

    @Override
    public AutoCorrectionValidator getRotationSpeedValidatorEnglishInDegS() {
        String name = "RotationSpeed";
        double minAllowed = 0.0;
        double maxAllowed = this.getMaxAngle();
        String errorMessage = new ErrorMessageBuilder().setName(name).setLowerLimit(Double.toString(minAllowed)).setUpperLimit(Double.toString(maxAllowed)).setUnit("\u00b0/s").build();
        String notANumberMessage = new ErrorMessageBuilder().setName(name).build();
        return this.getAutoCorrectionRangeValidatorEnglish(minAllowed, maxAllowed, errorMessage, notANumberMessage);
    }

    private double getMaxAngle() {
        return this.robotTool.getMaxAngle();
    }

    private AutoCorrectionValidator getAutoCorrectionRangeValidator(double min, double max, String errorMessage) {
        return new AutoCorrectionRangeDecorator(ValidationFactory.getRangeValidator((double)min, (double)max, (String)errorMessage), min, max);
    }

    private AutoCorrectionValidator getAutoCorrectionRangeValidatorEnglish(double min, double max, String errorMessage, String notANumberMessage) {
        return new AutoCorrectionRangeDecorator(ValidationFactory.getRangeValidator((double)min, (double)max, (boolean)false, (String)errorMessage, (String)notANumberMessage), min, max);
    }
}

