/*
 * Decompiled with CFR 0.152.
 */
package gui.program.validation.impl;

import com.ur.i18n.TextResource;
import com.ur.swing.units.Units;
import com.ur.swing.validation.AutoCorrectionRangeDecorator;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationFactory;
import gui.program.validation.AccelerationValidationStrategyProvider;
import gui.program.validation.ErrorMessageBuilder;
import gui.program.validation.MoveNodeValidationStrategyProvider;
import gui.program.validation.SpeedValidationStrategyProvider;
import javax.inject.Inject;

public class MoveNodeValidationStrategyProviderImpl
implements MoveNodeValidationStrategyProvider {
    private static final double BLEND_RADIUS_LOWER_LIMIT = 0.001;
    private static final double BLEND_RADIUS_UPPER_LIMIT = 1.0;
    private SpeedValidationStrategyProvider speedValidationStrategyProvider;
    private AccelerationValidationStrategyProvider accelerationValidationStrategyProvider;
    private TextResource textResource;

    @Inject
    public MoveNodeValidationStrategyProviderImpl(SpeedValidationStrategyProvider speedValidationStrategyProvider, AccelerationValidationStrategyProvider accelerationValidationStrategyProvider, TextResource textResource) {
        this.speedValidationStrategyProvider = speedValidationStrategyProvider;
        this.accelerationValidationStrategyProvider = accelerationValidationStrategyProvider;
        this.textResource = textResource;
    }

    @Override
    public AutoCorrectionValidator getCartesianJointSpeedLimitValidator() {
        return this.speedValidationStrategyProvider.getCartesianJointSpeedLimitValidator();
    }

    @Override
    public AutoCorrectionValidator getCartesianJointSpeedLimitValidatorEnglishMeterS() {
        return this.speedValidationStrategyProvider.getCartesianJointSpeedLimitValidatorEnglishMeterS();
    }

    @Override
    public AutoCorrectionValidator getJointSpeedLimitValidator() {
        return this.speedValidationStrategyProvider.getJointSpeedLimitValidator();
    }

    @Override
    public AutoCorrectionValidator getJointSpeedLimitValidatorEnglishDegS() {
        return this.speedValidationStrategyProvider.getJointSpeedLimitValidatorEnglishDegS();
    }

    @Override
    public AutoCorrectionValidator getCartesianJointAccelerationLimitValidator() {
        return this.accelerationValidationStrategyProvider.getCartesianJointAccelerationLimitValidator();
    }

    @Override
    public AutoCorrectionValidator getCartesianJointAccelerationLimitValidatorEnglishInMeterS2() {
        return this.accelerationValidationStrategyProvider.getCartesianJointAccelerationLimitValidatorEnglishInMeterS2();
    }

    @Override
    public AutoCorrectionValidator getJointAccelerationLimitValidator() {
        return this.accelerationValidationStrategyProvider.getJointAccelerationLimitValidator();
    }

    @Override
    public AutoCorrectionValidator getJointAccelerationLimitValidatorEnglishInDegS2() {
        return this.accelerationValidationStrategyProvider.getJointAccelerationLimitValidatorEnglishInDegS2();
    }

    @Override
    public AutoCorrectionValidator getBlendRadiusValidator() {
        return this.getAutoCorrectionRangeValidator(this.getBlendRadiusLowerLimit(), this.getBlendRadiusUpperLimit(), this.textResource.errorBlendRange(this.getBlendRadiusLowerLimit(), this.getBlendRadiusUpperLimit(), Units.getText().unitMm()));
    }

    @Override
    public AutoCorrectionValidator getBlendRadiusValidatorEnglishInM() {
        String name = "BlendRadius";
        return this.getAutoCorrectionRangeValidatorEnglish(0.001, 1.0, new ErrorMessageBuilder().setLowerLimit(Double.toString(0.001)).setUpperLimit(Double.toString(1.0)).setName(name).setUnit("m").build(), new ErrorMessageBuilder().setName(name).build());
    }

    private AutoCorrectionValidator getAutoCorrectionRangeValidator(double min, double max, String errorMessage) {
        return new AutoCorrectionRangeDecorator(ValidationFactory.getRangeValidator((double)min, (double)max, (String)errorMessage), min, max);
    }

    private AutoCorrectionValidator getAutoCorrectionRangeValidatorEnglish(double min, double max, String errorMessage, String notANumberMessage) {
        return new AutoCorrectionRangeDecorator(ValidationFactory.getRangeValidator((double)min, (double)max, (boolean)false, (String)errorMessage, (String)notANumberMessage), min, max);
    }

    private double getBlendRadiusUpperLimit() {
        return Units.getMetersConverter().convertFrom(1.0);
    }

    private double getBlendRadiusLowerLimit() {
        return Units.getMetersConverter().convertFrom(0.001);
    }
}

