/*
 * Decompiled with CFR 0.152.
 */
package gui.program.validation.impl;

import com.ur.polyscope.program.nodes.move.MoveNodeValidators;
import com.ur.polyscope.valueobjects.validation.Validator;
import gui.program.validation.MoveNodeValidationStrategyProvider;
import gui.program.validation.impl.AbstractNodeValidators;
import javax.inject.Inject;

public class MoveNodeValidatorsImpl
extends AbstractNodeValidators
implements MoveNodeValidators {
    private final Validator<Double> blendRadiusValidator;
    private final Validator<Double> jointSpeedLimitValidator;
    private final Validator<Double> cartesianJointSpeedLimitValidator;
    private final Validator<Double> cartesianJointAccelerationLimitValidator;
    private final MoveNodeValidationStrategyProvider validationStrategyProvider;

    @Inject
    public MoveNodeValidatorsImpl(MoveNodeValidationStrategyProvider vsp) {
        this.blendRadiusValidator = MoveNodeValidatorsImpl.wrap(vsp.getBlendRadiusValidatorEnglishInM());
        this.jointSpeedLimitValidator = MoveNodeValidatorsImpl.wrap(vsp.getJointSpeedLimitValidatorEnglishDegS());
        this.cartesianJointSpeedLimitValidator = MoveNodeValidatorsImpl.wrap(vsp.getCartesianJointSpeedLimitValidatorEnglishMeterS());
        this.cartesianJointAccelerationLimitValidator = MoveNodeValidatorsImpl.wrap(vsp.getCartesianJointAccelerationLimitValidatorEnglishInMeterS2());
        this.validationStrategyProvider = vsp;
    }

    public Validator<Double> getBlendRadiusValidator() {
        return this.blendRadiusValidator;
    }

    public Validator<Double> getJointSpeedLimitValidator() {
        return this.jointSpeedLimitValidator;
    }

    public Validator<Double> getJointAccelerationLimitValidator() {
        return MoveNodeValidatorsImpl.wrap(this.validationStrategyProvider.getJointAccelerationLimitValidatorEnglishInDegS2());
    }

    public Validator<Double> getCartesianJointSpeedLimitValidator() {
        return this.cartesianJointSpeedLimitValidator;
    }

    public Validator<Double> getCartesianJointAccelerationLimitValidator() {
        return this.cartesianJointAccelerationLimitValidator;
    }
}

