/*
 * Decompiled with CFR 0.152.
 */
package gui.program.validation.impl;

import com.ur.polyscope.payload.common.PayloadValidationRules;
import com.ur.polyscope.program.nodes.setpayload.PayloadNodeValidators;
import com.ur.polyscope.valueobjects.validation.Validator;
import com.ur.swing.validation.AutoCorrectionRangeDecorator;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import gui.program.validation.impl.AbstractNodeValidators;
import javax.inject.Inject;

public class PayloadNodeValidatorsImpl
extends AbstractNodeValidators
implements PayloadNodeValidators {
    private final AutoCorrectionValidator transitionTimeValidator;

    @Inject
    public PayloadNodeValidatorsImpl(PayloadValidationRules payloadValidationRules) {
        this.transitionTimeValidator = this.initTransitionTimeValidator(payloadValidationRules);
    }

    private AutoCorrectionValidator initTransitionTimeValidator(PayloadValidationRules payloadValidationRules) {
        String outOfBoundsErrorMessage = payloadValidationRules.getTransitionTimeOutOfRangeExceptionMessage();
        double minTimeValueInSecs = payloadValidationRules.getTransitionTimeMinValue();
        double maxTimeValueInSecs = payloadValidationRules.getTransitionTimeMaxValue();
        ValidationStrategy validationStrategy = ValidationFactory.getRangeValidator((double)minTimeValueInSecs, (double)maxTimeValueInSecs, (String)outOfBoundsErrorMessage);
        return new AutoCorrectionRangeDecorator(validationStrategy, minTimeValueInSecs, maxTimeValueInSecs);
    }

    public Validator<Double> getTransitionTimeValidator() {
        return PayloadNodeValidatorsImpl.wrap(this.transitionTimeValidator);
    }
}

