/*
 * Decompiled with CFR 0.152.
 */
package gui.program.validation.impl;

import com.ur.swing.validation.AutoCorrectionRangeDecorator;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.io.externalapi.MinimumPulseTimeValidator;
import gui.program.validation.ErrorMessageBuilder;
import gui.program.validation.SetNodeValidationStrategyProvider;
import gui.tools.LanguagePack;
import javax.inject.Inject;

public class SetNodeValidationStrategyProviderImpl
implements SetNodeValidationStrategyProvider {
    private static final ValidationStrategy MILLI_AMP_RANGE_VALIDATOR = ValidationFactory.getRangeValidator((double)4.0, (double)20.0, (String)LanguagePack.getTextResource().errorAnalogOutputRangeAmps());
    private static final AutoCorrectionValidator ELECTRICAL_CURRENT_VALIDATOR = new AutoCorrectionRangeDecorator(MILLI_AMP_RANGE_VALIDATOR, 4.0, 20.0);
    private static final String ELECTRICAL_CURRENT_NAME = "ElectricalCurrent";
    private static final String AMP_ERROR_MESSAGE = new ErrorMessageBuilder().setName("ElectricalCurrent").setLowerLimit(Double.toString(4.0)).setUpperLimit(Double.toString(20.0)).setUnit("mA").build();
    private static final String AMP_NOT_A_NUMBER = new ErrorMessageBuilder().setName("ElectricalCurrent").build();
    private static final ValidationStrategy MILLI_AMP_RANGE_VALIDATOR_ENGLISH = ValidationFactory.getRangeValidator((double)4.0, (double)20.0, (boolean)false, (String)AMP_ERROR_MESSAGE, (String)AMP_NOT_A_NUMBER);
    private static final AutoCorrectionValidator ELECTRICAL_CURRENT_VALIDATOR_ENGLISH = new AutoCorrectionRangeDecorator(MILLI_AMP_RANGE_VALIDATOR_ENGLISH, 4.0, 20.0);
    private static final ValidationStrategy VOLTAGE_RANGE_VALIDATOR = ValidationFactory.getRangeValidator((double)0.0, (double)10.0, (String)LanguagePack.getTextResource().errorAnalogOutputRangeVolts());
    private static final AutoCorrectionValidator ELECTRIC_POTENTIAL_VALIDATOR = new AutoCorrectionRangeDecorator(VOLTAGE_RANGE_VALIDATOR, 0.0, 10.0);
    private static final String ELECTRICAL_POTENTIAL_NAME = "ElectricalPotential";
    private static final String VOLTAGE_ERROR_MESSAGE = new ErrorMessageBuilder().setName("ElectricalPotential").setLowerLimit(Double.toString(0.0)).setUpperLimit(Double.toString(10.0)).setUnit("V").build();
    private static final String VOLTAGE_NOT_A_NUMBER = new ErrorMessageBuilder().setName("ElectricalPotential").build();
    private static final ValidationStrategy VOLTAGE_RANGE_VALIDATOR_ENGLISH = ValidationFactory.getRangeValidator((double)0.0, (double)10.0, (boolean)false, (String)VOLTAGE_ERROR_MESSAGE, (String)VOLTAGE_NOT_A_NUMBER);
    private static final AutoCorrectionValidator ELECTRICAL_POTENTIAL_VALIDATOR_ENGLISH = new AutoCorrectionRangeDecorator(VOLTAGE_RANGE_VALIDATOR_ENGLISH, 0.0, 10.0);
    private final MinimumPulseTimeValidator minimumPulseTimeValidator;

    @Inject
    public SetNodeValidationStrategyProviderImpl(MinimumPulseTimeValidator minimumPulseTimeValidator) {
        this.minimumPulseTimeValidator = minimumPulseTimeValidator;
    }

    @Override
    public AutoCorrectionValidator getElectricalCurrentValidator() {
        return ELECTRICAL_CURRENT_VALIDATOR;
    }

    @Override
    public AutoCorrectionValidator getElectricalPotentialValidator() {
        return ELECTRIC_POTENTIAL_VALIDATOR;
    }

    @Override
    public AutoCorrectionValidator getElectricalCurrentValidatorEnglishInMA() {
        return ELECTRICAL_CURRENT_VALIDATOR_ENGLISH;
    }

    @Override
    public AutoCorrectionValidator getElectricalPotentialValidatorEnglishInV() {
        return ELECTRICAL_POTENTIAL_VALIDATOR_ENGLISH;
    }

    @Override
    public AutoCorrectionValidator getPulseTimeValidator() {
        return new AutoCorrectionValidator(){

            public String getNearestValidValue(String s) {
                return "0.5";
            }

            public boolean isValid(String s) {
                return SetNodeValidationStrategyProviderImpl.this.minimumPulseTimeValidator.isValid(s);
            }

            public String getErrorMessage(String s) {
                return SetNodeValidationStrategyProviderImpl.this.minimumPulseTimeValidator.getErrorMessage(s);
            }
        };
    }

    @Override
    public AutoCorrectionValidator getPulseTimeValidatorEnglish() {
        final AutoCorrectionValidator originalValidator = this.getPulseTimeValidator();
        return new AutoCorrectionValidator(){
            final AutoCorrectionValidator validator;
            {
                this.validator = autoCorrectionValidator;
            }

            public boolean isValid(String s) {
                return this.validator.isValid(s);
            }

            public String getErrorMessage(String s) {
                return SetNodeValidationStrategyProviderImpl.this.minimumPulseTimeValidator.getErrorMessageEnglish(s);
            }

            public String getNearestValidValue(String s) {
                return originalValidator.getNearestValidValue(s);
            }
        };
    }
}

