/*
 * Decompiled with CFR 0.152.
 */
package gui.program.validation.impl;

import com.ur.i18n.TextResource;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.swing.units.Units;
import com.ur.swing.validation.AutoCorrectionRangeDecorator;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationFactory;
import gui.program.validation.ErrorMessageBuilder;
import gui.program.validation.SpeedValidationStrategyProvider;
import javax.inject.Inject;

public class SpeedValidationStrategyProviderImpl
implements SpeedValidationStrategyProvider {
    private static final double TOOL_MAX_SPEED = 3.0;
    private final JointConfigurationSettings jointConfigurationSettings;
    private TextResource textResource;

    @Inject
    public SpeedValidationStrategyProviderImpl(JointConfigurationSettings configurationSettings, TextResource textResource) {
        this.jointConfigurationSettings = configurationSettings;
        this.textResource = textResource;
    }

    @Override
    public AutoCorrectionValidator getJointSpeedLimitValidator() {
        double jointSpeedLimit = this.getJointSpeedLimit();
        String speedErrorMessage = this.textResource.valueOutOfRange(0.0, Units.getText().unitDegS(), jointSpeedLimit);
        return new AutoCorrectionRangeDecorator(ValidationFactory.getRangeValidator((double)0.0, (double)jointSpeedLimit, (String)speedErrorMessage), 0.0, jointSpeedLimit);
    }

    @Override
    public AutoCorrectionValidator getJointSpeedLimitValidatorEnglishDegS() {
        String name = "JointSpeed";
        double jointSpeedLimit = this.getJointSpeedLimit();
        String speedErrorMessage = new ErrorMessageBuilder().setName(name).setLowerLimit("0.0").setUpperLimit(Double.toString(jointSpeedLimit)).setUnit("\u00b0/s").build();
        String notANumberMessage = new ErrorMessageBuilder().setName(name).build();
        return this.getAutoCorrectionRangeValidatorEnglish(0.0, jointSpeedLimit, speedErrorMessage, notANumberMessage);
    }

    private double getJointSpeedLimit() {
        return URMath.roundUpDouble((double)Units.getDegreesPerSecondConverter().convertFrom(URMath.getMaxValue((double[])this.jointConfigurationSettings.getJointMaxSpeedWithoutTolerances())), (int)0);
    }

    @Override
    public AutoCorrectionValidator getCartesianJointSpeedLimitValidator() {
        double speedLimit = Math.floor(this.getToolSpeedLimit() * 10.0) / 10.0;
        String speedErrorMessage = this.textResource.valueOutOfRange(0.0, Units.getText().unitMmS(), speedLimit);
        return this.getAutoCorrectionRangeValidator(0.0, speedLimit, speedErrorMessage);
    }

    @Override
    public AutoCorrectionValidator getCartesianJointSpeedLimitValidatorEnglishMeterS() {
        String name = "Joint speed";
        double speedLimit = Math.ceil(3.0);
        String speedErrorMessage = new ErrorMessageBuilder().setLowerLimit(Double.toString(0.0)).setUpperLimit(Double.toString(3.0)).setName(name).setUnit("m/s").build();
        String notANumberMessage = new ErrorMessageBuilder().setName(name).build();
        return this.getAutoCorrectionRangeValidatorEnglish(0.0, speedLimit, speedErrorMessage, notANumberMessage);
    }

    private AutoCorrectionValidator getAutoCorrectionRangeValidator(double min, double max, String errorMessage) {
        return new AutoCorrectionRangeDecorator(ValidationFactory.getRangeValidator((double)min, (double)max, (String)errorMessage), min, max);
    }

    private AutoCorrectionValidator getAutoCorrectionRangeValidatorEnglish(double min, double max, String errorMessage, String notANumberMessage) {
        return new AutoCorrectionRangeDecorator(ValidationFactory.getRangeValidator((double)min, (double)max, (boolean)false, (String)errorMessage, (String)notANumberMessage), min, max);
    }

    private double getToolSpeedLimit() {
        return Units.getMmPerSecondConverter().convertFrom(3.0);
    }
}

