/*
 * Decompiled with CFR 0.152.
 */
package gui.program.validation.impl;

import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.swing.TextProvider;
import com.ur.swing.validation.AutoCorrectionValidator;
import gui.program.validation.TimerNodeValidationStrategyProvider;
import gui.tools.dialogs.input.NameValidationFactory;
import javax.inject.Inject;

public class TimerNodeValidationStrategyProviderImpl
implements TimerNodeValidationStrategyProvider {
    public static final String VARIABLE_NAME_ALREADY_EXISTS = "Variable name already exists";
    public static final String MAXIMUM_OF_D_CHARACTERS = "Maximum of '%d' characters.";
    public static final String ILLEGAL_VARIABLE_NAME = "Illegal Variable Name";
    private NamingService namingService;
    @Inject
    private TextResource textResource;

    @Inject
    public TimerNodeValidationStrategyProviderImpl(NamingService namingService) {
        this.namingService = namingService;
    }

    @Override
    public AutoCorrectionValidator getVariableNameValidator(TextProvider originalTextProvider, Class<? extends NamedEntity> namedEntityClass) {
        return NameValidationFactory.getVariableNameValidator(originalTextProvider, this.namingService, namedEntityClass, this.textResource);
    }

    @Override
    public AutoCorrectionValidator getVariableNameValidatorEnglish(TextProvider originalTextProvider, final Class<? extends NamedEntity> namedEntityClass) {
        final AutoCorrectionValidator variableNameValidator = this.getVariableNameValidator(originalTextProvider, namedEntityClass);
        return new AutoCorrectionValidator(){

            public String getNearestValidValue(String value) {
                return variableNameValidator.getNearestValidValue(value);
            }

            public boolean isValid(String uncheckedString) {
                return variableNameValidator.isValid(uncheckedString);
            }

            public String getErrorMessage(String text) {
                if (text.trim().isEmpty()) {
                    return "";
                }
                if (TimerNodeValidationStrategyProviderImpl.this.namingService.isNameValid(namedEntityClass, text)) {
                    if (TimerNodeValidationStrategyProviderImpl.this.namingService.isNameUsed(namedEntityClass, text.trim())) {
                        return TimerNodeValidationStrategyProviderImpl.VARIABLE_NAME_ALREADY_EXISTS;
                    }
                } else {
                    int maximumTextWidth = TimerNodeValidationStrategyProviderImpl.this.namingService.maxNameLength(namedEntityClass);
                    if (text.length() > maximumTextWidth) {
                        return String.format(TimerNodeValidationStrategyProviderImpl.MAXIMUM_OF_D_CHARACTERS, maximumTextWidth);
                    }
                }
                return TimerNodeValidationStrategyProviderImpl.ILLEGAL_VARIABLE_NAME;
            }
        };
    }
}

