/*
 * Decompiled with CFR 0.152.
 */
package gui.program.validation.impl;

import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.validation.AutoCorrectionRangeDecorator;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import gui.program.validation.ErrorMessageBuilder;
import gui.program.validation.UntilIONodeValidationStrategyProvider;
import gui.program.validation.WaitNodeValidationStrategyProvider;
import gui.tools.LanguagePack;

public class WaitNodeValidationStrategyProviderImpl
implements WaitNodeValidationStrategyProvider,
UntilIONodeValidationStrategyProvider {
    private static final double WAIT_TIME_LOWER_LIMIT = 0.0;
    private static final double WAIT_TIME_UPPER_LIMIT = Double.MAX_VALUE;
    private static final double ELECTRICAL_CURRENT_LOWER_LIMIT = 4.0;
    private static final double ELECTRICAL_CURRENT_UPPER_LIMIT = 20.0;
    private static final double ELECTRICAL_POTENTIAL_LOWER_LIMIT = 0.0;
    private static final double ELECTRICAL_POTENTIAL_UPPER_LIMIT = 10.0;
    private static final ValidationStrategy WAIT_TIME_VALIDATOR = ValidationFactory.getRangeValidator((double)0.0, (double)Double.MAX_VALUE, (UnitsConverter)Units.getTimeConverter());
    private static final AutoCorrectionValidator AUTOCORRECT_WAIT_TIME_VALIDATOR = new AutoCorrectionRangeDecorator(WAIT_TIME_VALIDATOR, 0.0, Double.MAX_VALUE);
    private static final String WAIT_TIME_ERROR_MESSAGE = new ErrorMessageBuilder().setName("Time").setLowerLimit(Double.toString(0.0)).setUnit("s").build();
    private static final String WAIT_TIME_NOT_A_NUMBER_MESSAGE = new ErrorMessageBuilder().setName("Time").build();
    private static final ValidationStrategy WAIT_TIME_VALIDATOR_ENGLISH = ValidationFactory.getRangeValidator((double)0.0, (double)Double.MAX_VALUE, (boolean)false, (String)WAIT_TIME_ERROR_MESSAGE, (String)WAIT_TIME_NOT_A_NUMBER_MESSAGE);
    private static final AutoCorrectionValidator AUTOCORRECT_WAIT_TIME_VALIDATOR_ENGLISH = new AutoCorrectionRangeDecorator(WAIT_TIME_VALIDATOR_ENGLISH, 0.0, Double.MAX_VALUE);
    private static final ValidationStrategy ELECTRICAL_CURRENT_VALIDATOR = ValidationFactory.getRangeValidator((double)4.0, (double)20.0, (String)LanguagePack.getTextResource().errorAnalogInputRangeAmps());
    private static final AutoCorrectionValidator AUTOCORRECT_ELECTRICAL_CURRENT_VALIDATOR = new AutoCorrectionRangeDecorator(ELECTRICAL_CURRENT_VALIDATOR, 4.0, 20.0);
    private static final String ELECTRICAL_CURRENT_ERROR_MESSAGE = new ErrorMessageBuilder().setName("Current").setLowerLimit(Double.toString(4.0)).setUpperLimit(Double.toString(20.0)).setUnit("mA").build();
    private static final String ELECTRICAL_CURRENT_NOT_A_NUMBER_MESSAGE = new ErrorMessageBuilder().setName("Current").build();
    private static final ValidationStrategy ELECTRICAL_CURRENT_VALIDATOR_ENGLISH = ValidationFactory.getRangeValidator((double)4.0, (double)20.0, (boolean)false, (String)ELECTRICAL_CURRENT_ERROR_MESSAGE, (String)ELECTRICAL_CURRENT_NOT_A_NUMBER_MESSAGE);
    private static final AutoCorrectionValidator AUTOCORRECT_ELECTRICAL_CURRENT_VALIDATOR_ENGLISH = new AutoCorrectionRangeDecorator(ELECTRICAL_CURRENT_VALIDATOR_ENGLISH, 4.0, 20.0);
    private static final ValidationStrategy ELECTRICAL_POTENTIAL_VALIDATOR = ValidationFactory.getRangeValidator((double)0.0, (double)10.0, (String)LanguagePack.getTextResource().errorAnalogInputRangeVolts());
    private static final AutoCorrectionValidator AUTOCORRECT_ELECTRICAL_POTENTIAL_VALIDATOR = new AutoCorrectionRangeDecorator(ELECTRICAL_POTENTIAL_VALIDATOR, 0.0, 10.0);
    private static final String ELECTRICAL_POTENTIAL_ERROR_MESSAGE = new ErrorMessageBuilder().setName("Voltage").setLowerLimit(Double.toString(0.0)).setUpperLimit(Double.toString(10.0)).setUnit("V").build();
    private static final String ELECTRICAL_POTENTIAL_NOT_A_NUMBER = new ErrorMessageBuilder().setName("Voltage").build();
    private static final ValidationStrategy ELECTRICAL_POTENTIAL_VALIDATOR_ENGLISH = ValidationFactory.getRangeValidator((double)0.0, (double)10.0, (boolean)false, (String)ELECTRICAL_POTENTIAL_ERROR_MESSAGE, (String)ELECTRICAL_POTENTIAL_NOT_A_NUMBER);
    private static final AutoCorrectionValidator AUTOCORRECT_ELECTRICAL_POTENTIAL_VALIDATOR_ENGLISH = new AutoCorrectionRangeDecorator(ELECTRICAL_POTENTIAL_VALIDATOR_ENGLISH, 0.0, 10.0);
    private static final ValidationStrategy FLOAT_VALIDATOR = ValidationFactory.getRangeValidator((double)1.4E-45f, (double)3.4028234663852886E38, (String)LanguagePack.getTextResource().valueOutOfRange(1.4E-45f, "", 3.4028234663852886E38));
    private static final AutoCorrectionValidator AUTO_CORRECT_FLOAT_VALIDATOR = new AutoCorrectionRangeDecorator(FLOAT_VALIDATOR, (double)1.4E-45f, 3.4028234663852886E38);

    @Override
    public AutoCorrectionValidator getWaitTimeValidator() {
        return AUTOCORRECT_WAIT_TIME_VALIDATOR;
    }

    @Override
    public AutoCorrectionValidator getElectricalCurrentValidator() {
        return AUTOCORRECT_ELECTRICAL_CURRENT_VALIDATOR;
    }

    @Override
    public AutoCorrectionValidator getElectricalPotentialValidator() {
        return AUTOCORRECT_ELECTRICAL_POTENTIAL_VALIDATOR;
    }

    @Override
    public AutoCorrectionValidator getNumberValidator() {
        return AUTO_CORRECT_FLOAT_VALIDATOR;
    }

    @Override
    public AutoCorrectionValidator getWaitTimeValidatorEnglishInS() {
        return AUTOCORRECT_WAIT_TIME_VALIDATOR_ENGLISH;
    }

    @Override
    public AutoCorrectionValidator getElectricalCurrentValidatorEnglishInMA() {
        return AUTOCORRECT_ELECTRICAL_CURRENT_VALIDATOR_ENGLISH;
    }

    @Override
    public AutoCorrectionValidator getElectricalPotentialValidatorEnglishInV() {
        return AUTOCORRECT_ELECTRICAL_POTENTIAL_VALIDATOR_ENGLISH;
    }
}

