/*
 * Decompiled with CFR 0.152.
 */
package gui.program.validation.impl;

import com.ur.i18n.TextResource;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.swing.units.Units;
import com.ur.swing.validation.AutoCorrectionRangeDecorator;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import gui.program.position.PositionNode;
import gui.program.position.WaypointNode;
import gui.program.validation.AccelerationValidationStrategyProvider;
import gui.program.validation.ErrorMessageBuilder;
import gui.program.validation.SpeedValidationStrategyProvider;
import gui.program.validation.WaypointNodeValidationStrategyProvider;
import gui.tools.LanguagePack;
import gui.tools.dialogs.input.NameValidationFactory;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class WaypointNodeValidationStrategyProviderImpl
implements WaypointNodeValidationStrategyProvider {
    private static final double BLEND_RADIUS_LOWER_LIMIT = 0.0;
    private static final double BLEND_RADIUS_UPPER_LIMIT = 1.0;
    private static final long MIN_TIME_VALUE_IN_SECS = 0L;
    private static final long MAX_TIME_VALUE_IN_SECS = TimeUnit.HOURS.toSeconds(6L);
    private static final String TXT_VARIABLE_NAME_ALREADY_EXISTS = "Variable name already exists";
    private static final String TXT_MAXIMUM_OF_CHARACTERS = "Maximum of '%d' characters.";
    private static final String TXT_ILLEGAL_VARIABLE_NAME = "Illegal Variable Name";
    private static final String OUT_OF_BOUNDS_ERROR_MESSAGE = LanguagePack.getTextResource().valueOutOfRange(0.0, "s", MAX_TIME_VALUE_IN_SECS);
    private static final ValidationStrategy TIME_VALIDATOR = ValidationFactory.getRangeValidator((double)0.0, (double)MAX_TIME_VALUE_IN_SECS, (String)OUT_OF_BOUNDS_ERROR_MESSAGE);
    private static final AutoCorrectionValidator AUTO_CORRECT_TIME_VALIDATOR = new AutoCorrectionRangeDecorator(TIME_VALIDATOR, 0.0, (double)MAX_TIME_VALUE_IN_SECS);
    private static final String TIME_ERROR_MESSAGE_ENGLISH = new ErrorMessageBuilder().setName("Time").setLowerLimit(Double.toString(0.0)).setUpperLimit(Double.toString(MAX_TIME_VALUE_IN_SECS)).setUnit("s").build();
    private static final String TIME_NOT_A_NUMBER_MESSAGE_ENGLISH = new ErrorMessageBuilder().setName("Time").build();
    private static final ValidationStrategy WAIT_TIME_VALIDATOR_ENGLISH = ValidationFactory.getRangeValidator((double)0.0, (double)MAX_TIME_VALUE_IN_SECS, (boolean)false, (String)TIME_ERROR_MESSAGE_ENGLISH, (String)TIME_NOT_A_NUMBER_MESSAGE_ENGLISH);
    private static final AutoCorrectionValidator AUTO_CORRECT_TIME_VALIDATOR_ENGLISH = new AutoCorrectionRangeDecorator(WAIT_TIME_VALIDATOR_ENGLISH, 0.0, (double)MAX_TIME_VALUE_IN_SECS);
    private final NamingService namingService;
    private final SpeedValidationStrategyProvider speedValidationStrategyProvider;
    private final AccelerationValidationStrategyProvider accelerationValidationStrategyProvider;
    private TextResource textResource;

    @Inject
    public WaypointNodeValidationStrategyProviderImpl(NamingService namingService, SpeedValidationStrategyProvider speedValidationStrategyProvider, AccelerationValidationStrategyProvider accelerationValidationStrategyProvider, TextResource textResource) {
        this.namingService = namingService;
        this.speedValidationStrategyProvider = speedValidationStrategyProvider;
        this.accelerationValidationStrategyProvider = accelerationValidationStrategyProvider;
        this.textResource = textResource;
    }

    private double findMaxBlendRadius(PositionNode positionNode) {
        if (positionNode == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (!positionNode.getPositionNodeType().equals((Object)PositionNodeType.FIXED)) {
            return Double.NEGATIVE_INFINITY;
        }
        double val = positionNode.findMaxBlendRadius();
        if (Double.compare(val, Double.MAX_VALUE) == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return val;
    }

    @Override
    public AutoCorrectionValidator getBlendRadiusValidator(double maxBlendRadius) {
        double min = this.getBlendRadiusLowerLimit();
        double max = this.getBlendRadiusUpperLimit();
        if (maxBlendRadius >= 0.0 && max >= maxBlendRadius) {
            max = maxBlendRadius;
        }
        return this.getAutoCorrectionRangeValidator(min, max, LanguagePack.getTextResource().errorBlendRange(min, max, Units.getText().unitMm()));
    }

    @Override
    public AutoCorrectionValidator getBlendRadiusValidator(PositionNode positionNode) {
        double min = this.getBlendRadiusLowerLimit();
        double max = this.findMaxBlendRadius(positionNode);
        max = Double.isInfinite(max) ? this.getBlendRadiusUpperLimit() : URMath.roundDouble((double)Math.max(0.0, Units.getMetersConverter().convertFrom(max)), (int)1);
        return this.getAutoCorrectionRangeValidator(min, max, LanguagePack.getTextResource().errorBlendRange(min, max, Units.getText().unitMm()));
    }

    @Override
    public AutoCorrectionValidator getBlendRadiusValidatorEnglishInM() {
        String name = "BlendRadius";
        return this.getAutoCorrectionRangeValidatorURCap(0.0, 1.0, new ErrorMessageBuilder().setLowerLimit(Double.toString(0.0)).setUpperLimit(Double.toString(1.0)).setName(name).setUnit("m").build(), new ErrorMessageBuilder().setName(name).build());
    }

    private AutoCorrectionValidator getAutoCorrectionRangeValidator(double min, double max, String errorMessage) {
        return new AutoCorrectionRangeDecorator(ValidationFactory.getRangeValidator((double)min, (double)max, (String)errorMessage), min, max);
    }

    private AutoCorrectionValidator getAutoCorrectionRangeValidatorURCap(double min, double max, String errorMessage, String notANumberMessage) {
        return new AutoCorrectionRangeDecorator(ValidationFactory.getRangeValidator((double)min, (double)max, (boolean)false, (String)errorMessage, (String)notANumberMessage), min, max);
    }

    @Override
    public AutoCorrectionValidator getWaypointNameValidator() {
        String variableExistsMsg = this.textResource.variableNameAlreadyExists();
        String illegalVariableNameMsg = this.textResource.illegalVariableName();
        return new NameValidationFactory.VariableNameValidatorWithWhiteList(false, this.namingService, WaypointNode.class, variableExistsMsg, illegalVariableNameMsg, this.textResource){

            @Override
            public boolean isValid(String uncheckedString) {
                this.setValidValues(WaypointNodeValidationStrategyProviderImpl.this.createValidValues());
                return super.isValid(uncheckedString);
            }
        };
    }

    @Override
    public AutoCorrectionValidator getWaypointNameValidatorEnglish() {
        final AutoCorrectionValidator waypointNameValidator = this.getWaypointNameValidator();
        return new AutoCorrectionValidator(){

            public String getNearestValidValue(String value) {
                return waypointNameValidator.getNearestValidValue(value);
            }

            public boolean isValid(String uncheckedString) {
                return waypointNameValidator.isValid(uncheckedString);
            }

            public String getErrorMessage(String text) {
                if (text.trim().isEmpty()) {
                    return "";
                }
                if (WaypointNodeValidationStrategyProviderImpl.this.namingService.isNameValid(WaypointNode.class, text)) {
                    if (WaypointNodeValidationStrategyProviderImpl.this.namingService.isNameUsed(WaypointNode.class, text.trim())) {
                        return WaypointNodeValidationStrategyProviderImpl.TXT_VARIABLE_NAME_ALREADY_EXISTS;
                    }
                    return "";
                }
                int maximumTextWidth = WaypointNodeValidationStrategyProviderImpl.this.namingService.maxNameLength(WaypointNode.class);
                if (text.length() > maximumTextWidth) {
                    return String.format(WaypointNodeValidationStrategyProviderImpl.TXT_MAXIMUM_OF_CHARACTERS, maximumTextWidth);
                }
                return WaypointNodeValidationStrategyProviderImpl.TXT_ILLEGAL_VARIABLE_NAME;
            }
        };
    }

    private String[] createValidValues() {
        HashSet exceptions = new HashSet();
        exceptions.addAll(this.namingService.getAllEntities().namesOfType(WaypointNode.class));
        return exceptions.toArray(new String[0]);
    }

    @Override
    public AutoCorrectionValidator getJointSpeedLimitValidator() {
        return this.speedValidationStrategyProvider.getJointSpeedLimitValidator();
    }

    @Override
    public AutoCorrectionValidator getJointSpeedLimitValidatorEnglishDegS() {
        return this.speedValidationStrategyProvider.getJointSpeedLimitValidatorEnglishDegS();
    }

    @Override
    public AutoCorrectionValidator getCartesianJointSpeedLimitValidator() {
        return this.speedValidationStrategyProvider.getCartesianJointSpeedLimitValidator();
    }

    @Override
    public AutoCorrectionValidator getCartesianJointSpeedLimitValidatorEnglishMeterS() {
        return this.speedValidationStrategyProvider.getCartesianJointSpeedLimitValidatorEnglishMeterS();
    }

    @Override
    public AutoCorrectionValidator getJointAccelerationLimitValidator() {
        return this.accelerationValidationStrategyProvider.getJointAccelerationLimitValidator();
    }

    @Override
    public AutoCorrectionValidator getJointAccelerationLimitValidatorEnglishInDegS2() {
        return this.accelerationValidationStrategyProvider.getJointAccelerationLimitValidatorEnglishInDegS2();
    }

    @Override
    public AutoCorrectionValidator getCartesianJointAccelerationLimitValidator() {
        return this.accelerationValidationStrategyProvider.getCartesianJointAccelerationLimitValidator();
    }

    @Override
    public AutoCorrectionValidator getCartesianJointAccelerationLimitValidatorEnglishInMeterS2() {
        return this.accelerationValidationStrategyProvider.getCartesianJointAccelerationLimitValidatorEnglishInMeterS2();
    }

    @Override
    public AutoCorrectionValidator getTimeValidator() {
        return AUTO_CORRECT_TIME_VALIDATOR;
    }

    @Override
    public AutoCorrectionValidator getTimeValidatorEnglishInS() {
        return AUTO_CORRECT_TIME_VALIDATOR_ENGLISH;
    }

    private double getBlendRadiusUpperLimit() {
        return Units.getMetersConverter().convertFrom(1.0);
    }

    private double getBlendRadiusLowerLimit() {
        return Units.getMetersConverter().convertFrom(0.0);
    }
}

