/*
 * Decompiled with CFR 0.152.
 */
package gui.program.validation.impl;

import com.ur.polyscope.program.nodes.waypoint.WaypointNodeValidators;
import com.ur.polyscope.valueobjects.validation.Validator;
import gui.program.validation.WaypointNodeValidationStrategyProvider;
import gui.program.validation.impl.AbstractNodeValidators;
import javax.inject.Inject;

public class WaypointNodeValidatorsImpl
extends AbstractNodeValidators
implements WaypointNodeValidators {
    private final Validator<Double> timeValidator;
    private final Validator<Double> jointSpeedLimitValidator;
    private final Validator<Double> cartesianJointSpeedLimitValidator;
    private final Validator<Double> cartesianJointAccelerationLimitValidator;
    private final WaypointNodeValidationStrategyProvider validationStrategyProvider;

    @Inject
    public WaypointNodeValidatorsImpl(WaypointNodeValidationStrategyProvider vsp) {
        this.timeValidator = WaypointNodeValidatorsImpl.wrap(vsp.getTimeValidatorEnglishInS());
        this.jointSpeedLimitValidator = WaypointNodeValidatorsImpl.wrap(vsp.getJointSpeedLimitValidatorEnglishDegS());
        this.cartesianJointSpeedLimitValidator = WaypointNodeValidatorsImpl.wrap(vsp.getCartesianJointSpeedLimitValidatorEnglishMeterS());
        this.cartesianJointAccelerationLimitValidator = WaypointNodeValidatorsImpl.wrap(vsp.getCartesianJointAccelerationLimitValidatorEnglishInMeterS2());
        this.validationStrategyProvider = vsp;
    }

    public Validator<Double> getTimeValidator() {
        return this.timeValidator;
    }

    public Validator<Double> getJointSpeedLimitValidator() {
        return this.jointSpeedLimitValidator;
    }

    public Validator<Double> getJointAccelerationLimitValidator() {
        return WaypointNodeValidatorsImpl.wrap(this.validationStrategyProvider.getJointAccelerationLimitValidatorEnglishInDegS2());
    }

    public Validator<Double> getCartesianJointSpeedLimitValidator() {
        return this.cartesianJointSpeedLimitValidator;
    }

    public Validator<Double> getCartesianJointAccelerationLimitValidator() {
        return this.cartesianJointAccelerationLimitValidator;
    }
}

