/*
 * Decompiled with CFR 0.152.
 */
package gui.swing.renderers;

import com.ur.polyscope.geomfeature.ProgramFeatureService;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.swing.renderers.contributed.ContributedHeading;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.GeomFeatureReferenceBase;
import gui.tools.util.FeatureComboBoxHelper;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;

public class FeatureComboBoxModel
extends DefaultComboBoxModel {
    private final ProgramReferenceService programReferenceService;
    private final boolean withFeatureVariables;

    public FeatureComboBoxModel(InstallationComponentLookup installationLookup, ProgramReferenceService programReferenceService, GeomFeatureReferenceBase featureReferenceToSelect, FeaturesLookup featuresLookup, boolean withFeatureVariables, ProgramFeatureService programFeatureService) {
        this.programReferenceService = programReferenceService;
        this.withFeatureVariables = withFeatureVariables;
        GeomFeature featureToSelect = featuresLookup.dereferenceByTopLevelFeature(featureReferenceToSelect.getKey());
        boolean featureMatch = false;
        if (featureToSelect == null || featureToSelect.isUndefined()) {
            this.addElement(featureReferenceToSelect);
            this.setSelectedItem((Object)featureReferenceToSelect);
            featureMatch = true;
        }
        List<GeomFeature> selectableFeatures = FeatureComboBoxHelper.getSelectableFeatures(installationLookup, programFeatureService);
        List<GeomFeature> nonContributedFeatures = FeatureComboBoxHelper.getNonContributedFeatures(selectableFeatures);
        Map<ContributedHeading, List<GeomPoseNodeContributed>> contributedMap = FeatureComboBoxHelper.createContributedMap(selectableFeatures);
        for (GeomFeature geomFeature : nonContributedFeatures) {
            GeomFeatureReferenceBase addedFeatureReference = this.addFeatureToModel(geomFeature);
            if (geomFeature != featureToSelect) continue;
            this.setSelectedItem((Object)addedFeatureReference);
            featureMatch = true;
        }
        for (Map.Entry entry : contributedMap.entrySet()) {
            this.addElement(entry.getKey());
            for (GeomPoseNodeContributed contributed : (List)entry.getValue()) {
                GeomFeatureReferenceBase addedFeatureReference = this.addFeatureToModel((GeomFeature)contributed);
                if (contributed != featureToSelect) continue;
                this.setSelectedItem((Object)addedFeatureReference);
                featureMatch = true;
            }
        }
        if (!featureMatch) {
            this.addElement(featureReferenceToSelect);
            this.setSelectedItem((Object)featureReferenceToSelect);
        }
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (anObject instanceof ContributedHeading) {
            return;
        }
        super.setSelectedItem(anObject);
    }

    private GeomFeatureReferenceBase addFeatureToModel(GeomFeature feature) {
        GeomFeatureReferenceBase featureReferenceToAdd = this.withFeatureVariables && feature.isVariable() ? this.programReferenceService.getGeomFeatureVariable(feature) : this.programReferenceService.getGeomFeatureReference(feature);
        this.addElement(featureReferenceToAdd);
        return featureReferenceToAdd;
    }
}

