/*
 * Decompiled with CFR 0.152.
 */
package gui.tools;

import com.ur.i18n.TextResource;
import com.ur.swing.dialog.ErrorMessage;
import javax.inject.Inject;

public class ErrorMessageProvider {
    private static final int MAX_FILE_NAME_LENGTH = 70;
    private static final int MAX_EXTENSION_LENGTH = 20;
    private final TextResource textBundle;

    @Inject
    public ErrorMessageProvider(TextResource textBundle) {
        this.textBundle = textBundle;
    }

    public ErrorMessage notARecognizedInstallationFile() {
        return new ErrorMessage(this.textBundle.installationLoading(), this.textBundle.notAnInstallationFile());
    }

    public ErrorMessage unableToSaveInstallationFile(String fileName) {
        return new ErrorMessage(this.textBundle.installationFile(), this.textBundle.couldNotSaveFile(ErrorMessageProvider.truncateFileNameIfNecessary(fileName)), this.textBundle.ensureSelectedSaveDirectoryExists());
    }

    public ErrorMessage unableToSaveProgram(String path) {
        return new ErrorMessage(this.textBundle.unableToSaveProgram(), this.textBundle.couldNotSaveProgramFileExplanation(path), this.textBundle.ensureSelectedSaveDirectoryExists());
    }

    public ErrorMessage unableToSaveScriptFile(String fileName) {
        return new ErrorMessage(this.textBundle.unableToSaveScriptFile(), this.textBundle.couldNotSaveFile(ErrorMessageProvider.truncateFileNameIfNecessary(fileName)), this.textBundle.ensureSelectedSaveDirectoryExists());
    }

    public ErrorMessage unableToFindRobotInstallation(String installationFileName) {
        return new ErrorMessage(this.textBundle.installationLoading(), this.textBundle.robotFileNotFound(ErrorMessageProvider.truncateFileNameIfNecessary(installationFileName)), this.textBundle.ifFileWasStoredOnExternalDeviceSuggestion());
    }

    public ErrorMessage validationError(String errorMessage) {
        return new ErrorMessage(this.textBundle.valueIsNotValid(), errorMessage);
    }

    public ErrorMessage invalidProgram(String name) {
        return new ErrorMessage(this.textBundle.loadProgram(), this.textBundle.invalidProgram(ErrorMessageProvider.truncateFileNameIfNecessary(name)));
    }

    public ErrorMessage cannotLoadProgram(String name) {
        return new ErrorMessage(this.textBundle.loadProgram(), this.textBundle.cannotPerformLoad(ErrorMessageProvider.truncateFileNameIfNecessary(name)));
    }

    public ErrorMessage cannotLoadProgramControllerNotConnected(String name) {
        return new ErrorMessage(this.textBundle.loadProgram(), this.textBundle.cannotPerformLoad(ErrorMessageProvider.truncateFileNameIfNecessary(name)), this.textBundle.controllerIsNotConnected());
    }

    public ErrorMessage notAProgram(String name) {
        return new ErrorMessage(this.textBundle.loadProgram(), this.textBundle.notAProgram(ErrorMessageProvider.truncateFileNameIfNecessary(name)));
    }

    public static String truncateFileNameIfNecessary(String fileName) {
        if (fileName.length() > 70) {
            String truncatedName = String.valueOf(fileName.substring(0, 70)) + "...";
            if (fileName.contains(".")) {
                String extension = fileName.substring(fileName.lastIndexOf("."));
                if (extension.length() > 20) {
                    return String.valueOf(truncatedName) + extension.substring(0, 20) + "...";
                }
                return String.valueOf(truncatedName) + extension;
            }
            return truncatedName;
        }
        return fileName;
    }
}

