/*
 * Decompiled with CFR 0.152.
 */
package gui.tools;

import com.ur.view.polyscope.urcap.URCapFunction;
import com.ur.view.polyscope.urcap.URCapFunctionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class ExpressionFunctionComboBoxContent {
    public static final String SEPARATOR = "--";
    private final URCapFunctionService urCapFunctionService;
    private static final String[] FUNCTION_NAMES = new String[]{"pose_add(<pose1>,<pose2>)", "pose_sub(<pose_to>,<pose_from>)", "pose_trans(<pose_from>,<pose_to>)", "pose_inv(<pose>)", "interpolate_pose(<pose_from>,<pose_to>,<alpha>)", "pose_dist(<pose_from>,<pose_to>)", "--", "get_actual_tcp_pose()", "get_actual_joint_positions()", "get_inverse_kin(<pose>)", "get_target_tcp_pose()", "get_target_tcp_speed()", "get_target_joint_positions()", "get_target_joint_speeds()", "--", "force()", "get_tcp_force()", "--", "integer_to_binary_list(<integer>)", "binary_list_to_integer(<list>)", "d2r(<deg>)", "r2d(<rad>)", "--", "read_port_bit(<address>)", "read_port_register(<address>)"};

    @Inject
    public ExpressionFunctionComboBoxContent(URCapFunctionService urCapFunctionService) {
        this.urCapFunctionService = urCapFunctionService;
    }

    public String getSeparator() {
        return SEPARATOR;
    }

    public String[] getFunctionNames() {
        return FUNCTION_NAMES;
    }

    public Map<UrCapHeading, List<String>> getUrCapVendorFunctionMap() {
        LinkedHashMap<UrCapHeading, List<String>> UrCapVendorFunctionMap = new LinkedHashMap<UrCapHeading, List<String>>();
        Collection<URCapFunction> urCapFunctions = this.urCapFunctionService.getFunctions();
        for (URCapFunction capFunction : urCapFunctions) {
            UrCapHeading urCapHeading = new UrCapHeading(capFunction.getURCapInformation().getName(), capFunction.getURCapInformation().getVendor());
            ArrayList<String> functions = (ArrayList<String>)UrCapVendorFunctionMap.get(urCapHeading);
            if (functions == null) {
                functions = new ArrayList<String>();
            }
            functions.add(this.createCapFunctionWithParameters(capFunction));
            UrCapVendorFunctionMap.put(urCapHeading, functions);
        }
        return UrCapVendorFunctionMap;
    }

    private String createCapFunctionWithParameters(URCapFunction urCapFunction) {
        String functionName = urCapFunction.getName();
        List<String> args = urCapFunction.getArguments();
        if (args != null && !args.isEmpty()) {
            functionName = String.valueOf(functionName) + "(";
            boolean addedParameters = false;
            for (String arg : args) {
                if (arg == null || arg.isEmpty()) continue;
                functionName = String.valueOf(functionName) + "<" + arg + ">,";
                addedParameters = true;
            }
            functionName = addedParameters ? functionName.substring(0, functionName.length() - 1) : functionName;
            functionName = String.valueOf(functionName) + ")";
        } else {
            functionName = String.valueOf(functionName) + "()";
        }
        return functionName;
    }

    @Deprecated
    public class UrCapHeading {
        private final String title;
        private final String vendor;

        public UrCapHeading(String title, String vendor) {
            this.title = title;
            this.vendor = vendor;
        }

        public String getTitle() {
            return this.title;
        }

        public String getVendor() {
            return this.vendor;
        }

        public boolean equals(Object other) {
            if (!(other instanceof UrCapHeading)) {
                return false;
            }
            UrCapHeading that = (UrCapHeading)other;
            return this.title.equals(that.getTitle()) && this.vendor.equals(that.getVendor());
        }

        public int hashCode() {
            int hashCode = 1;
            hashCode = hashCode * 37 + this.title.hashCode();
            hashCode = hashCode * 37 + this.vendor.hashCode();
            return hashCode;
        }
    }
}

