/*
 * Decompiled with CFR 0.152.
 */
package gui.tools;

import com.ur.swing.TableUtils;
import com.ur.swing.URFingerDragScrollMouseListener;
import gui.tools.LanguagePack;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class InstallationVariablesTable
extends JTable {
    private static final String[] TABLE_HEADER_NAMES = new String[]{LanguagePack.getTextResource().Variable(), LanguagePack.getTextResource().Value()};
    public static final String TABLE_NAME = "VariablesTable.table";

    public InstallationVariablesTable() {
        super(new DefaultTableModel(new Object[0][], TABLE_HEADER_NAMES){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }
        });
        this.setName(TABLE_NAME);
        this.configureTable();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (!this.isRowSelected(row)) {
            c.setBackground(TableUtils.getRowColor((int)row));
        }
        return c;
    }

    private void configureTable() {
        this.setRowSorter(new TableRowSorter<TableModel>(this.getModel()));
        this.getRowSorter().toggleSortOrder(0);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.getTableHeader().setReorderingAllowed(false);
        this.getColumnModel().getColumn(0).setResizable(false);
        this.getColumnModel().getColumn(1).setResizable(false);
        this.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.setRowHeight(22);
        Dimension dims = this.getTableHeader().getPreferredSize();
        dims.height = 24;
        this.getTableHeader().setPreferredSize(dims);
        this.setSelectionMode(0);
        this.getColumnModel().setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public int getLeadSelectionIndex() {
                return -1;
            }
        });
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        this.setFillsViewportHeight(true);
    }

    public void EnableURDragScroll(JTable table, SelectionListener owner) {
        MouseMotionListener[] mouseMotionListenerArray = this.getMouseMotionListeners();
        int n = mouseMotionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseMotionListener l = mouseMotionListenerArray[n2];
            this.removeMouseMotionListener(l);
            ++n2;
        }
        new VariablesTableMouseListener(table, owner);
        this.setAutoscrolls(false);
    }

    public void updateRow(String title, String message) {
        int i = 0;
        while (i < this.getModel().getRowCount()) {
            String name = (String)this.getModel().getValueAt(i, 0);
            if (name.equals(title)) {
                this.getModel().setValueAt(message, i, 1);
            }
            ++i;
        }
    }

    public static interface SelectionListener {
        public void selected(String var1, String var2);

        public void requestEdit(String var1, String var2);
    }

    private class VariablesTableMouseListener
    extends URFingerDragScrollMouseListener {
        private final SelectionListener owner;
        private final JTable table;

        public VariablesTableMouseListener(JTable table, SelectionListener ownerOfTable) {
            super((Component)table);
            this.table = table;
            this.owner = ownerOfTable;
        }

        public void mouseClicked(MouseEvent e) {
            int row = 0;
            switch (e.getClickCount()) {
                case 0: {
                    break;
                }
                case 1: {
                    if (InstallationVariablesTable.this.selectionModel.isSelectionEmpty()) break;
                    row = this.getClickedRow();
                    this.owner.selected(this.getNameForRow(row), this.getValueForRow(row));
                    break;
                }
                default: {
                    if (InstallationVariablesTable.this.selectionModel.isSelectionEmpty()) break;
                    row = this.getClickedRow();
                    this.owner.requestEdit(this.getNameForRow(row), this.getValueForRow(row));
                }
            }
        }

        private String getValueForRow(int row) {
            return (String)this.table.getModel().getValueAt(row, 1);
        }

        private String getNameForRow(int row) {
            return (String)this.table.getModel().getValueAt(row, 0);
        }

        private int getClickedRow() {
            int row = InstallationVariablesTable.this.getSelectionModel().getMinSelectionIndex();
            row = InstallationVariablesTable.this.convertRowIndexToModel(row);
            return row;
        }
    }
}

