/*
 * Decompiled with CFR 0.152.
 */
package gui.tools;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.EnumsResource;
import com.ur.i18n.EulaResource;
import com.ur.i18n.TextResource;
import com.ur.i18n.impl.CommandNamesResourceImpl;
import com.ur.i18n.impl.EnumsResourceImpl;
import com.ur.i18n.impl.EulaResourceImpl;
import com.ur.i18n.impl.TextResourceImpl;
import com.ur.injection.Binder;
import com.ur.injection.Builder;
import com.ur.injection.ServicesBinder;
import com.ur.lang.NamingUtils;
import com.ur.lang.resources.LocaleProvider;
import com.ur.swing.LanguageConfiguration;
import com.ur.util.logging.Log;
import com.ur.view.Settings;
import gui.tools.ConfirmationMessageProvider;
import gui.tools.ErrorMessageProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class LanguagePack
implements ServicesBinder {
    private static TextResource textBundle = null;
    private static CommandNamesResource commandNamesBundle = null;
    private static EnumsResource enumsBundle = null;
    private static EulaResource eulaBundle;

    static {
        LanguageConfiguration.SupportedLanguage language = Settings.getLanguage();
        if (Settings.isUsingEnglishProgramming()) {
            LanguagePack.setLanguageWithProgramInEnglish(language);
        } else {
            LanguagePack.setLanguage(language);
        }
    }

    public void bind(Binder binder) {
        binder.bindInstance(EulaResource.class, (Object)eulaBundle);
        binder.bindInstance(TextResource.class, (Object)textBundle);
        binder.bindInstance(CommandNamesResource.class, (Object)commandNamesBundle);
        binder.bindInstance(LocaleProvider.class, () -> Settings.getLanguage().getLocale());
        binder.bindInstance(EnumsResource.class, (Object)enumsBundle);
    }

    public void load(Builder builder) {
    }

    public static void testingForceEnglish() {
        Locale.setDefault(Locale.ENGLISH);
        LanguagePack.setLanguageWithProgramInEnglish(LanguageConfiguration.SupportedLanguage.en);
    }

    public static void setLanguageWithProgramInEnglish(LanguageConfiguration.SupportedLanguage language) {
        LanguagePack.setLanguage(language);
        commandNamesBundle = ((CommandNamesResourceImpl)commandNamesBundle).getDefaultLocale();
    }

    public static void setLanguage(LanguageConfiguration.SupportedLanguage language) {
        com.ur.log.logentry.LanguagePack.setLanguage((Locale)language.getLocale());
        Locale locale = language.getLocale();
        LocaleProvider provider = () -> locale;
        textBundle = new TextResourceImpl(provider);
        eulaBundle = new EulaResourceImpl(provider);
        commandNamesBundle = new CommandNamesResourceImpl(provider);
        enumsBundle = new EnumsResourceImpl(provider);
    }

    @Deprecated
    public static CommandNamesResource getCommandNamesResource() {
        return commandNamesBundle;
    }

    public static String getDefaultWaypointName() {
        String r = LanguagePack.getCommandNamesResource().waypointVariableName();
        r = NamingUtils.replaceSpacesWithUnderscores((String)r);
        r = NamingUtils.truncateNameToSupportNumbering((String)r);
        return r;
    }

    public static String getDefaultViaPointName() {
        String r = LanguagePack.getCommandNamesResource().viaPointVariableName();
        r = NamingUtils.replaceSpacesWithUnderscores((String)r);
        r = NamingUtils.truncateNameToSupportNumbering((String)r);
        return r;
    }

    public static String getDefaultEndPointName() {
        String r = LanguagePack.getCommandNamesResource().endPointVariableName();
        r = NamingUtils.replaceSpacesWithUnderscores((String)r);
        r = NamingUtils.truncateNameToSupportNumbering((String)r);
        return r;
    }

    private static String getDefaultTimerName() {
        String result = LanguagePack.getCommandNamesResource().timerVariableName();
        result = NamingUtils.replaceSpacesWithUnderscores((String)result);
        result = NamingUtils.truncateNameToSupportNumbering((String)result);
        return result;
    }

    @Deprecated
    public static String getCommandName(String key) {
        return commandNamesBundle.get(key);
    }

    @Deprecated
    public static TextResource getTextResource() {
        return textBundle;
    }

    public static ConfirmationMessageProvider getConfirmationMessages() {
        return new ConfirmationMessageProvider(textBundle);
    }

    public static ErrorMessageProvider getErrorMessages() {
        return new ErrorMessageProvider(textBundle);
    }

    @Deprecated
    public static String getText(String key) {
        if (key == null) {
            if (Log.canLog((Log.Level)Log.Level.DEBUG)) {
                Log.warning((String)"Key was given that was null", (Throwable)new Exception());
            }
            return "";
        }
        return textBundle.get(key);
    }

    public static Collection<String> getReservedCommandNames() {
        ArrayList<String> translatedCommandNames = new ArrayList<String>();
        try {
            for (String each : commandNamesBundle.getKeys()) {
                translatedCommandNames.add(commandNamesBundle.get(each));
            }
            translatedCommandNames.add(LanguagePack.getDefaultWaypointName());
            translatedCommandNames.add(LanguagePack.getDefaultTimerName());
        }
        catch (Exception e) {
            Log.error((String)"Failed to get all translated strings", (Throwable)e);
        }
        return translatedCommandNames;
    }

    public static void translateJText(JLabel label) {
        label.setText(LanguagePack.getText(label.getText()));
    }

    public static void translateJText(JButton button) {
        button.setText(LanguagePack.getText(button.getText()));
    }

    public static void translateJText(JPanel panel) {
        TitledBorder tb = (TitledBorder)panel.getBorder();
        tb.setTitle(LanguagePack.getText(tb.getTitle()));
    }
}

