/*
 * Decompiled with CFR 0.152.
 */
package gui.tools;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.dashboardserver.ScriptActionDefinitionParser;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.util.logging.Log;
import gui.tools.LegacyURDialogCreator;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

@ReadOnlyDashboardAction
public class PerformPopupAction
implements DashBoardAction {
    private static final Logger LOG = LogFactory.createLogger(PerformPopupAction.class);
    private static final ScriptActionDefinitionParser POPUP = new ScriptActionDefinitionParser("popup <rest>");
    private static final ScriptActionDefinitionParser CLOSE_POPUP = new ScriptActionDefinitionParser("close popup");

    public boolean canHandleMessage(String input) {
        return POPUP.isMatch(input) || CLOSE_POPUP.isMatch(input);
    }

    public String execute(String inputLine) {
        if (POPUP.isMatch(inputLine)) {
            final String popupText = POPUP.getArgument(0, inputLine);
            Log.info((String)("Showing dialog with text: " + inputLine));
            Runnable doWorkRunnable = new Runnable(){

                @Override
                public void run() {
                    LegacyURDialogCreator.showMessageDialog(popupText);
                }
            };
            SwingUtilities.invokeLater(doWorkRunnable);
            return "showing popup";
        }
        Runnable doWorkRunnable = new Runnable(){

            @Override
            public void run() {
                LegacyURDialogCreator.requestCancel();
            }
        };
        try {
            SwingUtilities.invokeAndWait(doWorkRunnable);
        }
        catch (InterruptedException e) {
            LOG.warn("Failed to close popup", (Throwable)e);
            return "Failed to close popup";
        }
        catch (InvocationTargetException e) {
            LOG.warn("Failed to close popup", (Throwable)e);
            return "Failed to close popup";
        }
        return "closing popup";
    }
}

