/*
 * Decompiled with CFR 0.152.
 */
package gui.tools;

import com.ur.i18n.TextResource;
import com.ur.log.GoToLog;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.initializerobot.RobotInitializationService;
import com.ur.view.hmc.ControllerSocketSender;
import gui.tools.dialogs.SafetyModeDialog.SafetyDialogAction;
import gui.tools.dialogs.SafetyModeDialog.SafetyDialogActionFactory;
import gui.tools.dialogs.SafetyModeDialog.SafetyModeDialogPanel;

public class SafetyModeDialogPanelFactory {
    private final SafetyDialogActionFactory safetyDialogActionFactory;

    public SafetyModeDialogPanelFactory(SafetyDialogActionFactory safetyDialogActionFactory) {
        this.safetyDialogActionFactory = safetyDialogActionFactory;
    }

    public SafetyModeDialogPanel getProtectiveStopDialog(RobotMessage rm, TextResource textResource) {
        Runnable performOnCloseAction = new Runnable(){

            @Override
            public void run() {
                ControllerSocketSender.sendUnlockProtectiveStop();
            }
        };
        SafetyDialogAction unlockButton = this.safetyDialogActionFactory.getDefaultRunnableAction(textResource.enableRobot(), performOnCloseAction);
        return new SafetyModeDialogPanel(rm, new SafetyDialogAction[]{unlockButton});
    }

    public SafetyModeDialogPanel getSimulatedProtectiveStopDialog(RobotMessage rm, TextResource textResource) {
        SafetyDialogAction unlockButton = this.safetyDialogActionFactory.getDefaultAction(textResource.enableRobot());
        return new SafetyModeDialogPanel(rm, new SafetyDialogAction[]{unlockButton});
    }

    public SafetyModeDialogPanel getProtectiveStopDialog(RobotMessage rm, GoToLog logService, TextResource textResource) {
        Runnable performOnCloseAction = new Runnable(){

            @Override
            public void run() {
                ControllerSocketSender.sendUnlockProtectiveStop();
            }
        };
        SafetyDialogAction unlockButton = this.safetyDialogActionFactory.getDefaultRunnableAction(textResource.enableRobot(), performOnCloseAction);
        SafetyDialogAction logButton = this.safetyDialogActionFactory.getGoToLogServiceAction(textResource.saveLog(), rm, logService);
        return new SafetyModeDialogPanel(rm, new SafetyDialogAction[]{unlockButton, logButton});
    }

    public SafetyModeDialogPanel getViolationDialog(RobotMessage rm, RobotInitializationService initializationService, GoToLog logService, TextResource textResource) {
        SafetyDialogAction initializeViolation = this.safetyDialogActionFactory.getDefaultRunnableAction(textResource.goToInitializationScreen(), this.getInitalizeRobotRunnable(initializationService));
        SafetyDialogAction cancelViolation = this.safetyDialogActionFactory.getAction(textResource.NotNow(), "SafetyModeDialog.CANCEL_BUTTON");
        SafetyDialogAction logViolation = this.safetyDialogActionFactory.getGoToLogServiceAction(textResource.saveLog(), rm, logService);
        return new SafetyModeDialogPanel(rm, new SafetyDialogAction[]{initializeViolation, logViolation, cancelViolation});
    }

    public SafetyModeDialogPanel getViolationDialog(RobotMessage rm, TextResource textResource) {
        SafetyDialogAction cancelViolation = this.safetyDialogActionFactory.getDefaultAction(textResource.goToInitializationScreen());
        return new SafetyModeDialogPanel(rm, new SafetyDialogAction[]{cancelViolation});
    }

    public SafetyModeDialogPanel getEStopDialog(RobotMessage rm, RobotInitializationService initializationService, GoToLog goToLogService, TextResource textResource) {
        SafetyDialogAction initializeEstop = this.safetyDialogActionFactory.getDefaultRunnableAction(textResource.goToInitializationScreen(), this.getInitalizeRobotRunnable(initializationService));
        SafetyDialogAction cancelEstop = this.safetyDialogActionFactory.getAction(textResource.NotNow(), "SafetyModeDialog.CANCEL_BUTTON");
        SafetyDialogAction logEstop = this.safetyDialogActionFactory.getGoToLogServiceAction(textResource.saveLog(), rm, goToLogService);
        return new SafetyModeDialogPanel(rm, new SafetyDialogAction[]{initializeEstop, logEstop, cancelEstop});
    }

    public SafetyModeDialogPanel getEStopDialog(RobotMessage rm, TextResource textResource) {
        SafetyDialogAction cancelEstop = this.safetyDialogActionFactory.getDefaultAction(textResource.goToInitializationScreen());
        return new SafetyModeDialogPanel(rm, new SafetyDialogAction[]{cancelEstop});
    }

    public SafetyModeDialogPanel getRecoveryDialog(RobotMessage rm, TextResource textResource) {
        SafetyDialogAction recoveryOk = this.safetyDialogActionFactory.getDefaultAction(textResource.OK());
        return new SafetyModeDialogPanel(rm, new SafetyDialogAction[]{recoveryOk});
    }

    public Runnable getInitalizeRobotRunnable(final RobotInitializationService initializationService) {
        return new Runnable(){

            @Override
            public void run() {
                initializationService.forceInitializeRobotNow();
            }
        };
    }
}

