/*
 * Decompiled with CFR 0.152.
 */
package gui.tools;

import com.ur.i18n.TextResource;
import com.ur.log.GoToLog;
import com.ur.log.GoToLogConsumer;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.SafetyModes;
import com.ur.polyscope.driver.api.dialog.DialogWithName;
import com.ur.polyscope.initializerobot.RobotInitializationService;
import com.ur.polyscope.security.ClosePopup;
import com.ur.swing.GuiUtilities;
import com.ur.swing.JFrameUtils;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.CloseDialogListener;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogButtonListener;
import com.ur.swing.dialog.DialogExecutor;
import com.ur.swing.dialog.DialogHandler;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.DialogPriority;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.DialogRunnable;
import com.ur.swing.dialog.DialogTask;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.InformationMessage;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.MultiPaneMessagePanelFactory;
import com.ur.swing.dialog.OkCancelDialogListener;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.dialog.OptionDialogListener;
import com.ur.swing.dialog.OptionMessage;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.swing.dialog.WarningMessage;
import com.ur.swing.dialog.YesNoCancelDialogListener;
import com.ur.util.logging.Log;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.errorcodes.MessageSource;
import gui.tools.DialogCreator;
import gui.tools.LegacyURDialogCreator;
import gui.tools.NonBlockingDialogCreator;
import gui.tools.SafetyModeDialogPanelFactory;
import gui.tools.YesNoMessage;
import gui.tools.dialogs.AlwaysFalseGoToLog;
import gui.tools.dialogs.ConfirmMessageDialogPanel;
import gui.tools.dialogs.ExceptionDialogPanel;
import gui.tools.dialogs.MessageDialogPanel;
import gui.tools.dialogs.OptionMessageDialogPanel;
import gui.tools.dialogs.PopupShowingListener;
import gui.tools.dialogs.SafetyModeDialog.SafetyDialogAction;
import gui.tools.dialogs.SafetyModeDialog.SafetyDialogActionFactory;
import gui.tools.dialogs.SafetyModeDialog.SafetyModeDialogPanel;
import gui.tools.dialogs.SafetyRelatedPopupShowingListener;
import gui.tools.dialogs.SaveProgramChangesDialog;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

@Singleton
public class URDialogCreator
implements DialogCreator,
NonBlockingDialogCreator,
GoToLogConsumer,
ClosePopup {
    protected final Map<String, DialogReturnValue> settings2 = new HashMap<String, DialogReturnValue>();
    protected final int DIALOG_WINDOW_MARGIN = 40;
    protected final int MAX_QUEUE_SIZE = 10;
    protected final Object dialogLock = new Object();
    protected Provider<JDialog> jDialogProvider;
    public JDialog safetyModeDialog = null;
    protected SafetyMode previousSafetyMode;
    protected RobotMessage lastMessageSeen;
    protected final AtomicReference<JDialog> urDialog = new AtomicReference();
    public final DialogExecutor dialogQueue = new DialogExecutor(new DialogExecutor.ExecuteWhen(){

        public boolean canExecute() {
            return !URDialogCreator.this.isShowingADialog();
        }
    }, 10){

        public <T> void onNotAccepted(DialogTask<T> dialogTask) {
            Log.error((String)("Dialog not accepted : " + dialogTask.toString() + (URDialogCreator.this.isShowingADialog() ? " showing a dialog!" : " not showing any dialogs")));
        }
    };
    protected DialogReturnValue ignorePopups = null;
    protected GoToLog goToLog = new AlwaysFalseGoToLog();
    private ViewContext viewContext;
    private final SafetyDialogActionFactory safetyDialogActionFactory;
    private final SafetyModeDialogPanelFactory safetyModeDialogPanelFactory;

    @Inject
    public URDialogCreator(Provider<JDialog> jDialogProvider, ViewContext viewContext) {
        this.jDialogProvider = jDialogProvider;
        this.viewContext = viewContext;
        this.safetyDialogActionFactory = new SafetyDialogActionFactory(this);
        this.safetyModeDialogPanelFactory = new SafetyModeDialogPanelFactory(this.safetyDialogActionFactory);
    }

    public void setViewContext(ViewContext viewContext) {
        this.viewContext = viewContext;
    }

    public ViewContext getViewContext() {
        return this.viewContext;
    }

    @Override
    public void closeDialog() {
        this.closeDialog(this.urDialog.get());
    }

    @Override
    public void closeDialog(JDialog dialog) {
        if (this.urDialog.get() != null && this.urDialog.get().equals(dialog)) {
            this.urDialog.set(null);
        }
        this.disposeDialog(dialog);
    }

    @Override
    public boolean isShowingADialog() {
        boolean isShowingNormalDialog = this.urDialog.get() != null && this.urDialog.get().isShowing();
        boolean isShowingSafetyDialog = this.isShowingASafetyDialog();
        return isShowingNormalDialog || isShowingSafetyDialog;
    }

    @Override
    public boolean isShowingASafetyDialog() {
        return this.safetyModeDialog != null && this.safetyModeDialog.isShowing();
    }

    @Override
    public boolean isDialogQueueEmpty() {
        return this.dialogQueue.isEmpty();
    }

    protected void disposeDialog(final JDialog dialog) {
        SwingUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (dialog != null) {
                    Log.trace((String)("Closing dialog: " + dialog.toString()));
                    dialog.dispose();
                }
            }
        });
    }

    private JDialog createDialog(String dialogName, String title, URDialogPanel urDialogPanel, DialogButtonListener listener) {
        JDialog dialog = (JDialog)this.jDialogProvider.get();
        dialog.setModal(true);
        dialog.setTitle(title);
        if (dialogName == null) {
            dialogName = "dialog." + urDialogPanel.getDialogType();
        }
        dialog.setName(dialogName);
        dialog.setDefaultCloseOperation(0);
        JPanel contentPanel = JFrameUtils.createDialogContent((String)title, (JComponent)urDialogPanel.getPanel());
        contentPanel.putClientProperty("buttonDialogListener", listener);
        this.addPanelToDialog(contentPanel, dialog);
        JFrameUtils.adjustHeightToFitInApplication((Component)dialog, (int)40);
        dialog.setAlwaysOnTop(true);
        dialog.pack();
        this.setDefaultButton(dialog);
        this.setFocusIfHasTextField(dialog);
        JFrameUtils.moveToCenter((JDialog)dialog, (int)0, (boolean)false);
        dialog.setResizable(false);
        return dialog;
    }

    private void setDefaultButton(JDialog dialog) {
        List comList = GuiUtilities.getComponentsOfType(JButton.class, (Container)dialog);
        if (!comList.isEmpty()) {
            JButton button = (JButton)comList.get(0);
            dialog.getRootPane().setDefaultButton(button);
        }
    }

    private void setFocusIfHasTextField(JDialog dialog) {
        List textFields = GuiUtilities.getComponentsOfType(JTextField.class, (Container)dialog);
        if (textFields.size() > 0) {
            ((JTextField)textFields.get(0)).requestFocus();
        }
    }

    private void addPanelToDialog(JPanel panel, JDialog dialog) {
        dialog.getContentPane().add(panel);
        dialog.validate();
        dialog.pack();
    }

    protected DialogButtonListener createOnClickListener() {
        return new DialogButtonListener(){

            public void onClick(Object returnValue) {
            }
        };
    }

    void internal_showNonBlockingDialog(DialogMessage dialogMessage, URDialogPanel panel, DialogButtonListener dialogButtonListener) {
        if (dialogButtonListener == null) {
            dialogButtonListener = this.createOnClickListener();
        }
        if (this.ignorePopups != null) {
            dialogButtonListener.onClick((Object)this.ignorePopups);
            return;
        }
        DialogRunnable<DialogReturnValue> dialogRunnable = this.createDialogRunnable(dialogMessage, panel, dialogButtonListener, DialogReturnValue.CANCEL);
        this.dialogQueue.execute(dialogRunnable);
    }

    protected DialogRunnable<DialogReturnValue> createDialogRunnable(final DialogMessage dialogMessage, final URDialogPanel panel, DialogButtonListener dialogButtonListener, DialogReturnValue defaultReturnValue) {
        return new DialogRunnable<DialogReturnValue>(dialogMessage, panel, defaultReturnValue, dialogButtonListener){

            public void run(DialogRunnable dialogRunnable) {
                panel.setDialogRunnable(dialogRunnable);
                URDialogCreator.this.threadSafeShowDialog(dialogMessage.getDialogName(), dialogMessage.getTitle(), panel, dialogRunnable);
            }
        };
    }

    private boolean canShowSimulatedSafety(RobotMessage rm) {
        if (this.lastMessageSeen == null) {
            return true;
        }
        if (this.isSimulatedSource(rm.source) && this.isRealSource(this.lastMessageSeen.source) && rm.safetyMode.getId() <= this.lastMessageSeen.safetyMode.getId()) {
            return false;
        }
        return rm.safetyMode.getId() >= this.currentSafetyModeBeingShown().getId();
    }

    private boolean isSimulatedSource(MessageSource source) {
        return source == MessageSource.SIMULATED_ROBOT;
    }

    private boolean isRealSource(MessageSource source) {
        return source != MessageSource.SIMULATED_ROBOT;
    }

    protected SafetyMode currentSafetyModeBeingShown() {
        return this.safetyModeDialog != null && this.safetyModeDialog.isVisible() ? this.previousSafetyMode : SafetyMode.NORMAL;
    }

    protected void internal_showSafetyModeDialog(final String dialogName, final String title, final URDialogPanel safetyModePanel) {
        JDialog finalSafetyDialog = this.safetyModeDialog;
        if (finalSafetyDialog != null && JFrameUtils.contains((Component)finalSafetyDialog.getContentPane(), (JPanel)safetyModePanel.getPanel())) {
            return;
        }
        SwingUtil.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                URDialogCreator.this.createSafetyDialog(dialogName, title, safetyModePanel);
            }
        });
    }

    private <V> void threadSafeShowDialog(String dialogName, String title, URDialogPanel panel, DialogRunnable<V> dialogRunnable) {
        if (this.performThreadSafeShowDialog(dialogName, title, panel, dialogRunnable)) {
            Log.trace((String)("Exiting dialog with title = \"" + title + "\" and name = \"" + dialogName + "\""));
        }
    }

    private <V> boolean performThreadSafeShowDialog(String dialogName, String title, URDialogPanel panel, DialogRunnable<V> dialogRunnable) throws SecurityException {
        if (!SwingUtil.isUiOrEventThread()) {
            Log.error((String)("Showing dialog with title = \"" + title + "\" and name= \"" + dialogName + "\" on non UI Thread!"));
        }
        Log.trace((String)("Showing dialog with title:\"" + title + "\" and name = \"" + dialogName + "\""));
        if (this.urDialog.get() != null) {
            if (this.urDialog.get().isShowing()) {
                Log.error((String)("A dialog is already showing, dialog with title = \"" + title + "\" and name = \"" + dialogName + "\" skipped!"));
                return false;
            }
            this.disposeDialog(this.urDialog.get());
        }
        this.urDialog.set(this.createDialog(dialogName, title, panel, dialogRunnable.getDialogButtonListener()));
        this.urDialog.get().addWindowListener(new PopupShowingListener(this.urDialog.get(), dialogRunnable, panel.getDialogType(), this));
        this.urDialog.get().setVisible(true);
        this.closeDialog(this.urDialog.get());
        return true;
    }

    @Override
    public boolean popupSafetyModeDialog(RobotMessage rm) {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        return this.internalPopupSafetyModeDialog(rm, new PopupSafetyModeDialogs(this.safetyModeDialogPanelFactory.getProtectiveStopDialog(rm, textResource), this.safetyModeDialogPanelFactory.getViolationDialog(rm, textResource), this.safetyModeDialogPanelFactory.getEStopDialog(rm, textResource), this.safetyModeDialogPanelFactory.getRecoveryDialog(rm, textResource)));
    }

    @Override
    public boolean popupSafetyModeDialog(RobotMessage rm, RobotInitializationService initializationService) {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        return this.internalPopupSafetyModeDialog(rm, new PopupSafetyModeDialogs(this.safetyModeDialogPanelFactory.getProtectiveStopDialog(rm, this.goToLog, textResource), this.safetyModeDialogPanelFactory.getViolationDialog(rm, initializationService, this.goToLog, textResource), this.safetyModeDialogPanelFactory.getEStopDialog(rm, initializationService, this.goToLog, textResource), this.safetyModeDialogPanelFactory.getRecoveryDialog(rm, textResource)));
    }

    private boolean internalPopupSafetyModeDialog(RobotMessage rm, PopupSafetyModeDialogs dialogs) {
        SafetyMode safetyMode;
        if (rm.safetyMode.getId() < this.currentSafetyModeBeingShown().getId()) {
            this.lastMessageSeen = rm;
            return false;
        }
        this.lastMessageSeen = rm;
        this.previousSafetyMode = safetyMode = rm.safetyMode;
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        switch (SafetyModes.getSafetyModeCategory((SafetyMode)safetyMode)) {
            case PROTECTIVE_STOP: {
                this.internal_showSafetyModeDialog(DialogWithName.SAFETY_MESSAGE.getName(), textResource.SafetyMessage(), dialogs.protectiveStopDialog);
                break;
            }
            case VIOLATION: 
            case FAULT: {
                this.internal_showSafetyModeDialog(DialogWithName.SAFETY_MESSAGE.getName(), textResource.SafetyMessage(), dialogs.violationDialog);
                break;
            }
            case EMERGENCY_STOP: {
                this.internal_showSafetyModeDialog(DialogWithName.SAFETY_MESSAGE.getName(), textResource.emergencyStopped(), dialogs.eStopDialog);
                break;
            }
            case RECOVERY: {
                this.internal_showSafetyModeDialog(DialogWithName.SAFETY_MESSAGE.getName(), textResource.recoveryMode(), dialogs.recoveryDialog);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void createSafetyDialog(String dialogName, String title, URDialogPanel panel) {
        this.closeSafetyModeDialog();
        JDialog dialog = (JDialog)this.jDialogProvider.get();
        dialog.setModal(true);
        dialog.setTitle(title);
        this.safetyModeDialog = dialog;
        if (dialogName == null) {
            dialogName = "dialog." + panel.getDialogType();
        }
        dialog.setName(dialogName);
        dialog.setDefaultCloseOperation(0);
        JPanel contentPanel = JFrameUtils.createDialogContent((String)title, (JComponent)panel.getPanel());
        this.addPanelToDialog(contentPanel, dialog);
        JFrameUtils.adjustHeightToFitInApplication((Component)dialog, (int)40);
        dialog.setAlwaysOnTop(true);
        dialog.pack();
        dialog.addWindowListener(new SafetyRelatedPopupShowingListener(dialog, this));
        this.setDefaultButton(dialog);
        JFrameUtils.moveToCenter((JDialog)dialog, (int)0, (boolean)false);
        dialog.setVisible(true);
    }

    @Override
    public void closeSafetyModeDialog() {
        this.closeSafetyModeDialog(SafetyMode.FAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSafetyModeDialog(SafetyMode safetyMode) {
        JDialog pdialog = null;
        Object object = this.dialogLock;
        synchronized (object) {
            if (this.isCloseSafetyModeDialogValid(safetyMode)) {
                pdialog = this.safetyModeDialog;
                this.safetyModeDialog = null;
            }
        }
        this.disposeDialog(pdialog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSafetyModeDialog(JDialog dialog) {
        Object object = this.dialogLock;
        synchronized (object) {
            if (dialog == this.safetyModeDialog) {
                this.safetyModeDialog = null;
            }
        }
        this.disposeDialog(dialog);
    }

    private boolean isCloseSafetyModeDialogValid(SafetyMode safetyMode) {
        int currentSafetyModeShownId = this.currentSafetyModeBeingShown().getId();
        if (safetyMode.getId() >= currentSafetyModeShownId) {
            return true;
        }
        return safetyMode == SafetyMode.FAULT && currentSafetyModeShownId > SafetyMode.FAULT.getId();
    }

    private SafetyModeDialogPanel getSimulatedProtectiveStopDialog(RobotMessage rm, TextResource textResource) {
        SafetyDialogAction unlockButton = this.safetyDialogActionFactory.getDefaultAction(textResource.enableRobot());
        return new SafetyModeDialogPanel(rm, new SafetyDialogAction[]{unlockButton});
    }

    private DialogReturnValue getSuppressValue(String suppressKey) {
        if (suppressKey != null && this.settings2.containsKey(suppressKey)) {
            return this.settings2.get(suppressKey);
        }
        return null;
    }

    private DialogReturnValue getSuppressValue(DialogMessage message) {
        return this.getSuppressValue(message.getSuppressKey());
    }

    @Override
    @Deprecated
    public DialogReturnValue showConfirmationDialog(ConfirmationMessage message) {
        DialogReturnValue suppressValue = this.getSuppressValue((DialogMessage)message);
        if (suppressValue != null) {
            Log.info((String)("Suppressing dialog with key " + message.getSuppressKey() + " and value " + suppressValue));
            return suppressValue;
        }
        return LegacyURDialogCreator.confirmMessageDialog(message);
    }

    @Override
    public void showConfirmationDialogWithCustomMessagePanel(ConfirmationMessage confirmationMessage, JPanel customMessagePanel, ConfirmationDialogListener confirmationDialogListener) {
        ConfirmMessageDialogPanel confirmMessageDialog = new ConfirmMessageDialogPanel(customMessagePanel, confirmationMessage.getAction(), confirmationMessage.getCancelAction());
        this.internal_showNonBlockingDialog((DialogMessage)confirmationMessage, confirmMessageDialog, (DialogButtonListener)confirmationDialogListener);
    }

    public DialogHandler showConfirmationDialogWithCustomMessagePanel(ConfirmationMessage confirmationMessage, JPanel customMessagePanel, OkDialogListener okDialogListener) {
        ConfirmMessageDialogPanel confirmMessageDialog = new ConfirmMessageDialogPanel(this.viewContext, customMessagePanel, confirmationMessage.getAction());
        this.internal_showNonBlockingDialog((DialogMessage)confirmationMessage, confirmMessageDialog, (DialogButtonListener)okDialogListener);
        return () -> {
            if (confirmationMessage.getDialogName() != null) {
                this.closeDialogWithName(confirmationMessage.getDialogName());
            }
        };
    }

    private void closeDialogWithName(String dialogName) {
        if (this.urDialog.get() != null && dialogName.equals(this.urDialog.get().getName())) {
            this.closeDialog();
        }
    }

    @Override
    public void showMultiPaneConfirmationDialog(MultiPaneMessagePanelFactory dialogFactory, ConfirmationMessage message, Iterable<MultiPaneMessagePanelFactory.Pane> panes, OkCancelDialogListener listener) {
        DialogReturnValue suppressValue = this.getSuppressValue(message.getSuppressKey());
        if (suppressValue != null) {
            Log.info((String)("Suppressing dialog with key " + message.getSuppressKey() + " and value " + suppressValue));
            listener.onClick(suppressValue);
            return;
        }
        URDialogPanel dialog = dialogFactory.createConfirmationDialog(message, panes);
        this.internal_showNonBlockingDialog((DialogMessage)message, dialog, (DialogButtonListener)listener);
    }

    public void showOptionMessageDialog(OptionMessage optionMessage, OptionDialogListener optionDialogListener) {
        OptionMessageDialogPanel optionMessageDialog = new OptionMessageDialogPanel(optionMessage);
        this.internal_showNonBlockingDialog((DialogMessage)optionMessage, optionMessageDialog, (DialogButtonListener)optionDialogListener);
    }

    @Override
    public void showMultiPaneInformationDialog(MultiPaneMessagePanelFactory dialogFactory, InformationMessage message, Iterable<MultiPaneMessagePanelFactory.Pane> panes, OkCancelDialogListener listener) {
        DialogReturnValue suppressValue = this.getSuppressValue(message.getSuppressKey());
        if (suppressValue != null) {
            Log.info((String)("Suppressing dialog with key " + message.getSuppressKey() + " and value " + suppressValue));
            listener.onClick(suppressValue);
            return;
        }
        URDialogPanel dialog = dialogFactory.createInformationDialog(message, panes);
        this.internal_showNonBlockingDialog((DialogMessage)message, dialog, (DialogButtonListener)listener);
    }

    public void showErrorDialog(ErrorMessage errorMessage, OkDialogListener okDialogListener) {
        MessageDialogPanel panel = new MessageDialogPanel(errorMessage.getMessage(), errorMessage.getSuggestion(), MessageDialogType.ERROR);
        this.internal_showNonBlockingDialog((DialogMessage)errorMessage, panel, (DialogButtonListener)okDialogListener);
    }

    @Override
    public void showYesNoCancelDialog(YesNoMessage yesNoMessage, final YesNoCancelDialogListener yesNoCancelDialogListener) {
        OptionDialogListener optionDialogListener = new OptionDialogListener(){

            public void onCancelClicked() {
                yesNoCancelDialogListener.onCancelClicked();
            }

            public void onOption1Clicked() {
                yesNoCancelDialogListener.onYesClicked();
            }

            public void onOption2Clicked() {
                yesNoCancelDialogListener.onNoClicked();
            }

            public void onRejected() {
                yesNoCancelDialogListener.onRejected();
            }
        };
        this.showOptionMessageDialog(yesNoMessage, optionDialogListener);
    }

    @Override
    public void showExceptionDialog(RobotMessage robotMessage, Thread originalThread, Throwable originalException, CloseDialogListener closeDialogListener) {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        ErrorMessage errorMessage = new ErrorMessage(DialogWithName.RUNTIME_EXCEPTION.getName(), textResource.caugtUnhandledException(), originalException.toString(), "");
        errorMessage.setPriority(DialogPriority.LOW);
        ExceptionDialogPanel panel = new ExceptionDialogPanel(originalThread, originalException, robotMessage, textResource, this.goToLog);
        Log.error((String)"Caught an unhandled exception", (Throwable)originalException);
        this.internal_showNonBlockingDialog((DialogMessage)errorMessage, panel, (DialogButtonListener)closeDialogListener);
    }

    @Override
    public void showSaveProgramChangesDialog(String programName, YesNoCancelDialogListener listener) {
        DialogReturnValue suppressValue = this.getSuppressValue("suppressDialogSaveProgramChanges");
        if (suppressValue != null) {
            Log.info((String)("Suppressing dialog with key suppressDialogSaveProgramChanges and value " + suppressValue));
            listener.onClick(suppressValue);
            return;
        }
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        ConfirmationMessage confirmationMessage = new ConfirmationMessage(DialogWithName.PROGRAM_HAS_NOT_BEEN_SAVED.getName(), textResource.saveProgramQuestion(), programName, "yes.saveProgramChangesDialog", textResource.Cancel());
        this.internal_showNonBlockingDialog((DialogMessage)confirmationMessage, new SaveProgramChangesDialog(programName), (DialogButtonListener)listener);
    }

    @Override
    public void showBadRobotStateConfirmationDialog(ConfirmationMessage confirmationMessage, OkCancelDialogListener okCancelDialogListener) {
        ConfirmMessageDialogPanel panel = ConfirmMessageDialogPanel.createShowInitializationScreenDialog(this.viewContext, confirmationMessage);
        this.internal_showNonBlockingDialog((DialogMessage)confirmationMessage, panel, (DialogButtonListener)okCancelDialogListener);
    }

    @Override
    public boolean showSimulatedProtectiveStop(RobotMessage rm, TextResource textResource) {
        if (!this.canShowSimulatedSafety(rm)) {
            this.lastMessageSeen = rm;
            return false;
        }
        this.lastMessageSeen = rm;
        this.previousSafetyMode = rm.safetyMode;
        this.internal_showSafetyModeDialog(null, textResource.simSecurityStop(), this.getSimulatedProtectiveStopDialog(rm, textResource));
        return true;
    }

    @Override
    public void showErrorMessageWithCustomPanel(DialogMessage errorMessage, URDialogPanel panel, DialogButtonListener listener) {
        this.internal_showNonBlockingDialog(errorMessage, panel, listener);
    }

    public void showMessageDialog(DialogMessage dialogMessage, MessageDialogType messageType, OkDialogListener okDialogListener) {
        MessageDialogPanel messageDialog = new MessageDialogPanel(dialogMessage.getMessage(), messageType, true, false);
        this.internal_showNonBlockingDialog(dialogMessage, messageDialog, (DialogButtonListener)okDialogListener);
    }

    public void showWarningMessageDialog(WarningMessage message, OkDialogListener okDialogListener) {
        Log.warning((String)message.getMessage());
        this.internal_showNonBlockingDialog((DialogMessage)message, new MessageDialogPanel(message.getMessage(), MessageDialogType.WARNING), (DialogButtonListener)okDialogListener);
    }

    @Override
    public void showNonBlockingDialog(DialogMessage dialogMessage, URDialogPanel panel, DialogButtonListener listener) {
        this.internal_showNonBlockingDialog(dialogMessage, panel, listener);
    }

    @Override
    public void showNonBlockingDialog(DialogMessage dialogMessage, URDialogPanel panel) {
        this.internal_showNonBlockingDialog(dialogMessage, panel, this.createOnClickListener());
    }

    public void showConfirmationDialog(ConfirmationMessage message, ConfirmationDialogListener listener) {
        DialogReturnValue suppressValue = this.getSuppressValue((DialogMessage)message);
        if (suppressValue != null) {
            Log.info((String)("Suppressing dialog with key " + message.getSuppressKey() + " and value " + suppressValue));
            listener.onClick(suppressValue);
            return;
        }
        ConfirmMessageDialogPanel confirmMessageDialog = new ConfirmMessageDialogPanel(this.viewContext, message.getMessage(), message.getAction(), message.getCancelAction(), message.getIcon());
        this.internal_showNonBlockingDialog((DialogMessage)message, confirmMessageDialog, (DialogButtonListener)listener);
    }

    public void setGoToLog(GoToLog goToLog) {
        this.goToLog = goToLog;
    }

    public void requestToClose() {
        JDialog jDialog = this.urDialog.get();
        if (jDialog != null && jDialog.isShowing()) {
            this.closeDialog(jDialog);
        }
    }

    private static class PopupSafetyModeDialogs {
        protected SafetyModeDialogPanel protectiveStopDialog;
        protected SafetyModeDialogPanel violationDialog;
        protected SafetyModeDialogPanel eStopDialog;
        protected SafetyModeDialogPanel recoveryDialog;

        public PopupSafetyModeDialogs(SafetyModeDialogPanel protectiveStop, SafetyModeDialogPanel violation, SafetyModeDialogPanel eStop, SafetyModeDialogPanel recovery) {
            this.protectiveStopDialog = protectiveStop;
            this.violationDialog = violation;
            this.eStopDialog = eStop;
            this.recoveryDialog = recovery;
        }
    }
}

