/*
 * Decompiled with CFR 0.152.
 */
package gui.tools;

import com.ur.disk.Directories;
import com.ur.lang.featuretoggle.FeatureToggle;
import com.ur.util.logging.Log;
import com.ur.util.persist.FileUtils;
import gui.tools.PersistStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class URFileUtils {
    public static final String REQUEST_ZIPPED_FILES = "requestZippedFiles";
    private static final int NUMBER_OF_BACKUP_FILES = 10;
    private static final String CHARSET_NAME = "UTF8";

    public static boolean exists(String fullPathToFile) {
        return new File(fullPathToFile).exists();
    }

    public static boolean isGZippedFile(File file) throws IOException {
        if (!file.exists()) {
            return false;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            byte[] firstBytes = new byte[2];
            inputStream.read(firstBytes);
            int head = firstBytes[0] & 0xFF | firstBytes[1] << 8 & 0xFF00;
            boolean bl = 35615 == head;
            return bl;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeFile(String path, String contents) throws IOException {
        File newFile = new File(path);
        URFileUtils.writeFile(newFile, contents);
    }

    public static void writeFile(File file, String contents) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            fileOutputStream.write(contents.getBytes(StandardCharsets.UTF_8));
            fileOutputStream.getChannel().force(true);
            fileOutputStream.flush();
            fileOutputStream.getFD().sync();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> T readPossiblyCompressedFile(File file, PersistStrategy<T> strategy) throws IOException {
        if (URFileUtils.isGZippedFile(file)) {
            return URFileUtils.readCompressedFile(file, strategy);
        }
        return URFileUtils.readPlainTextFile(file, strategy);
    }

    private static <T> T readCompressedFile(File file, PersistStrategy<T> strategy) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            return URFileUtils.readCompressedStream(stream, strategy);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static <T> T readPlainTextFile(File file, PersistStrategy<T> strategy) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            return URFileUtils.readPlainTextStream(stream, strategy);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static <T> T readCompressedStream(InputStream stream, PersistStrategy<T> strategy) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (GZIPInputStream unzippedStream = new GZIPInputStream(stream);){
            return URFileUtils.readPlainTextStream(unzippedStream, strategy);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static <T> T readPlainTextStream(InputStream stream, PersistStrategy<T> strategy) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStreamReader reader = new InputStreamReader(stream, CHARSET_NAME);){
            return strategy.unmarshal(reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> void writePossiblyCompressedFile(File file, T instance, PersistStrategy<T> persistStrategy) throws IOException {
        if ((!file.exists() || URFileUtils.isGZippedFile(file)) && FeatureToggle.isActive((String)REQUEST_ZIPPED_FILES)) {
            URFileUtils.writeCompressedFile(file, instance, persistStrategy);
        } else {
            URFileUtils.writePlainTextFile(file, instance, persistStrategy);
        }
    }

    private static <T> void writeCompressedFile(File file, T instance, PersistStrategy<T> persistenceStrategy) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream stream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            URFileUtils.writeCompressedStream(stream, instance, persistenceStrategy);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static <T> void writePlainTextFile(File file, T instance, PersistStrategy<T> persistenceStrategy) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStream stream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            URFileUtils.writePlainTextStream(stream, instance, persistenceStrategy);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> void writeCompressedStream(OutputStream stream, T instance, PersistStrategy<T> persistenceStrategy) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (GZIPOutputStream zippingStream = new GZIPOutputStream(stream);){
            URFileUtils.writePlainTextStream(zippingStream, instance, persistenceStrategy);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static <T> void writePlainTextStream(OutputStream stream, T instance, PersistStrategy<T> persistenceStrategy) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, CHARSET_NAME);){
            persistenceStrategy.marshal(instance, writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getFileName(File file) {
        String dir = file.getParent();
        String path = file.getPath();
        String name = path.substring(dir.length() + 1, path.length());
        if (name.lastIndexOf(".") != -1) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    public static boolean isFilenameValid(File f) {
        try {
            String path = f.getCanonicalPath();
            int directory = -1;
            directory = path.lastIndexOf("/");
            if (directory != -1) {
                return new File(path.substring(0, directory)).exists();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean backupFile(File fileToBackup, String backupFileExtension) throws IOException {
        if (fileToBackup == null || !fileToBackup.exists()) {
            return false;
        }
        if (backupFileExtension == null || backupFileExtension.isEmpty()) {
            throw new IllegalArgumentException("backupFileExtention must be set");
        }
        File[] backupFiles = URFileUtils.getCurrentBackupFiles(fileToBackup, backupFileExtension);
        URFileUtils.shiftBackups(fileToBackup, backupFiles, backupFileExtension);
        return true;
    }

    private static File[] getCurrentBackupFiles(File fileToBackup, String backupFileExtension) {
        File[] existingBackupFiles = new File[10];
        String fileName = String.valueOf(fileToBackup.getParent()) + File.separator + URFileUtils.getFileName(fileToBackup);
        int i = 0;
        while (i < 10) {
            File backupFile = new File(String.valueOf(fileName) + "." + backupFileExtension + i);
            if (!backupFile.exists()) break;
            existingBackupFiles[i] = backupFile;
            ++i;
        }
        return existingBackupFiles;
    }

    private static void shiftBackups(File fileToBackup, File[] backupFiles, String backupFileExtension) throws IOException {
        int i = backupFiles.length - 1;
        while (i >= 0) {
            File file = backupFiles[i];
            if (URFileUtils.shouldRollFileBackups(i, file)) {
                String newFileName = String.valueOf(file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - 1)) + (i + 1);
                file.renameTo(new File(newFileName));
            }
            --i;
        }
        if (fileToBackup.exists()) {
            String fileName = String.valueOf(fileToBackup.getParent()) + File.separator + URFileUtils.getFileName(fileToBackup) + "." + backupFileExtension + "0";
            FileUtils.copy((String)fileToBackup.getAbsolutePath(), (String)fileName);
        }
    }

    private static boolean shouldRollFileBackups(int i, File file) {
        return i < 9 && file != null && file.exists();
    }

    public static void syncWriteFile(String localFilePath, String remoteFilePath) throws IOException {
        try {
            ProcessBuilder pb = new ProcessBuilder("rsync", "-avz", "-e", "ssh", localFilePath, remoteFilePath);
            Process p = pb.start();
            p.waitFor();
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }

    public static boolean areFilesCanonicallyEqual(File file1, File file2) {
        try {
            return file1.getCanonicalPath().equals(file2.getCanonicalPath());
        }
        catch (Exception e) {
            Log.error((String)"Cannot get canonical paths of files", (Throwable)e);
            return file1.getAbsolutePath().equals(file2.getAbsolutePath());
        }
    }

    public static String getRelativeToProgramPath(String fullPath, String fileName) {
        URI programsDirectoryAsURI = Directories.programs().toURI();
        URI installationFileAsURI = new File(fullPath, fileName).toURI();
        URI relativizedFilePathAsURI = programsDirectoryAsURI.relativize(installationFileAsURI);
        try {
            return URLDecoder.decode(relativizedFilePathAsURI.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.error((String)("Encoding exception occured path: " + e.getMessage()));
            return fileName;
        }
    }

    public static String getRelativeToCanonicalProgramPath(String fullPath, String fileName) {
        URI installationFileAsURI;
        URI programsDirectoryAsURI;
        try {
            programsDirectoryAsURI = Directories.programs().getCanonicalFile().toURI();
        }
        catch (Exception e) {
            Log.error((String)"Cannot get canonical programs directory path", (Throwable)e);
            programsDirectoryAsURI = Directories.programs().toURI();
        }
        try {
            installationFileAsURI = new File(fullPath, fileName).getCanonicalFile().toURI();
        }
        catch (Exception e) {
            Log.error((String)"Cannot get canonical installation path", (Throwable)e);
            installationFileAsURI = new File(fullPath, fileName).toURI();
        }
        URI relativizedFilePathAsURI = programsDirectoryAsURI.relativize(installationFileAsURI);
        try {
            return URLDecoder.decode(relativizedFilePathAsURI.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.error((String)("Encoding exception occured path: " + e.getMessage()));
            return fileName;
        }
    }

    public static String relativizeInstallationPath(String originPath, String destPath) {
        if (originPath.equals(destPath)) {
            return "";
        }
        String commonPrefix = StringUtils.getCommonPrefix((String[])new String[]{originPath, destPath});
        if (commonPrefix.lastIndexOf(File.separator) != commonPrefix.length() - 1) {
            commonPrefix = commonPrefix.substring(0, commonPrefix.lastIndexOf(File.separator) + 1);
        }
        String trimmedOriginPath = originPath.replaceFirst(commonPrefix, "");
        String trimmedDestPath = destPath.replaceFirst(commonPrefix, "");
        String[] originFolders = trimmedOriginPath.split(File.separator);
        int navigateBackAmount = originFolders.length - 1;
        String navigateBackString = ".." + File.separator;
        String relativePath = new String(new char[navigateBackAmount]).replace("\u0000", navigateBackString);
        relativePath = String.valueOf(relativePath) + trimmedDestPath;
        return FilenameUtils.removeExtension((String)relativePath);
    }

    public static String relativizeProgramPath(String originPath, String destPath) {
        if (originPath.equals(destPath)) {
            return "";
        }
        if (originPath.charAt(0) == '/') {
            originPath = originPath.replaceFirst("/", "");
        }
        if (destPath.charAt(0) == '/') {
            destPath = destPath.replaceFirst("/", "");
        }
        String[] originFolders = originPath.split(File.separator);
        String[] destFolders = destPath.split(File.separator);
        int i = 0;
        while (i < originFolders.length && i < destFolders.length) {
            if (!originFolders[i].equals(destFolders[i])) break;
            ++i;
        }
        int navigateBackAmount = originFolders.length - i;
        String navigateBackString = ".." + File.separator;
        String relativePath = new String(new char[navigateBackAmount]).replace("\u0000", navigateBackString);
        String trimmedDestPath = StringUtils.join((Object[])Arrays.copyOfRange(destFolders, i, destFolders.length), (String)File.separator);
        relativePath = "/" + relativePath + trimmedDestPath;
        return FilenameUtils.removeExtension((String)relativePath);
    }

    public static String unrelativizePath(String originalPath) {
        String[] originalFolders = originalPath.split(File.separator);
        ArrayList<String> canonicalFolders = new ArrayList<String>();
        int navigateBackAmount = 0;
        int i = originalFolders.length - 1;
        while (i > 0) {
            if ("..".equals(originalFolders[i])) {
                ++navigateBackAmount;
            } else if (navigateBackAmount > 0) {
                --navigateBackAmount;
            } else {
                canonicalFolders.add(originalFolders[i]);
            }
            --i;
        }
        canonicalFolders.add(originalFolders[0]);
        Collections.reverse(canonicalFolders);
        return StringUtils.join(canonicalFolders, (String)File.separator);
    }

    public static String unrelativizePathWithProgramsDir(String originalPath) {
        return URFileUtils.unrelativizePathWithProgramsDir(originalPath, Directories.programs().getPath());
    }

    public static String unrelativizePathWithProgramsDir(String originalPath, String programsDir) {
        if (originalPath.contains(programsDir)) {
            String[] paths = originalPath.split(programsDir, 2);
            return String.valueOf(paths[0]) + programsDir + URFileUtils.unrelativizePath(paths[1]);
        }
        return URFileUtils.unrelativizePath(originalPath);
    }

    public static void deleteDefaultInstallationFilesOnExit() {
        File inst = new File(Directories.programs(), "default.installation");
        File vars = new File(Directories.programs(), "default.variables");
        if (inst.exists()) {
            inst.deleteOnExit();
        }
        if (vars.exists()) {
            vars.deleteOnExit();
        }
    }

    public static class DefaultFacade
    implements Facade {
        @Override
        public void ensureFileExists(File file) throws FileNotFoundException {
            if (!file.exists()) {
                throw new FileNotFoundException("Does not exist: " + file.getAbsolutePath());
            }
        }

        @Override
        public <T> T readPossiblyCompressedFile(File file, PersistStrategy<T> strategy) throws IOException {
            return URFileUtils.readPossiblyCompressedFile(file, strategy);
        }

        @Override
        public <T> void writePossiblyCompressedFile(File file, T instance, PersistStrategy<T> persistenceStrategy) throws IOException {
            URFileUtils.writePossiblyCompressedFile(file, instance, persistenceStrategy);
        }

        @Override
        public String getFileName(File file) {
            return URFileUtils.getFileName(file);
        }

        @Override
        public boolean exists(Path filePath) {
            return filePath.toFile().exists();
        }

        @Override
        public boolean exists(String fileName) {
            return URFileUtils.exists(fileName);
        }

        @Override
        public Properties readPropertiesFromFile(String fileName) throws IOException {
            return FileUtils.readPropertiesFromFile((String)fileName);
        }

        @Override
        public void writePropertiesToFile(String fileName, Properties properties) throws IOException {
            FileUtils.writePropertiesToFile((String)fileName, (Properties)properties);
        }

        @Override
        public boolean isPropertiesFile(File file) throws FileNotFoundException {
            Scanner sc = new Scanner(file);
            int lineCnt = 0;
            Pattern p = Pattern.compile("\\w.*[=:] *.+");
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                ++lineCnt;
                if (line.startsWith("#") || p.matcher(line).matches()) continue;
                sc.close();
                return false;
            }
            sc.close();
            return lineCnt > 0;
        }
    }

    public static interface Facade {
        public <T> T readPossiblyCompressedFile(File var1, PersistStrategy<T> var2) throws IOException;

        public <T> void writePossiblyCompressedFile(File var1, T var2, PersistStrategy<T> var3) throws IOException;

        public String getFileName(File var1);

        public void ensureFileExists(File var1) throws FileNotFoundException;

        public boolean exists(Path var1);

        public boolean exists(String var1);

        public Properties readPropertiesFromFile(String var1) throws IOException;

        public void writePropertiesToFile(String var1, Properties var2) throws IOException;

        public boolean isPropertiesFile(File var1) throws FileNotFoundException;
    }
}

