/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs;

import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.swing.g5.DefaultComboBoxRenderer;
import com.ur.swing.renderers.contributed.ContributedHeading;
import com.ur.view.variables.core.Variable;
import gui.program.position.WaypointNode;
import gui.swing.renderers.FeatureRenderingStrategy;
import gui.swing.renderers.PinRenderingStrategy;
import gui.swing.renderers.VariableRenderingStrategy;
import gui.tools.ExpressionFunctionComboBoxContent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ComboBoxRenderingStrategy
extends DefaultComboBoxRenderer {
    private static final int DOUBLE_WIDTH = 450;
    private static final Color HEADER_FOREGROUND = UIManager.getColor("DropDownHeaderForeground");
    private static final Color HEADER_BACKGROUND = UIManager.getColor("DropDownHeaderBackground");
    private static final int HEADER_FONT_SIZE = UIManager.getInt("DropDownHeaderFontSize");
    private final JSeparator separator;
    private final PinRenderingStrategy pinRenderingStrategy;
    private final FeatureRenderingStrategy featureRenderingStrategy;
    private final VariableRenderingStrategy variableRenderingStrategy;
    private final boolean doubleWidth;

    public ComboBoxRenderingStrategy() {
        this(false);
    }

    public ComboBoxRenderingStrategy(boolean doubleWidth, FeatureRenderingStrategy featureRenderingStrategy) {
        this.doubleWidth = doubleWidth;
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.separator = new JSeparator(0);
        this.pinRenderingStrategy = new PinRenderingStrategy();
        this.featureRenderingStrategy = featureRenderingStrategy;
        this.variableRenderingStrategy = new VariableRenderingStrategy();
    }

    public ComboBoxRenderingStrategy(boolean doubleWidth) {
        this(doubleWidth, new FeatureRenderingStrategy());
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        this.setIcon(null);
        this.setText("");
        if (value instanceof Pin || value instanceof PinReference) {
            this.setText(this.pinRenderingStrategy.getText(value));
            this.setIcon(this.pinRenderingStrategy.getIcon(value));
        } else if (value instanceof WaypointNode) {
            this.setText(value.toString());
        } else if (value instanceof GeomFeature) {
            this.setText(this.featureRenderingStrategy.getText(value));
            this.setIcon(this.featureRenderingStrategy.getIcon(value));
        } else if (value instanceof Variable) {
            this.setText(this.variableRenderingStrategy.getText(value));
            this.setIcon(this.variableRenderingStrategy.getIcon(value));
        } else {
            if (value instanceof ExpressionFunctionComboBoxContent.UrCapHeading) {
                ExpressionFunctionComboBoxContent.UrCapHeading urCapHeading = (ExpressionFunctionComboBoxContent.UrCapHeading)value;
                this.renderUrCapTitle(list, urCapHeading);
                return this;
            }
            if (value instanceof ContributedHeading) {
                ContributedHeading heading = (ContributedHeading)value;
                this.renderHeadingTitle(list, heading);
                return this;
            }
            if (value instanceof String && "--".equals(value)) {
                return this.separator;
            }
            this.setText(value.toString());
        }
        if (this.doubleWidth) {
            this.setPreferredSize(new Dimension(450, this.getPreferredSize().height));
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setFont(list.getFont());
        return this;
    }

    private void renderUrCapTitle(JList list, ExpressionFunctionComboBoxContent.UrCapHeading urCapHeading) {
        this.setFont(new Font(list.getFont().getFontName(), 1, HEADER_FONT_SIZE));
        this.setText(String.valueOf(urCapHeading.getTitle()) + " - " + urCapHeading.getVendor());
        this.setBackground(HEADER_BACKGROUND);
        this.setForeground(HEADER_FOREGROUND);
    }

    private void renderHeadingTitle(JList list, ContributedHeading contributedHeading) {
        this.setFont(new Font(list.getFont().getFontName(), 1, HEADER_FONT_SIZE));
        this.setText(contributedHeading.getDisplayName());
        this.setBackground(HEADER_BACKGROUND);
        this.setForeground(HEADER_FOREGROUND);
    }
}

