/*
 * Decompiled with CFR 0.152.
 */
package gui.tools.dialogs;

import com.google.common.base.Optional;
import com.ur.i18n.TextResource;
import com.ur.lang.StringUtils;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.swing.dialog.URDialogType;
import com.ur.util.swing.HTML;
import gui.installation.services.LookupServiceFacade;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConfirmMessageDialogPanel
extends URDialogPanel {
    public static final String GOTO_INITIALIZE_ROBOT = "gotoInitScreen.MessageDialogPanel";
    public static final String CONFIRM_BUTTON = "confirm.confirmMessageDialog";
    public static final String CANCEL_BUTTON = "cancel.confirmMessageDialog";
    public static final String NOT_NOW = "notNow.MessageDialogPanel";
    protected JButton confirmButton;
    protected JButton cancelButton;
    private final String message;
    private final String confirmButtonText;
    private final String cancelButtonText;
    private final WidgetFactory widgetFactory;
    private TextResource textResource;
    private JPanel messageIconPanel;
    private JPanel messagePanel;
    private JPanel buttonPanel;
    private boolean custom;
    private final Optional<Icon> messageIcon;

    public ConfirmMessageDialogPanel(ViewContext viewContext, String message, String confirmButtonText) {
        this(viewContext, message, confirmButtonText, null, null);
        this.cancelButton.setVisible(false);
    }

    public ConfirmMessageDialogPanel(ViewContext viewContext, JPanel customMessagePanel, String confirmButtonText) {
        this(viewContext, "", confirmButtonText, "", null);
        this.messagePanel = customMessagePanel;
        this.custom = true;
        this.initComponents();
        this.cancelButton.setVisible(false);
    }

    public ConfirmMessageDialogPanel(ViewContext viewContext, JPanel customMessagePanel, String confirmButtonText, String cancelButtonText) {
        this(viewContext, "", confirmButtonText, cancelButtonText, null);
        this.messagePanel = customMessagePanel;
        this.custom = true;
        this.initComponents();
    }

    public ConfirmMessageDialogPanel(ViewContext viewContext, String message, String confirmButtonText, String cancelButtonText, Icon messageIcon) {
        this.widgetFactory = viewContext.createWidgetFactory();
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.message = message;
        this.confirmButtonText = confirmButtonText;
        this.cancelButtonText = StringUtils.isNullOrEmpty((String)cancelButtonText) ? this.textResource.Cancel() : cancelButtonText;
        this.messageIcon = Optional.fromNullable((Object)messageIcon);
        this.initComponents();
    }

    @Deprecated
    public ConfirmMessageDialogPanel(JPanel customMessagePanel, String confirmButtonText, String cancelButtonText) {
        this(LookupServiceFacade.get(ViewContext.class), customMessagePanel, confirmButtonText, cancelButtonText);
    }

    @Deprecated
    public ConfirmMessageDialogPanel(String message, String confirmButtonText) {
        this(LookupServiceFacade.get(ViewContext.class), message, confirmButtonText);
    }

    @Deprecated
    public ConfirmMessageDialogPanel(String message, String confirmButtonText, String cancelButtonText, Icon messageIcon) {
        this(LookupServiceFacade.get(ViewContext.class), message, confirmButtonText, cancelButtonText, messageIcon);
    }

    public JPanel getPanel() {
        return this;
    }

    public URDialogType getDialogType() {
        return URDialogType.CONFIRM;
    }

    private void initComponents() {
        if (this.hasCustomMessagePanel()) {
            this.initWithCustomMessagePanel();
        } else {
            this.initWithDefaultMessagePanel();
        }
    }

    private void initWithCustomMessagePanel() {
        this.initButtonPanel();
        this.setLayout(new BorderLayout());
        this.add(this.messagePanel, "Center");
        this.add(this.buttonPanel, "South");
    }

    private void initWithDefaultMessagePanel() {
        this.initMessageIconPanel();
        this.initMessagePanel();
        this.initButtonPanel();
        this.setLayout(new BorderLayout());
        this.add(this.messageIconPanel, "West");
        this.add(this.messagePanel, "Center");
        this.add(this.buttonPanel, "South");
    }

    private void initMessagePanel() {
        JLabel messageLabel = new JLabel();
        messageLabel.setText(HTML.html((String)this.message));
        this.handleLongMessages(messageLabel);
        this.messagePanel = new JPanel(new BorderLayout());
        this.messagePanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.messagePanel.add((Component)messageLabel, "Center");
    }

    private void handleLongMessages(JLabel messageLabel) {
        Dimension dimension = messageLabel.getPreferredSize();
        if (dimension.getWidth() > 520.0) {
            messageLabel.setText(HTML.html((String)HTML.maxWidth((int)400, (String)this.message)));
        }
    }

    private void initMessageIconPanel() {
        JLabel iconLabel = new JLabel();
        iconLabel.setHorizontalAlignment(0);
        iconLabel.setIcon((Icon)this.messageIcon.or((Object)ViewImageResource.metalWarning()));
        this.messageIconPanel = new JPanel();
        this.messageIconPanel.add(iconLabel);
    }

    private void initButtonPanel() {
        this.confirmButton = this.widgetFactory.createButton((Action)new AbstractActionDefinition(){
            {
                this.putValue("Function", ActionDefinition.Function.PRIMARY);
            }

            public void actionPerformed(ActionEvent e) {
                ConfirmMessageDialogPanel.this.confirmButtonActionPerformed();
            }
        });
        this.confirmButton.setText(this.confirmButtonText);
        this.confirmButton.setName(CONFIRM_BUTTON);
        this.cancelButton = new JButton();
        this.cancelButton.setText(this.cancelButtonText);
        this.cancelButton.setName(CANCEL_BUTTON);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfirmMessageDialogPanel.this.cancelButtonActionPerformed();
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.confirmButton);
        this.buttonPanel.add(this.cancelButton);
    }

    private boolean hasCustomMessagePanel() {
        return this.custom;
    }

    private void confirmButtonActionPerformed() {
        this.setReturnValueAndClose(DialogReturnValue.OK);
    }

    private void cancelButtonActionPerformed() {
        this.setReturnValueAndClose(DialogReturnValue.CANCEL);
    }

    JPanel getMessagePanel() {
        return this.messagePanel;
    }

    JButton getConfirmButton() {
        return this.confirmButton;
    }

    JButton getCancelButton() {
        return this.cancelButton;
    }

    public static ConfirmMessageDialogPanel createShowInitializationScreenDialog(ViewContext viewContext, ConfirmationMessage confirmationMessage) {
        String title = confirmationMessage.getTitle();
        String message = confirmationMessage.getMessage();
        String actionButtonText = confirmationMessage.getAction();
        String cancelButtonText = confirmationMessage.getCancelAction();
        ConfirmMessageDialogPanel result = new ConfirmMessageDialogPanel(viewContext, String.valueOf(HTML.p((String)title)) + HTML.br() + HTML.unorderedList((String)HTML.li((String)message)), actionButtonText, cancelButtonText, null);
        result.confirmButton.setName(GOTO_INITIALIZE_ROBOT);
        result.cancelButton.setName(NOT_NOW);
        return result;
    }
}

